/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import factorization.docs.DocumentationModule;
import factorization.docs.HtmlConversionTypesetter;
import factorization.shared.Core;
import factorization.util.PlayerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;

public class ExportHtml
implements ICommand {
    static HashSet<String> visited = new HashSet();
    static ArrayList<String> frontier = new ArrayList();

    public int compareTo(Object arg0) {
        if (arg0 instanceof ICommand) {
            ICommand other = (ICommand)arg0;
            return this.func_71517_b().compareTo(other.func_71517_b());
        }
        return 0;
    }

    public String func_71517_b() {
        return "html-fzdoc-export";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/html-fzdoc-export";
    }

    public List func_71514_a() {
        return null;
    }

    public boolean func_71519_b(ICommandSender icommandsender) {
        return icommandsender instanceof EntityPlayer && PlayerUtil.isCommandSenderOpped(icommandsender);
    }

    public List func_71516_a(ICommandSender icommandsender, String[] astring) {
        return null;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }

    public void func_71515_b(ICommandSender player, String[] args) {
        ExportHtml.resetLinks();
        while (!frontier.isEmpty()) {
            String f = frontier.remove(0);
            try {
                this.processFile(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processFile(String filename) throws IOException {
        Core.logInfo("Processing: " + filename, new Object[0]);
        String root = System.getProperty("fzdoc.webroot", "/FzDocs/");
        String outDir = System.getProperty("fzdoc.out", "/tmp/fzdoc-html/");
        File outfile = new File(outDir + filename + ".html");
        outfile.getParentFile().mkdirs();
        outfile.delete();
        FileOutputStream os = new FileOutputStream(outfile);
        PrintStream out = new PrintStream(os);
        out.println("<!doctype html>");
        out.println("<html>");
        out.println("<head>");
        out.println("<meta charset=\"utf-8\"/>");
        out.println("<title>The Factorization Manual</title>");
        out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + root + "man.css\">");
        out.println();
        out.println("</head>");
        out.println("<body>");
        try {
            HtmlConversionTypesetter conv = new HtmlConversionTypesetter(os, root);
            String text = DocumentationModule.readDocument(filename);
            conv.processText(text);
        }
        finally {
            out.println("</body>");
            out.println("</html>");
            ((OutputStream)os).close();
        }
    }

    public static void visitLink(String newLink) {
        if (visited.contains(newLink)) {
            return;
        }
        frontier.add(newLink);
        visited.add(newLink);
    }

    public static void resetLinks() {
        visited.clear();
        frontier.clear();
        ExportHtml.visitLink("index");
    }
}

