/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import factorization.docs.AbstractTypesetter;
import factorization.docs.IDocGenerator;
import factorization.docs.IconWord;
import factorization.docs.ItemWord;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidViewer
implements IDocGenerator {
    @Override
    public void process(AbstractTypesetter out, String arg) {
        for (Map.Entry entry : FluidRegistry.getRegisteredFluids().entrySet()) {
            String name2 = (String)entry.getKey();
            Fluid fluid = (Fluid)entry.getValue();
            out.append("\\seg \\nl \\nl");
            if (fluid.canBePlacedInWorld()) {
                ItemStack is = new ItemStack(fluid.getBlock());
                out.emitWord(new ItemWord(is));
                out.append(" ");
            } else {
                IIcon icon = fluid.getIcon();
                out.emitWord(new IconWord(null, icon, 234));
                out.append(" ");
            }
            out.append(String.format("\\u{%s}", name2));
            if (fluid.isGaseous()) {
                out.append("\\nl A gas");
            }
            if (!fluid.canBePlacedInWorld()) {
                out.append("\\nl Item-only");
            }
            out.append(String.format("\\nl Temperature: %s\u00b0K", fluid.getTemperature()));
            out.append(String.format("\\nl Density: %s kg/block", fluid.getDensity()));
            out.append("\\endseg");
        }
    }
}

