/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import factorization.docs.DocViewer;
import factorization.docs.Word;
import factorization.docs.WordPage;
import factorization.util.ItemUtil;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ItemWord
extends Word {
    ItemStack is = null;
    ItemStack[] entries = null;
    static int active_index;

    public ItemWord(ItemStack is) {
        super(ItemWord.getDefaultHyperlink(is));
        this.is = is;
        this.cleanWildlings();
    }

    public ItemWord(ItemStack[] entries) {
        super(ItemWord.getDefaultHyperlink(entries));
        if (entries.length == 0) {
            entries = null;
        }
        this.entries = entries;
        this.cleanWildlings();
    }

    public ItemWord(ItemStack is, String hyperlink) {
        super(hyperlink);
        this.is = is;
        this.cleanWildlings();
    }

    static String getDefaultHyperlink(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (ItemUtil.isWildcard(is, false)) {
            List<ItemStack> sub = ItemUtil.getSubItems(is);
            if (sub.isEmpty()) {
                return null;
            }
            is = sub.get(0);
        }
        return "cgi/recipes/" + is.func_77977_a();
    }

    static String getDefaultHyperlink(ItemStack[] items) {
        if (items == null || items.length == 0) {
            return null;
        }
        if (items.length == 1) {
            return ItemWord.getDefaultHyperlink(items[0]);
        }
        return null;
    }

    void cleanWildlings() {
        if (ItemUtil.isWildcard(this.is, false)) {
            List<ItemStack> out = ItemUtil.getSubItems(this.is);
            this.entries = out.toArray(new ItemStack[out.size()]);
            this.is = null;
        } else if (this.entries != null) {
            List<ItemStack> wildingChildren = null;
            for (ItemStack wildling : this.entries) {
                if (!ItemUtil.isWildcard(wildling, false)) continue;
                if (wildingChildren == null) {
                    wildingChildren = ItemUtil.getSubItems(wildling);
                    continue;
                }
                wildingChildren.addAll(ItemUtil.getSubItems(wildling));
            }
            if (wildingChildren != null && !wildingChildren.isEmpty()) {
                for (ItemStack nonWild : this.entries) {
                    if (ItemUtil.isWildcard(nonWild, true)) continue;
                    wildingChildren.add(nonWild);
                }
                this.entries = wildingChildren.toArray(new ItemStack[wildingChildren.size()]);
            }
        }
    }

    @Override
    public String getLink() {
        return ItemWord.getDefaultHyperlink(this.getItem());
    }

    public String toString() {
        return this.is + " ==> " + this.getLink();
    }

    @Override
    public int getWidth(FontRenderer font) {
        return 16;
    }

    @Override
    public int getPaddingAbove() {
        return (16 - WordPage.TEXT_HEIGHT) / 2;
    }

    @Override
    public int getPaddingBelow() {
        return WordPage.TEXT_HEIGHT + this.getPaddingAbove();
    }

    ItemStack getItem() {
        active_index = 0;
        if (this.is != null) {
            return this.is;
        }
        if (this.entries == null) {
            return null;
        }
        long now = System.currentTimeMillis() / 1000L;
        active_index = (int)(now %= (long)this.entries.length);
        return this.entries[active_index];
    }

    void itemErrored() {
        if (this.is != null) {
            this.is = null;
        }
        if (this.entries != null && active_index < this.entries.length) {
            this.entries[ItemWord.active_index] = null;
        }
    }

    @Override
    public int draw(DocViewer doc, int x, int y, boolean hover) {
        ItemStack toDraw = this.getItem();
        if (toDraw == null) {
            return 16;
        }
        y -= 4;
        GL11.glDisable((int)3553);
        float gray = DocViewer.dark_color_scheme ? 0.2f : 0.54509807f;
        GL11.glColor3f((float)gray, (float)gray, (float)gray);
        float z = 0.0f;
        float d = 16.0f;
        GL11.glBegin((int)7);
        GL11.glVertex3f((float)(x + 0), (float)(y + 0), (float)z);
        GL11.glVertex3f((float)(x + 0), (float)((float)y + d), (float)z);
        GL11.glVertex3f((float)((float)x + d), (float)((float)y + d), (float)z);
        GL11.glVertex3f((float)((float)x + d), (float)(y + 0), (float)z);
        GL11.glEnd();
        if (hover) {
            int color = this.getLinkColor(hover);
            byte r = (byte)(color >> 16 & 0xFF);
            byte g = (byte)(color >> 8 & 0xFF);
            byte b = (byte)(color >> 0 & 0xFF);
            GL11.glColor3b((byte)r, (byte)g, (byte)b);
            GL11.glLineWidth((float)1.0f);
            GL11.glBegin((int)2);
            GL11.glVertex3f((float)(x + 0), (float)(y + 0), (float)z);
            GL11.glVertex3f((float)(x + 0), (float)((float)y + d), (float)z);
            GL11.glVertex3f((float)((float)x + d), (float)((float)y + d), (float)z);
            GL11.glVertex3f((float)((float)x + d), (float)(y + 0), (float)z);
            GL11.glEnd();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glPushAttrib((int)1048575);
        try {
            doc.drawItem(toDraw, x, y);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.itemErrored();
            try {
                Tessellator.field_78398_a.func_78381_a();
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        GL11.glPopAttrib();
        return 16;
    }

    @Override
    public void drawHover(DocViewer doc, int mouseX, int mouseY) {
        ItemStack toDraw = this.getItem();
        if (toDraw == null) {
            return;
        }
        GL11.glPushAttrib((int)1048575);
        try {
            doc.drawItemTip(toDraw, mouseX, mouseY);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.itemErrored();
        }
        GL11.glPopAttrib();
    }
}

