/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import factorization.docs.AbstractTypesetter;
import factorization.docs.IDocGenerator;
import factorization.docs.ItemWord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryViewer
implements IDocGenerator {
    @Override
    public void process(AbstractTypesetter out, String arg) {
        Arrays.asList(OreDictionary.getOreNames());
        ArrayList<String> names = new ArrayList<String>();
        for (String name2 : OreDictionary.getOreNames()) {
            names.add(name2);
        }
        Collections.sort(names);
        ArrayList<String> bountiful = new ArrayList<String>();
        ArrayList<String> empties = new ArrayList<String>();
        ArrayList<String> singles = new ArrayList<String>();
        for (String name3 : names) {
            ArrayList ores = OreDictionary.getOres((String)name3);
            if (ores == null || ores.isEmpty()) {
                empties.add(name3);
                continue;
            }
            if (ores.size() == 1) {
                singles.add(name3);
                continue;
            }
            bountiful.add(name3);
        }
        boolean prev = false;
        if (!bountiful.isEmpty()) {
            prev = true;
            for (String name4 : bountiful) {
                this.show(out, name4);
            }
        }
        if (!singles.isEmpty()) {
            if (prev) {
                out.append("\\newpage");
            }
            prev = true;
            for (String name4 : singles) {
                this.show(out, name4);
            }
        }
        if (!empties.isEmpty()) {
            if (prev) {
                out.append("\\newpage");
            }
            prev = true;
            out.append("\\title{Empty Lists}");
            for (String name4 : empties) {
                out.append("\\nl");
                out.append(name4);
            }
        }
    }

    void show(AbstractTypesetter out, String name2) {
        ArrayList ores = OreDictionary.getOres((String)name2);
        out.append("\\seg");
        out.append(String.format("\\nl %s: ", name2));
        for (ItemStack is : ores) {
            out.emitWord(new ItemWord(is));
        }
        out.append("\\endseg");
    }
}

