/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.relauncher.ReflectionHelper;
import factorization.docs.AbstractTypesetter;
import factorization.docs.DocumentationModule;
import factorization.docs.IDocGenerator;
import factorization.docs.ItemWord;
import factorization.docs.TextWord;
import factorization.docs.Word;
import factorization.shared.Core;
import factorization.util.ItemUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeViewer
implements IDocGenerator {
    HashMap<String, ArrayList<ArrayList>> recipeCategories = null;
    ArrayList<String> categoryOrder = new ArrayList();
    HashMap<List<ItemStack>, String> reverseOD = new HashMap();
    static TreeMap<String, Iterable> customRecipes = new TreeMap();
    int recursion;
    HashSet<String> knownOres = new HashSet();

    public RecipeViewer() {
        for (String s : OreDictionary.getOreNames()) {
            this.knownOres.add(s);
        }
    }

    @Override
    public void process(AbstractTypesetter out, String arg) {
        if (this.recipeCategories == null || Core.dev_environ) {
            this.categoryOrder.clear();
            this.recipeCategories = new HashMap();
            this.reverseOD.clear();
            Core.logInfo("Loading recipe list", new Object[0]);
            this.setupReverseOD();
            this.loadRecipes();
            Core.logInfo("Done", new Object[0]);
        }
        if (arg == null || arg.equalsIgnoreCase("categories") || arg.isEmpty()) {
            out.append("\\title{Recipe Categories}\n\n");
            for (String cat : this.categoryOrder) {
                out.append(String.format("\\link{cgi/recipes/category/%s}{%s}\\nl", cat, cat));
            }
        } else if (arg.startsWith("category/")) {
            String cat = arg.replace("category/", "");
            if (this.recipeCategories.containsKey(cat)) {
                ArrayList<ArrayList> recipeList = this.recipeCategories.get(cat);
                this.writeRecipes(out, null, false, cat, recipeList);
            } else {
                out.error("Category not found: " + arg);
            }
        } else {
            ItemStack matching = null;
            boolean mustBeResult = false;
            if (!arg.equalsIgnoreCase("all")) {
                ArrayList<ItemStack> matchers;
                if (arg.startsWith("for/")) {
                    mustBeResult = true;
                    arg = arg.replace("for/", "");
                }
                if ((matchers = DocumentationModule.getNameItemCache().get(arg)) != null && !matchers.isEmpty()) {
                    matching = matchers.get(0);
                }
                if (matching == null) {
                    out.error("Couldn't find item: " + arg);
                    return;
                }
                out.append("\\nl");
            }
            for (String cat : this.categoryOrder) {
                ArrayList<ArrayList> recipeList = this.recipeCategories.get(cat);
                this.writeRecipes(out, matching, mustBeResult, cat, recipeList);
            }
        }
    }

    void writeRecipes(AbstractTypesetter out, ItemStack matching, boolean mustBeResult, String categoryName, ArrayList<ArrayList> recipes) {
        if (matching == null) {
            for (ArrayList recipe : recipes) {
                this.writeRecipe(out, recipe);
            }
        } else {
            boolean first = true;
            for (ArrayList recipe : recipes) {
                if (!this.recipeMatches(recipe, matching, mustBeResult)) continue;
                if (first) {
                    first = false;
                    if (categoryName != null) {
                        out.append("\\u{" + categoryName + "}\n\n");
                    }
                }
                this.writeRecipe(out, recipe);
            }
        }
    }

    boolean recipeMatches(ArrayList recipe, ItemStack matching, boolean mustBeResult) {
        for (Object part : recipe) {
            if (!(part instanceof ItemWord)) continue;
            ItemWord iw = (ItemWord)part;
            if (iw.is == null) continue;
            if (ItemUtil.identical(iw.is, matching) || ItemUtil.wildcardSimilar(iw.is, matching)) {
                return true;
            }
            if (!mustBeResult) continue;
            return false;
        }
        return false;
    }

    void writeRecipe(AbstractTypesetter out, ArrayList parts) {
        try {
            for (Object part : parts) {
                if (part instanceof String) {
                    out.append((String)part);
                    continue;
                }
                out.emitWord((Word)part);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void handleImc(FMLInterModComms.IMCMessage message) throws ReflectiveOperationException {
        if (!message.key.equals("AddRecipeCategory")) {
            return;
        }
        String[] cmd = message.getStringValue().split("\\|");
        String key = cmd[0];
        String className = cmd[1];
        String fieldName = cmd[2];
        Class<?> kl = RecipeViewer.class.getClassLoader().loadClass(className);
        Field field = kl.getField(fieldName);
        Object obj = field.get(null);
        customRecipes.put(key, (Iterable)obj);
    }

    void setupReverseOD() {
        for (String name2 : OreDictionary.getOreNames()) {
            ArrayList entries = OreDictionary.getOres((String)name2);
            this.reverseOD.put(entries, name2);
        }
    }

    void loadRecipes() {
        this.putCategory("Workbench", CraftingManager.func_77594_a().func_77592_b());
        this.putCategory("Furnace", FurnaceRecipes.func_77602_a().func_77599_b().entrySet());
        HashMap<String, ArrayList> ores = new HashMap<String, ArrayList>();
        for (String name2 : OreDictionary.getOreNames()) {
            ores.put("\"" + name2 + "\"", OreDictionary.getOres((String)name2));
        }
        this.putCategory("Ore Dictionary", ores.entrySet());
        for (Map.Entry<String, Iterable> entry : customRecipes.entrySet()) {
            this.putCategory(entry.getKey(), entry.getValue());
        }
    }

    void putCategory(String label, Iterable list) {
        try {
            this.recipeCategories.put(label, this.addAll(list));
            this.categoryOrder.add(label);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    ArrayList<ArrayList> addAll(Iterable list) {
        ArrayList<ArrayList> generated = new ArrayList<ArrayList>();
        for (Object obj : list) {
            ArrayList entry = new ArrayList();
            this.recursion = 0;
            this.addRecipe(entry, obj);
            if (entry.isEmpty()) continue;
            generated.add(entry);
        }
        return generated;
    }

    static String getDisplayName(ItemStack is) {
        if (is == null) {
            return "null";
        }
        try {
            return is.func_82833_r();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "ERROR";
        }
    }

    void addRecipe(List sb, Object obj) {
        sb.add("\\seg");
        if (obj instanceof IRecipe) {
            this.genericRecipePrefix(sb, (IRecipe)obj);
        }
        int origLen = sb.size();
        if (obj instanceof ShapedOreRecipe) {
            this.addShapedOreRecipe(sb, (ShapedOreRecipe)obj);
        } else if (obj instanceof ShapedRecipes) {
            this.addShapedRecipes(sb, (ShapedRecipes)obj);
        } else if (obj instanceof ShapelessOreRecipe) {
            this.addShapelessOreRecipe(sb, (ShapelessOreRecipe)obj);
        } else if (obj instanceof ShapelessRecipes) {
            this.addShapelessRecipes(sb, (ShapelessRecipes)obj);
        } else {
            try {
                this.addRecipeWithReflection(sb, obj);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (sb.size() == origLen) {
            sb.add(obj.toString());
        }
        sb.add("\\endseg");
        sb.add("\\nl");
    }

    Object genericRecipePrefix(List sb, IRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        if (output == null) {
            return null;
        }
        sb.add(new ItemWord(output));
        sb.add(" \\b{" + RecipeViewer.getDisplayName(output) + "}\\vpad{15}\\nl");
        return output;
    }

    static ItemStack fixMojangRecipes(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (is.field_77994_a > 1) {
            is = is.func_77946_l();
            is.field_77994_a = 1;
        }
        return is;
    }

    void addShapedOreRecipe(List sb, ShapedOreRecipe recipe) {
        int width = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)recipe, (String[])new String[]{"width"});
        Object[] input = recipe.getInput();
        int i = 0;
        for (Object in : input) {
            if (in instanceof ItemStack || in == null) {
                ItemStack is = (ItemStack)in;
                sb.add(new ItemWord(RecipeViewer.fixMojangRecipes(is)));
            } else if (in instanceof Iterable) {
                Iterator it = ((Iterable)in).iterator();
                if (it.hasNext()) {
                    this.convertObject(sb, it.next());
                } else {
                    this.convertObject(sb, null);
                }
            } else {
                this.convertObject(sb, in);
            }
            if (++i % width != 0) continue;
            sb.add("\\nl");
        }
    }

    void addShapedRecipes(List sb, ShapedRecipes recipe) {
        int width = recipe.field_77576_b;
        for (int i = 0; i < recipe.field_77574_d.length; ++i) {
            sb.add(new ItemWord(RecipeViewer.fixMojangRecipes(recipe.field_77574_d[i])));
            if ((i + 1) % width != 0) continue;
            sb.add("\\nl");
        }
    }

    void addShapelessOreRecipe(List sb, ShapelessOreRecipe recipe) {
        ArrayList input = recipe.getInput();
        if (input == null) {
            return;
        }
        sb.add("Shapeless: ");
        for (Object obj : input) {
            if (obj instanceof Object[]) {
                Object[] objs = (Object[])obj;
                if (objs.length > 0) {
                    this.convertObject(sb, objs[0]);
                    continue;
                }
                this.convertObject(sb, null);
                continue;
            }
            this.convertObject(sb, obj);
        }
    }

    void addShapelessRecipes(List sb, ShapelessRecipes recipe) {
        if (recipe.field_77579_b == null) {
            return;
        }
        sb.add("Shapeless: ");
        for (Object obj : recipe.field_77579_b) {
            this.convertObject(sb, obj);
        }
    }

    void addRecipeWithReflection(List sb, Object recipe) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        if (recipe instanceof ItemStack || recipe instanceof String || recipe.getClass().isArray() || recipe instanceof Collection) {
            this.convertObject(sb, recipe);
            return;
        }
        Object output = RecipeViewer.class;
        if (recipe instanceof IRecipe) {
            output = this.genericRecipePrefix(sb, (IRecipe)recipe);
        } else if (recipe instanceof Map.Entry) {
            Map.Entry ent = (Map.Entry)recipe;
            this.addRecipeWithReflection(sb, ent.getKey());
            sb.add(" \u27a4 ");
            this.addRecipeWithReflection(sb, ent.getValue());
            return;
        }
        for (Field f : fields = recipe.getClass().getDeclaredFields()) {
            Object v;
            int modifiers;
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            if (((modifiers = f.getModifiers()) & 8) != 0 || (v = f.get(recipe)) == output || v == null || !(v instanceof String) && !(v instanceof ItemStack) && !(v instanceof Collection) && !v.getClass().isArray()) continue;
            sb.add(f.getName() + ": ");
            this.convertObject(sb, v);
            sb.add("\\nl ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convertObject(List sb, Object obj) {
        block34: {
            String name2;
            if (obj == null) {
                return;
            }
            if (this.recursion > 4) {
                return;
            }
            if (obj instanceof Item) {
                obj = new ItemStack((Item)obj);
            } else if (obj instanceof Block) {
                obj = new ItemStack((Block)obj);
            } else if (obj instanceof String && this.knownOres.contains(name2 = (String)obj)) {
                obj = OreDictionary.getOres((String)name2);
            }
            ++this.recursion;
            try {
                if (obj instanceof ItemStack) {
                    sb.add(new ItemWord((ItemStack)obj));
                    break block34;
                }
                if (obj instanceof String) {
                    sb.add(obj.toString());
                    break block34;
                }
                if (obj.getClass().isArray()) {
                    Class<?> component = obj.getClass().getComponentType();
                    if (component == ItemStack.class) {
                        ItemStack[] array = (ItemStack[])obj;
                        if (array == null || array.length == 0) {
                            sb.add(new TextWord("<Empty>", null));
                        } else {
                            sb.add(new ItemWord(array));
                        }
                    } else if (component == Object.class) {
                        Object[] listy;
                        for (Object o : listy = (Object[])obj) {
                            if (o == null) {
                                sb.add("-");
                                continue;
                            }
                            this.convertObject(sb, o);
                        }
                    } else if (component == ItemStack.class) {
                        ItemStack[] listy;
                        for (ItemStack is : listy = (ItemStack[])obj) {
                            if (is == null) {
                                sb.add("-");
                                continue;
                            }
                            sb.add(new ItemWord(is));
                        }
                    }
                    break block34;
                }
                if (obj instanceof Collection) {
                    boolean probableOreDictionary = false;
                    if (obj instanceof List) {
                        probableOreDictionary = this.reverseOD.containsKey(obj);
                    }
                    if (probableOreDictionary) {
                        boolean bad = false;
                        for (Object o : (Collection)obj) {
                            if (o instanceof ItemStack) continue;
                            bad = true;
                            break;
                        }
                        if (!bad) {
                            Collection col = (Collection)obj;
                            ItemStack[] items = col.toArray(new ItemStack[col.size()]);
                            sb.add(new ItemWord(items));
                            return;
                        }
                    }
                    for (Object o : (Collection)obj) {
                        this.convertObject(sb, o);
                    }
                    break block34;
                }
                if (obj instanceof IRecipe) {
                    sb.add("Embedded Recipe:\n\n");
                    ArrayList sub = new ArrayList();
                    this.addRecipe(sub, obj);
                    sb.addAll(sub);
                    break block34;
                }
                try {
                    this.addRecipeWithReflection(sb, obj);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            finally {
                --this.recursion;
            }
        }
    }
}

