/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import factorization.docs.AbstractPage;
import factorization.docs.DocViewer;
import factorization.docs.TextWord;
import factorization.docs.Word;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;

public class WordPage
extends AbstractPage {
    ArrayList<ArrayList<Word>> text = new ArrayList();
    Object figure;
    static int TEXT_HEIGHT = 9;
    int lineLen = 0;
    FontRenderer font;

    WordPage(FontRenderer font) {
        this.font = font;
        if (font != null) {
            TEXT_HEIGHT = font.field_78288_b;
        }
        this.nl();
    }

    void add(Word word) {
        if (word instanceof TextWord) {
            TextWord tw = (TextWord)word;
            if (tw.text == "\t") {
                word = new TextWord("    ", word.getLink());
            } else if (this.lineLen == 0 && tw.text.trim().isEmpty()) {
                return;
            }
        }
        this.text.get(this.text.size() - 1).add(word);
        if (this.font != null) {
            this.lineLen += word.getWidth(this.font);
        }
    }

    void nl() {
        ArrayList<TextWord> newLine = new ArrayList<TextWord>();
        newLine.add(new TextWord("", null));
        this.text.add(newLine);
        this.lineLen = 0;
    }

    Word click(int relativeX, int relativeY) {
        int y = 0;
        for (ArrayList<Word> line : this.text) {
            int paddingBottom;
            if (y > relativeY) break;
            int[] padding = this.getVerticalPadding(line);
            int paddingTop = padding[0];
            int yChange = paddingTop + (paddingBottom = padding[1]);
            if (y + yChange < relativeY) {
                y += yChange;
                continue;
            }
            y += paddingTop;
            int x = 0;
            for (Word word : line) {
                int width = word.getWidth(this.font);
                if (x <= relativeX && relativeX <= x + width) {
                    return word;
                }
                if ((x += width) <= relativeX) continue;
                break;
            }
            y += paddingBottom;
        }
        return null;
    }

    int[] getVerticalPadding(ArrayList<Word> line) {
        int padUp = 0;
        int padDown = 0;
        for (Word word : line) {
            padUp = Math.max(word.getPaddingAbove(), padUp);
            padDown = Math.max(word.getPaddingBelow(), padDown);
        }
        return new int[]{padUp, padDown};
    }

    @Override
    void draw(DocViewer doc, int ox, int oy, String hoveredLink) {
        int y = 0;
        for (ArrayList<Word> line : this.text) {
            int x = 0;
            int[] padding = this.getVerticalPadding(line);
            int paddingTop = padding[0];
            int paddingBottom = padding[1];
            y += paddingTop;
            for (Word word : line) {
                x += word.draw(doc, ox + x, oy + y, hoveredLink != null && hoveredLink.equals(word.getLink()));
            }
            y += paddingBottom;
        }
    }
}

