/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import factorization.api.Coord;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.DseRayTarget;
import factorization.fzds.Hammer;
import factorization.fzds.HammerClientProxy;
import factorization.fzds.HammerNet;
import factorization.fzds.interfaces.DeltaCapability;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ClickHandler {
    MovingObjectPosition current_attacking_target = null;
    ItemStack original_tool;
    MovingObjectPosition original_block;
    int left_click_delay = 5;
    static float progress = 0.0f;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void leftClick(AttackEntityEvent event) {
        this.handle((PlayerEvent)event, event.target, false);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void rightClick(EntityInteractEvent event) {
        this.handle((PlayerEvent)event, event.target, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handle(PlayerEvent event, Entity target, boolean rightClick) {
        if (!target.field_70170_p.field_72995_K) {
            return;
        }
        this.current_attacking_target = null;
        if (target.getClass() != DseRayTarget.class) {
            return;
        }
        MovingObjectPosition hit = Hammer.proxy.getShadowHit();
        if (hit == null) {
            return;
        }
        DseRayTarget ray = (DseRayTarget)target;
        DimensionSliceEntity parent = ray.parent;
        if (!parent.can(DeltaCapability.INTERACT)) {
            return;
        }
        event.setCanceled(true);
        FMLProxyPacket toSend = null;
        switch (hit.field_72313_a) {
            case ENTITY: {
                toSend = HammerNet.makePacket(rightClick ? (byte)3 : 4, ray.parent.func_145782_y());
                this.current_attacking_target = hit;
                break;
            }
            case BLOCK: {
                if (rightClick) {
                    if (!parent.can(DeltaCapability.BLOCK_PLACE)) {
                        return;
                    }
                    toSend = HammerNet.makePacket((byte)5, parent.func_145782_y(), hit, Float.valueOf((float)(hit.field_72307_f.field_72450_a - (double)hit.field_72311_b)), Float.valueOf((float)(hit.field_72307_f.field_72448_b - (double)hit.field_72312_c)), Float.valueOf((float)(hit.field_72307_f.field_72449_c - (double)hit.field_72309_d)));
                    Coord at = new Coord(DeltaChunk.getClientShadowWorld(), hit);
                    Block block = at.getBlock();
                    EntityClientPlayerMP real_player = Minecraft.func_71410_x().field_71439_g;
                    Hammer.proxy.setShadowWorld();
                    try {
                        EntityClientPlayerMP shadow_player = Minecraft.func_71410_x().field_71439_g;
                        if (!block.func_149727_a(at.w, at.x, at.y, at.z, (EntityPlayer)shadow_player, hit.field_72310_e, (float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c)) break;
                        real_player.func_71038_i();
                        break;
                    }
                    finally {
                        Hammer.proxy.restoreRealWorld();
                    }
                }
                if (!parent.can(DeltaCapability.BLOCK_MINE)) {
                    return;
                }
                toSend = HammerNet.makePacket((byte)6, parent.func_145782_y(), hit, Float.valueOf((float)(hit.field_72307_f.field_72450_a - (double)hit.field_72311_b)), Float.valueOf((float)(hit.field_72307_f.field_72448_b - (double)hit.field_72312_c)), Float.valueOf((float)(hit.field_72307_f.field_72449_c - (double)hit.field_72309_d)));
                this.current_attacking_target = hit;
                break;
            }
            default: {
                return;
            }
        }
        if (toSend == null) {
            return;
        }
        HammerNet.channel.sendToServer(toSend);
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.current_attacking_target == null) {
            this.resetProgress();
            return;
        }
        if (this.current_attacking_target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            this.resetProgress();
            return;
        }
        MovingObjectPosition hit = Hammer.proxy.getShadowHit();
        if (this.current_attacking_target.field_72311_b != hit.field_72311_b || this.current_attacking_target.field_72312_c != hit.field_72312_c || this.current_attacking_target.field_72309_d != hit.field_72309_d || this.current_attacking_target.subHit != hit.subHit) {
            this.resetClick();
            this.resetProgress();
            return;
        }
        this.tickClickBlock(hit);
    }

    void sendDigPacket(byte packetType, MovingObjectPosition hit) {
        FMLProxyPacket toSend = HammerNet.makePacket(packetType, Hammer.proxy.getHitIDC().func_145782_y(), hit);
        HammerNet.channel.sendToServer(toSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tickClickBlock(MovingObjectPosition hit) {
        byte packetType;
        if (this.left_click_delay > 0) {
            --this.left_click_delay;
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        World shadowWorld = DeltaChunk.getClientShadowWorld();
        Minecraft mc = Minecraft.func_71410_x();
        Coord at = new Coord(shadowWorld, hit);
        Block hitBlock = at.getBlock();
        PlayerControllerMP controller = mc.field_71442_b;
        if (mc.field_71462_r != null || !mc.field_71474_y.field_74312_F.func_151470_d() || !mc.field_71415_G) {
            this.resetProgress();
            return;
        }
        if (controller.field_78779_k.func_82752_c() && !player.func_82246_f(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d)) {
            return;
        }
        if (controller.field_78779_k.func_77145_d()) {
            this.sendDigPacket((byte)9, hit);
            Hammer.proxy.setShadowWorld();
            try {
                if (shadowWorld.func_72886_a((EntityPlayer)player, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, hit.field_72310_e)) {
                    return;
                }
                controller.func_78751_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, hit.field_72310_e);
            }
            finally {
                Hammer.proxy.restoreRealWorld();
            }
            return;
        }
        if (hitBlock == null || hitBlock.func_149688_o() == Material.field_151579_a) {
            this.resetProgress();
            return;
        }
        if (progress == 0.0f) {
            hitBlock.func_149699_a(shadowWorld, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, (EntityPlayer)player);
            this.original_block = hit;
            this.original_tool = player.func_70694_bm();
        } else {
            ItemStack held = player.func_70694_bm();
            if (this.original_tool != held) {
                if (this.original_tool == null || held == null) {
                    this.resetProgress();
                    return;
                }
                if (this.original_tool.func_77973_b() != held.func_77973_b()) {
                    this.resetProgress();
                    return;
                }
            }
            if (hit.field_72311_b != this.original_block.field_72311_b || hit.field_72312_c != this.original_block.field_72312_c || hit.field_72309_d != this.original_block.field_72309_d) {
                this.resetProgress();
                return;
            }
        }
        player.func_71038_i();
        byte by = packetType = (progress += hitBlock.func_149737_a((EntityPlayer)player, shadowWorld, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d)) == 0.0f ? (byte)7 : 8;
        if (progress >= 1.0f) {
            packetType = 9;
        }
        this.sendDigPacket(packetType, hit);
        if (progress >= 1.0f) {
            this.resetProgress();
            this.resetClick();
            Hammer.proxy.setShadowWorld();
            try {
                controller.func_78751_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, hit.field_72310_e);
            }
            finally {
                Hammer.proxy.restoreRealWorld();
            }
        } else {
            HammerClientProxy.shadowRenderGlobal.func_147587_b(player.func_145782_y(), hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, (int)(progress * 10.0f) - 1);
        }
    }

    void resetClick() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71474_y.field_74312_F.field_151474_i = 1;
        if (mc.field_71442_b.func_78758_h()) {
            this.left_click_delay = 5;
        }
    }

    void resetProgress() {
        if (this.current_attacking_target != null) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            MovingObjectPosition hit = this.current_attacking_target;
            HammerClientProxy.shadowRenderGlobal.func_147587_b(player.func_145782_y(), hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, -1);
        }
        progress = 0.0f;
        this.current_attacking_target = null;
    }
}

