/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import factorization.aabbdebug.AabbDebugger;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoordFunction;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.FzConfig;
import factorization.coremodhooks.IExtraChunkData;
import factorization.coremodhooks.IKinematicTracker;
import factorization.fzds.DSTeleporter;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DseRayTarget;
import factorization.fzds.Hammer;
import factorization.fzds.HammerNet;
import factorization.fzds.MetaAxisAlignedBB;
import factorization.fzds.PacketProxyingPlayer;
import factorization.fzds.UniversalCollider;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.IFzdsCustomTeleport;
import factorization.fzds.interfaces.IFzdsEntryControl;
import factorization.fzds.interfaces.Interpolation;
import factorization.shared.Core;
import factorization.shared.EntityReference;
import factorization.shared.TortoiseAndHare;
import factorization.util.SpaceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.ArrayUtils;

public class DimensionSliceEntity
extends IDeltaChunk
implements IFzdsEntryControl {
    private Coord cornerMin = Coord.ZERO.copy();
    private Coord cornerMax = Coord.ZERO.copy();
    private Vec3 centerOffset = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private final EntityReference<DimensionSliceEntity> parent;
    private Vec3 offsetFromParent = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private transient ArrayList<IDeltaChunk> children = new ArrayList(0);
    private long capabilities = DeltaCapability.of(DeltaCapability.MOVE, DeltaCapability.COLLIDE, DeltaCapability.DRAG, DeltaCapability.REMOVE_ITEM_ENTITIES);
    AxisAlignedBB realArea = this.makeAABB();
    MetaAxisAlignedBB metaAABB = null;
    private AxisAlignedBB shadowArea = null;
    private AxisAlignedBB realDragArea = null;
    private boolean needAreaUpdate = true;
    private double last_motion_hash = Double.NaN;
    private Quaternion rotation = new Quaternion();
    private Quaternion rotationalVelocity = new Quaternion();
    private Quaternion last_shared_rotation = new Quaternion();
    private Quaternion last_shared_rotational_velocity = new Quaternion();
    Quaternion prevTickRotation = new Quaternion();
    private double last_shared_posX = -99.0;
    private double last_shared_posY = -99.0;
    private double last_shared_posZ = -99.0;
    private double last_shared_motionX = 0.0;
    private double last_shared_motionY = 0.0;
    private double last_shared_motionZ = 0.0;
    private Quaternion rotationStart = new Quaternion();
    private Quaternion rotationEnd = new Quaternion();
    private long orderTimeStart = -1L;
    private long orderTimeEnd = -1L;
    private Interpolation orderInterp = Interpolation.CONSTANT;
    float scale = 1.0f;
    float opacity = 1.0f;
    Object renderInfo = null;
    Entity proxy = null;
    HashSet<IExtraChunkData> registered_chunks = new HashSet();
    UniversalCollider universalCollider;
    private Vec3 workVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    double last_uni_x = Double.NEGATIVE_INFINITY;
    double last_uni_z = Double.NEGATIVE_INFINITY;
    Quaternion last_uni_rot = null;
    boolean need_recheck = false;
    private static final IEntitySelector excludeDseRelatedEntities = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            Class<?> entClass = entity.getClass();
            if (entClass == DimensionSliceEntity.class) {
                return false;
            }
            return entClass != UniversalCollider.class;
        }
    };
    private static DamageSource violenceDamage = new DamageSource("dseHit");
    Vec3 point_a = SpaceUtil.newVec();
    Vec3 point_b = SpaceUtil.newVec();
    static final int force_sync_time = 80;
    private DseRayTarget rayTarget = null;
    private Entity[] raypart = null;
    private boolean rayOutOfDate = true;
    static final ItemStack[] blast_protection = new ItemStack[1];

    public DimensionSliceEntity(World world) {
        super(world);
        if (world == DeltaChunk.getWorld(world)) {
            Core.logWarning("Aborting attempt to spawn DSE in Hammerspace", new Object[0]);
            this.func_70106_y();
        }
        this.universalCollider = new UniversalCollider(this, world);
        this.parent = new EntityReference(world);
    }

    public DimensionSliceEntity(World world, Coord lowerCorner, Coord upperCorner) {
        this(world);
        this.setCorners(lowerCorner, upperCorner);
    }

    private void setCorners(Coord lowerCorner, Coord upperCorner) {
        if (!(lowerCorner.w == DeltaChunk.getWorld(this.field_70170_p) || this.can(DeltaCapability.ORACLE) && lowerCorner.w == this.field_70170_p)) {
            throw new IllegalArgumentException("My corners are not shadow!");
        }
        Coord.sort(lowerCorner, upperCorner);
        this.cornerMin = lowerCorner;
        this.cornerMax = upperCorner;
        DeltaCoord dc = upperCorner.difference(lowerCorner);
        this.centerOffset = Vec3.func_72443_a((double)(dc.x / 2), (double)(dc.y / 2), (double)(dc.z / 2));
    }

    @Override
    public final Vec3 real2shadow(Vec3 realVector) {
        Vec3 buffer = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        this.real2shadow(realVector, buffer);
        return buffer;
    }

    public final void real2shadow(Vec3 realVector, Vec3 buffer) {
        buffer.field_72450_a = realVector.field_72450_a - this.field_70165_t;
        buffer.field_72448_b = realVector.field_72448_b - this.field_70163_u;
        buffer.field_72449_c = realVector.field_72449_c - this.field_70161_v;
        this.rotation.applyReverseRotation(buffer);
        buffer.field_72450_a += (double)this.cornerMin.x + this.centerOffset.field_72450_a;
        buffer.field_72448_b += (double)this.cornerMin.y + this.centerOffset.field_72448_b;
        buffer.field_72449_c += (double)this.cornerMin.z + this.centerOffset.field_72449_c;
    }

    @Override
    public final Vec3 shadow2real(Vec3 shadowVector) {
        Vec3 buffer = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        buffer.field_72450_a = shadowVector.field_72450_a - (double)this.cornerMin.x - this.centerOffset.field_72450_a;
        buffer.field_72448_b = shadowVector.field_72448_b - (double)this.cornerMin.y - this.centerOffset.field_72448_b;
        buffer.field_72449_c = shadowVector.field_72449_c - (double)this.cornerMin.z - this.centerOffset.field_72449_c;
        this.rotation.applyRotation(buffer);
        buffer.field_72450_a += this.field_70165_t;
        buffer.field_72448_b += this.field_70163_u;
        buffer.field_72449_c += this.field_70161_v;
        return buffer;
    }

    @Override
    public void shadow2real(Coord c) {
        double d = 0.5;
        this.workVec.field_72450_a = (double)c.x + d;
        this.workVec.field_72448_b = (double)c.y + d;
        this.workVec.field_72449_c = (double)c.z + d;
        this.workVec = this.shadow2real(this.workVec);
        c.set(this.workVec);
        c.w = this.field_70170_p;
    }

    @Override
    public void real2shadow(Coord c) {
        c.set(this.real2shadow(c.createVector()));
        c.w = DeltaChunk.getWorld(this.field_70170_p);
    }

    @Override
    public Coord getCorner() {
        return this.cornerMin;
    }

    @Override
    public Coord getFarCorner() {
        return this.cornerMax;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public void func_70100_b_(EntityPlayer player) {
    }

    protected void func_70088_a() {
    }

    @Override
    protected void putData(DataHelper data) throws IOException {
        this.capabilities = data.as(Share.VISIBLE, "cap").putLong(this.capabilities);
        this.rotation = data.as(Share.VISIBLE, "r").put(this.rotation);
        this.rotationalVelocity = data.as(Share.VISIBLE, "w").put(this.rotationalVelocity);
        this.centerOffset = data.as(Share.VISIBLE, "co").putVec3(this.centerOffset);
        this.cornerMin = data.as(Share.VISIBLE, "min").put(this.cornerMin);
        this.cornerMax = data.as(Share.VISIBLE, "max").put(this.cornerMax);
        this.partName = data.as(Share.VISIBLE, "partName").putString(this.partName);
        if (this.can(DeltaCapability.SCALE)) {
            this.scale = data.as(Share.VISIBLE, "incrScale").putFloat(this.scale);
        }
        if (this.can(DeltaCapability.TRANSPARENT)) {
            this.opacity = data.as(Share.VISIBLE, "opacity").putFloat(this.opacity);
        }
        if (data.isReader() && this.field_70170_p.field_72995_K) {
            DeltaChunk.getSlices(this.field_70170_p).add(this);
            this.cornerMax.w = this.cornerMin.w = DeltaChunk.getClientShadowWorld();
        }
        data.as(Share.VISIBLE, "parent").put(this.parent);
        this.offsetFromParent = data.as(Share.VISIBLE, "parentOffset").putVec3(this.offsetFromParent);
        this.field_96093_i = data.as(Share.VISIBLE, "entityUUID").putUUID(this.field_96093_i);
        this.rotationStart = data.as(Share.VISIBLE, "rotStart").put(this.rotationStart);
        this.rotationEnd = data.as(Share.VISIBLE, "rotEnd").put(this.rotationEnd);
        this.orderTimeStart = data.as(Share.VISIBLE, "rotOrdStart").putLong(this.orderTimeStart);
        this.orderTimeEnd = data.as(Share.VISIBLE, "rotOrdEnd").putLong(this.orderTimeEnd);
        this.orderInterp = data.as(Share.VISIBLE, "orderInterp").putEnum(this.orderInterp);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    private AxisAlignedBB cloneAABB(AxisAlignedBB orig) {
        AxisAlignedBB ret = this.makeAABB();
        ret.func_72328_c(orig);
        return ret;
    }

    private AxisAlignedBB makeAABB() {
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    private AxisAlignedBB offsetAABB(AxisAlignedBB orig, double dx, double dy, double dz) {
        return AxisAlignedBB.func_72330_a((double)(orig.field_72340_a + dx), (double)(orig.field_72338_b + dy), (double)(orig.field_72339_c + dz), (double)(orig.field_72336_d + dx), (double)(orig.field_72337_e + dy), (double)(orig.field_72334_f + dz));
    }

    @Override
    public IDeltaChunk getParent() {
        return this.parent.getEntity();
    }

    @Override
    public Vec3 getParentJoint() {
        return this.offsetFromParent;
    }

    @Override
    public void setParent(IDeltaChunk _parent, Vec3 jointPositionAtParent) {
        DimensionSliceEntity oldParent;
        if (null != TortoiseAndHare.race(this, new TortoiseAndHare.Advancer<IDeltaChunk>(){

            @Override
            public IDeltaChunk getNext(IDeltaChunk node) {
                return node.getParent();
            }
        })) {
            throw new IllegalArgumentException("Parenting loop!");
        }
        DimensionSliceEntity newParent = (DimensionSliceEntity)_parent;
        if (this.parent.trackingEntity() && (oldParent = this.parent.getEntity()) != null) {
            oldParent.children.remove(this);
        }
        this.parent.trackEntity(newParent);
        this.offsetFromParent = jointPositionAtParent;
        newParent.children.remove(this);
        newParent.children.add(this);
    }

    @Override
    public ArrayList<IDeltaChunk> getChildren() {
        return this.children;
    }

    private void updateRealArea() {
        Vec3[] corners = SpaceUtil.getCorners(this.shadowArea);
        Vec3 first = this.shadow2real(corners[0]);
        SpaceUtil.setAABB(this.realArea, first, first);
        for (int i = 1; i < corners.length; ++i) {
            Vec3 v = corners[i];
            v = this.shadow2real(v);
            if (v.field_72450_a < this.realArea.field_72340_a) {
                this.realArea.field_72340_a = v.field_72450_a;
            }
            if (v.field_72448_b < this.realArea.field_72338_b) {
                this.realArea.field_72338_b = v.field_72448_b;
            }
            if (v.field_72449_c < this.realArea.field_72339_c) {
                this.realArea.field_72339_c = v.field_72449_c;
            }
            if (v.field_72450_a > this.realArea.field_72336_d) {
                this.realArea.field_72336_d = v.field_72450_a;
            }
            if (v.field_72448_b > this.realArea.field_72337_e) {
                this.realArea.field_72337_e = v.field_72448_b;
            }
            if (!(v.field_72449_c > this.realArea.field_72334_f)) continue;
            this.realArea.field_72334_f = v.field_72449_c;
        }
        this.field_70121_D.func_72328_c(this.realArea);
        if (this.metaAABB == null) {
            this.metaAABB = new MetaAxisAlignedBB(this, this.cornerMin.w);
        }
        this.metaAABB.setUnderlying(this.realArea);
        this.needAreaUpdate = false;
    }

    boolean significantMovement() {
        if (this.need_recheck) {
            this.need_recheck = false;
            return true;
        }
        if (this.field_70173_aa <= 2) {
            return true;
        }
        double dx = Math.abs(this.last_uni_x - this.field_70165_t);
        double dz = Math.abs(this.last_uni_z - this.field_70161_v);
        if (dx > 8.0 || dz > 8.0) {
            this.last_uni_x = this.field_70165_t;
            this.last_uni_z = this.field_70161_v;
            return true;
        }
        if (!this.can(DeltaCapability.ROTATE)) {
            return false;
        }
        if (this.last_uni_rot == null) {
            this.last_uni_rot = new Quaternion(this.rotation);
            return true;
        }
        double angle_change = this.rotation.getAngleBetween(this.last_uni_rot);
        if (angle_change < Math.PI * 2 / (double)this.cornerMin.distanceSq(this.cornerMax)) {
            this.last_uni_rot = new Quaternion(this.last_uni_rot);
            return true;
        }
        return false;
    }

    private void updateUniversalCollisions() {
        if (this.realArea == null) {
            return;
        }
        double last_x = this.last_uni_x;
        double last_z = this.last_uni_z;
        if (!this.significantMovement()) {
            return;
        }
        double d = 8.0;
        if (this.can(DeltaCapability.ROTATE)) {
            Coord min = this.getCorner();
            Coord max = this.getFarCorner();
            Vec3 center = this.real2shadow(SpaceUtil.fromEntPos(this));
            double sx = Math.max(center.field_72450_a - (double)min.x, (double)max.x - center.field_72450_a);
            double sy = Math.max(center.field_72448_b - (double)min.y, (double)max.y - center.field_72448_b);
            double sz = Math.max(center.field_72449_c - (double)min.z, (double)max.z - center.field_72449_c);
            double r = Math.sqrt(sx * sx + sy * sy + sz * sz);
            d += r;
        }
        double minX = this.realArea.field_72340_a - d;
        double maxX = this.realArea.field_72336_d + d;
        double minZ = this.realArea.field_72339_c - d;
        double maxZ = this.realArea.field_72334_f + d;
        HashSet<IExtraChunkData> toDeregister = new HashSet<IExtraChunkData>(this.registered_chunks.size());
        toDeregister.addAll(this.registered_chunks);
        for (double x = minX; x <= maxX; x += 16.0) {
            for (double z = minZ; z <= maxZ; z += 16.0) {
                this.check_chunk(x, z, toDeregister);
            }
        }
        this.deregisterUCs(toDeregister);
    }

    private void deregisterUniversalCollisionsForDeath() {
        this.deregisterUCs(this.registered_chunks);
        this.registered_chunks.clear();
    }

    private void deregisterUCs(HashSet<IExtraChunkData> old) {
        for (IExtraChunkData chunk : old) {
            Object colliders = chunk.getConstantColliders();
            colliders = colliders == null || ((Entity[])colliders).length == 1 ? null : (Entity[])ArrayUtils.removeElement((Object[])colliders, (Object)this.universalCollider);
            chunk.setConstantColliders((Entity[])colliders);
        }
    }

    private void check_chunk(double x, double z, HashSet<IExtraChunkData> toDeregister) {
        if (this.field_70128_L) {
            return;
        }
        int ix = (int)x;
        int iz = (int)z;
        if (!this.field_70170_p.func_72899_e(ix, 64, iz)) {
            return;
        }
        Chunk mc_chunk = this.field_70170_p.func_72938_d(ix, iz);
        if (mc_chunk == null) {
            return;
        }
        if (mc_chunk.func_76621_g() && this.field_70170_p.field_72995_K) {
            this.need_recheck = true;
        }
        IExtraChunkData chunk = (IExtraChunkData)mc_chunk;
        Object[] colliders = chunk.getConstantColliders();
        boolean is_registered = ArrayUtils.contains((Object[])colliders, (Object)this.universalCollider);
        toDeregister.remove(chunk);
        if (!is_registered) {
            colliders = (Entity[])ArrayUtils.add((Object[])colliders, (Object)this.universalCollider);
            this.registered_chunks.add(chunk);
            chunk.setConstantColliders((Entity[])colliders);
        }
    }

    private void updateShadowArea() {
        Coord c = this.getCorner();
        Coord d = this.getFarCorner();
        AxisAlignedBB start = null;
        for (int x = c.x; x <= d.x; ++x) {
            for (int y = c.y; y <= d.y; ++y) {
                for (int z = c.z; z <= d.z; ++z) {
                    AxisAlignedBB b;
                    Block block = c.w.func_147439_a(x, y, z);
                    if (block == null || (b = block.func_149668_a(c.w, x, y, z)) == null) continue;
                    if (start == null) {
                        start = b;
                        continue;
                    }
                    start.field_72340_a = Math.min(start.field_72340_a, b.field_72340_a);
                    start.field_72338_b = Math.min(start.field_72338_b, b.field_72338_b);
                    start.field_72339_c = Math.min(start.field_72339_c, b.field_72339_c);
                    start.field_72336_d = Math.max(start.field_72336_d, b.field_72336_d);
                    start.field_72337_e = Math.max(start.field_72337_e, b.field_72337_e);
                    start.field_72334_f = Math.max(start.field_72334_f, b.field_72334_f);
                }
            }
        }
        if (start == null) {
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            if (this.can(DeltaCapability.DIE_WHEN_EMPTY)) {
                Core.logInfo("IDC requests deletion when empty, and is empty: %s", this);
                this.func_70106_y();
                return;
            }
            this.shadowArea = this.makeAABB();
            return;
        }
        this.shadowArea = this.cloneAABB(start);
        this.updateRealArea();
        this.updateUniversalCollisions();
    }

    public void blocksChanged(int x, int y, int z) {
        if (this.shadowArea == null) {
            this.needAreaUpdate = true;
            return;
        }
        this.needAreaUpdate |= (double)x <= this.shadowArea.field_72340_a || (double)y <= this.shadowArea.field_72338_b || (double)z <= this.shadowArea.field_72339_c || (double)x >= this.shadowArea.field_72336_d || (double)y >= this.shadowArea.field_72337_e || (double)z >= this.shadowArea.field_72334_f;
    }

    public void func_70107_b(double par1, double par3, double par5) {
        super.func_70107_b(par1, par3, par5);
        this.needAreaUpdate = true;
    }

    boolean updateHashMotion() {
        double hash = this.field_70159_w * 10.0 + this.field_70181_x * 1010.0 + this.field_70179_y * 101010.0;
        if (hash == this.last_motion_hash) {
            return false;
        }
        this.last_motion_hash = hash;
        return true;
    }

    public Vec3 getInstantaneousRotationalVelocityAtPointInCornerSpace(Vec3 corner) {
        Vec3 origPoint = SpaceUtil.subtract(this.centerOffset, corner);
        this.rotation.applyRotation(origPoint);
        Vec3 rotatedPoint = SpaceUtil.copy(origPoint);
        this.rotationalVelocity.applyRotation(rotatedPoint);
        return SpaceUtil.subtract(origPoint, rotatedPoint);
    }

    private boolean hasLinearMotion() {
        return this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0;
    }

    private boolean hasRotationalMotion() {
        return !this.rotationalVelocity.isZero() || this.hasOrderedRotation();
    }

    void updateMotion(Vec3 parentTickDisp, Quaternion parentTickRotation) {
        if (this.metaAABB == null) {
            return;
        }
        if (this.hasOrderedRotation() && this.orderTimeEnd <= this.field_70170_p.func_82737_E()) {
            if (this.can(DeltaCapability.SNAP_TO_EXACT_ORDERED_ROTATION)) {
                Quaternion trueRot = new Quaternion(this.rotationEnd);
                for (IDeltaChunk here = this.getParent(); here != null; here = here.getParent()) {
                    here.getRotation().incrToOtherMultiply(trueRot);
                }
                this.setRotation(trueRot);
            }
            this.cancelOrderedRotation();
        }
        boolean parentRotation = !parentTickRotation.isZero();
        boolean linearMotion = parentRotation || !SpaceUtil.isZero(parentTickDisp) || this.hasLinearMotion();
        boolean rotationalMotion = parentRotation || this.hasRotationalMotion();
        Vec3 mot = null;
        Quaternion rot = null;
        boolean moved = false;
        if (linearMotion) {
            mot = parentTickDisp.func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.realDragArea == null || this.updateHashMotion() || rotationalMotion) {
                this.realDragArea = this.realArea.func_72321_a(mot.field_72450_a, mot.field_72448_b, mot.field_72449_c);
            }
            if (mot.field_72450_a != 0.0 || mot.field_72448_b != 0.0 || mot.field_72449_c != 0.0) {
                this.field_70165_t += mot.field_72450_a;
                this.field_70163_u += mot.field_72448_b;
                this.field_70161_v += mot.field_72449_c;
                moved = true;
            }
        } else {
            mot = parentTickDisp;
        }
        if (rotationalMotion) {
            if (this.hasOrderedRotation()) {
                long now = this.field_70170_p.func_82737_E();
                Quaternion r0 = this.getOrderedRotation(now);
                Quaternion r1 = this.getOrderedRotation(now + 1L);
                r0.incrConjugate();
                r1.incrMultiply(r0);
                rot = r1;
            } else {
                rot = new Quaternion(this.rotationalVelocity);
            }
            if (parentRotation) {
                parentTickRotation.incrToOtherMultiply(rot);
            }
            if (!rot.isZero()) {
                rot.incrToOtherMultiply(this.rotation);
                this.rotation.incrNormalize();
                moved = true;
            }
        } else {
            rot = parentTickRotation;
        }
        this.last_shared_rotation.incrMultiply(this.last_shared_rotational_velocity);
        if (moved && !this.field_70145_X && this.can(DeltaCapability.COLLIDE_WITH_WORLD)) {
            List collisions = this.field_70170_p.func_72945_a((Entity)this, this.realArea);
            AxisAlignedBB collision = null;
            for (int i = 0; i < collisions.size(); ++i) {
                AxisAlignedBB solid = (AxisAlignedBB)collisions.get(i);
                if (solid == this.metaAABB || !this.metaAABB.func_72326_a(solid)) continue;
                collision = solid;
                break;
            }
            if (collision != null) {
                if (mot != null) {
                    this.field_70165_t -= mot.field_72450_a;
                    this.field_70163_u -= mot.field_72448_b;
                    this.field_70161_v -= mot.field_72449_c;
                }
                this.rotationalVelocity.incrConjugate();
                this.rotation.incrMultiply(this.rotationalVelocity);
                this.rotationalVelocity.incrConjugate();
                this.func_70016_h(0.0, 0.0, 0.0);
                this.rotationalVelocity.update(0.0, 0.0, 0.0, 0.0);
                moved = false;
            }
        }
        if (moved && this.can(DeltaCapability.DRAG)) {
            List ents = this.field_70170_p.func_94576_a((Entity)this, (AxisAlignedBB)this.metaAABB, excludeDseRelatedEntities);
            float dyaw = 0.0f;
            dyaw = (float)Math.toDegrees(-rot.toRotationVector().field_72448_b);
            if (Float.isNaN(dyaw)) {
                dyaw = 0.0f;
            }
            long now = this.field_70170_p.func_82737_E() + 100L;
            for (int i = 0; i < ents.size(); ++i) {
                Entity e = (Entity)ents.get(i);
                AxisAlignedBB ebb = e.field_70121_D;
                double expansion = 0.0;
                if (mot != null) {
                    double friction_expansion = 0.05 * mot.func_72433_c();
                    if (mot.field_72448_b > 0.0) {
                        ebb = ebb.func_72314_b(-mot.field_72450_a, -mot.field_72448_b, -mot.field_72449_c);
                    }
                    if (mot.field_72450_a != 0.0 || mot.field_72449_c != 0.0) {
                        expansion = friction_expansion;
                    }
                }
                if (expansion < 0.1) {
                    expansion = 0.1;
                }
                if (expansion != 0.0) {
                    ebb = ebb.func_72314_b(expansion, expansion, expansion);
                }
                if (!this.metaAABB.func_72326_a(ebb)) continue;
                if (this.can(DeltaCapability.ENTITY_PHYSICS)) {
                    IKinematicTracker kine = (IKinematicTracker)e;
                    kine.reset(now);
                    double instant_scale = 1.0;
                    double motion_scale = 1.0;
                    double vel_scale = 1.0;
                    Vec3 entityAt = SpaceUtil.fromEntPos(e);
                    Vec3 velocity = this.calcInstantVelocityAtRealPoint(entityAt, mot, rot);
                    if (this.can(DeltaCapability.VIOLENT_COLLISIONS) && !this.field_70170_p.field_72995_K) {
                        double smackSpeed = velocity.func_72433_c();
                        vel_scale = 1.0;
                        if (e instanceof EntityLivingBase && smackSpeed > 0.05) {
                            EntityLivingBase el = (EntityLivingBase)e;
                            el.func_70097_a(violenceDamage, (float)(20.0 * smackSpeed));
                            Vec3 emo = velocity.func_72432_b();
                            e.field_70159_w += emo.field_72450_a * vel_scale;
                            e.field_70181_x += emo.field_72448_b * vel_scale;
                            e.field_70179_y += emo.field_72449_c * vel_scale;
                        }
                    }
                    velocity.field_72450_a *= instant_scale;
                    velocity.field_72448_b *= instant_scale;
                    velocity.field_72449_c *= instant_scale;
                    velocity.field_72450_a = this.clipVelocity(velocity.field_72450_a * motion_scale, e.field_70159_w);
                    velocity.field_72448_b = this.clipVelocity(velocity.field_72448_b * motion_scale, e.field_70181_x);
                    velocity.field_72449_c = this.clipVelocity(velocity.field_72449_c * motion_scale, e.field_70179_y);
                    e.func_70091_d(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
                    double origYaw = e.field_70177_z;
                    e.field_70177_z = (float)this.addLimitedDelta(kine.getKinematics_yaw(), e.field_70177_z, dyaw);
                    double yd = (double)e.field_70177_z - origYaw;
                    e.field_70126_B = (float)((double)e.field_70126_B + yd);
                } else if (mot != null) {
                    e.func_70091_d(mot.field_72450_a, mot.field_72448_b, mot.field_72449_c);
                    if (mot.field_72448_b > 0.0 && e.field_70181_x < mot.field_72448_b) {
                        e.field_70181_x = mot.field_72448_b;
                        e.field_70143_R += (float)Math.abs(mot.field_72448_b - e.field_70181_x);
                    }
                }
                e.field_70122_E = true;
            }
            this.updateRealArea();
        }
        if (linearMotion || rotationalMotion) {
            this.updateUniversalCollisions();
        }
        Vec3 childAt = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Iterator<IDeltaChunk> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            DimensionSliceEntity child = (DimensionSliceEntity)iterator.next();
            if (child.field_70128_L) {
                iterator.remove();
                continue;
            }
            childAt.field_72450_a = child.field_70165_t;
            childAt.field_72448_b = child.field_70163_u;
            childAt.field_72449_c = child.field_70161_v;
            Vec3 inst = this.getInstRotVel(childAt, rot);
            SpaceUtil.incrAdd(inst, mot);
            child.updateMotion(inst, rot);
        }
    }

    public Vec3 getInstRotVel(Vec3 real, Quaternion rot) {
        Vec3 dse_space;
        Vec3 point_a = dse_space = real.func_72441_c(-this.field_70165_t, -this.field_70163_u, -this.field_70161_v);
        Vec3 point_b = dse_space.func_72441_c(0.0, 0.0, 0.0);
        rot.applyRotation(point_b);
        return SpaceUtil.subtract(point_b, point_a);
    }

    Vec3 calcInstantVelocityAtRealPoint(Vec3 realPos, Vec3 linear, Quaternion rot) {
        this.point_a.field_72450_a = realPos.field_72450_a - this.field_70165_t;
        this.point_a.field_72448_b = realPos.field_72448_b - this.field_70163_u;
        this.point_a.field_72449_c = realPos.field_72449_c - this.field_70161_v;
        this.point_b = SpaceUtil.set(this.point_b, this.point_a);
        rot.applyRotation(this.point_b);
        Vec3 rotational = SpaceUtil.incrSubtract(this.point_b, this.point_a);
        return SpaceUtil.incrAdd(rotational, linear);
    }

    double addLimitedDelta(double prevVal, double currentVal, double delta) {
        if (delta == 0.0) {
            return currentVal;
        }
        double oldDelta = currentVal - prevVal;
        if (oldDelta != 0.0 && Math.signum(oldDelta) != Math.signum(delta)) {
            return currentVal;
        }
        if (delta > 0.0) {
            return prevVal + Math.max(delta, oldDelta);
        }
        return prevVal + Math.min(delta, oldDelta);
    }

    double clipVelocity(double impulse_velocity, double current_velocity) {
        if (impulse_velocity < 0.0) {
            return Math.min(impulse_velocity, current_velocity);
        }
        if (impulse_velocity > 0.0) {
            return Math.max(impulse_velocity, current_velocity);
        }
        return current_velocity;
    }

    void shareRotationInfo() {
        boolean d1;
        boolean d0 = !this.rotation.equals(this.last_shared_rotation);
        boolean bl = d1 = !this.rotationalVelocity.equals(this.last_shared_rotational_velocity);
        if (this.parent.trackingEntity()) {
            d0 = false;
        }
        FMLProxyPacket toSend = null;
        if (d0 && d1 || this.field_70173_aa % 80 == 0) {
            toSend = HammerNet.makePacket((byte)2, this.func_145782_y(), this.rotation, this.rotationalVelocity);
            this.last_shared_rotation.update(this.rotation);
            this.last_shared_rotational_velocity.update(this.rotationalVelocity);
        } else if (d0) {
            toSend = HammerNet.makePacket((byte)0, this.func_145782_y(), this.rotation);
            this.last_shared_rotation.update(this.rotation);
        } else if (d1) {
            toSend = HammerNet.makePacket((byte)1, this.func_145782_y(), this.rotationalVelocity);
            this.last_shared_rotational_velocity.update(this.rotationalVelocity);
        }
        if (toSend != null) {
            this.broadcastPacket(toSend);
        }
    }

    void shareDisplacementInfo() {
        this.last_shared_posX += this.last_shared_motionX;
        this.last_shared_posY += this.last_shared_motionY;
        this.last_shared_posZ += this.last_shared_motionZ;
        boolean share_displacement = this.last_shared_posX != this.field_70165_t || this.last_shared_posY != this.field_70163_u || this.last_shared_posZ != this.field_70161_v;
        boolean share_velocity = this.last_shared_motionX != this.field_70159_w || this.last_shared_motionY != this.field_70181_x || this.last_shared_motionZ != this.field_70179_y;
        if (!(share_displacement |= this.field_70173_aa % 80 == 0) && !share_velocity) {
            return;
        }
        FMLProxyPacket toSend = HammerNet.makePacket((byte)11, this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.broadcastPacket(toSend);
        this.last_shared_posX = this.field_70165_t;
        this.last_shared_posY = this.field_70163_u;
        this.last_shared_posZ = this.field_70161_v;
        this.last_shared_motionX = this.field_70159_w;
        this.last_shared_motionY = this.field_70181_x;
        this.last_shared_motionZ = this.field_70179_y;
    }

    void debugCollisions() {
        if (!FzConfig.debug_fzds_collisions) {
            return;
        }
        if (this.metaAABB == null) {
            return;
        }
        Coord.iterateCube(this.getCorner(), this.getFarCorner(), new ICoordFunction(){

            @Override
            public void handle(Coord at) {
                if (at.isAir()) {
                    return;
                }
                AxisAlignedBB box = at.getCollisionBoundingBoxFromPool();
                if (box == null) {
                    return;
                }
                AabbDebugger.addBox(DimensionSliceEntity.this.metaAABB.convertShadowBoxToRealBox(box));
            }
        });
    }

    public void func_70030_z() {
        IDeltaChunk p;
        if (this.field_70128_L) {
            return;
        }
        Core.profileStart("FzdsDseTick");
        Core.profileStart("init");
        this.prevTickRotation.update(this.rotation);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70170_p.field_72995_K) {
            this.rayOutOfDate = true;
            if (this.field_70173_aa == 1) {
                DeltaChunk.getSlices(this.field_70170_p).add(this);
            }
        } else if (this.proxy == null) {
            World target_world;
            boolean isOracle = this.can(DeltaCapability.ORACLE);
            this.cornerMin.w = this.cornerMax.w = (target_world = isOracle ? this.field_70170_p : DeltaChunk.getServerShadowWorld());
            if (isOracle) {
                this.proxy = this;
            } else {
                DeltaChunk.getSlices(this.field_70170_p).add(this);
                World shadowWorld = DeltaChunk.getServerShadowWorld();
                this.proxy = new PacketProxyingPlayer(this, shadowWorld);
                this.proxy.field_70170_p.func_72838_d(this.proxy);
            }
            Core.profileEnd();
            Core.profileEnd();
            return;
        }
        if (this.field_70173_aa % 60 == 0) {
            this.need_recheck = true;
            this.updateUniversalCollisions();
        }
        Core.profileEnd();
        if (!this.parent.trackingEntity()) {
            Core.profileStart("updateMotion");
            this.updateMotion(Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), new Quaternion());
            Core.profileEnd();
        } else if (!this.parent.entityFound() && (p = (IDeltaChunk)this.parent.getEntity()) != null) {
            this.setParent(p, this.getParentJoint());
        }
        if (!this.field_70170_p.field_72995_K) {
            this.shareDisplacementInfo();
            if (this.can(DeltaCapability.ROTATE)) {
                this.shareRotationInfo();
            }
        }
        if (this.needAreaUpdate) {
            Core.profileStart("updateArea");
            this.updateShadowArea();
            Core.profileEnd();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.shadowArea == null) {
                this.updateShadowArea();
            }
            if (this.shadowArea == null) {
                if (this.cornerMin.blockExists() && this.can(DeltaCapability.DIE_WHEN_EMPTY)) {
                    this.func_70106_y();
                    Core.logFine("%s destroyed due to empty area", this.toString());
                } else {
                    this.needAreaUpdate = true;
                }
            } else {
                if (this.can(DeltaCapability.TAKE_INTERIOR_ENTITIES)) {
                    this.takeInteriorEntities();
                }
                if (this.can(DeltaCapability.REMOVE_EXTERIOR_ENTITIES)) {
                    this.removeExteriorEntities();
                }
                if (this.can(DeltaCapability.REMOVE_ITEM_ENTITIES)) {
                    this.removeItemEntities();
                }
            }
        }
        Core.profileEnd();
    }

    private void takeInteriorEntities() {
        List realEntities = this.field_70170_p.func_72872_a(Entity.class, this.realArea);
        for (int i = 0; i < realEntities.size(); ++i) {
            Entity ent = (Entity)realEntities.get(i);
            if (ent == this) continue;
            this.takeEntity(ent);
        }
    }

    private void removeExteriorEntities() {
        for (int x = this.cornerMin.x; x <= this.cornerMax.x; x += 16) {
            for (int z = this.cornerMin.z; z <= this.cornerMax.z; z += 16) {
                if (!this.field_70170_p.func_72899_e(x, 64, z)) continue;
                Chunk chunk = this.field_70170_p.func_72938_d(x, z);
                for (int j = 0; j < chunk.field_76645_j.length; ++j) {
                    List l = chunk.field_76645_j[j];
                    for (int k = 0; k < l.size(); ++k) {
                        Entity ent = (Entity)l.get(k);
                        if (ent.field_70163_u < 0.0 || ent.field_70163_u > (double)this.field_70170_p.func_72940_L() || ent == this || this.shadowArea.func_72326_a(ent.field_70121_D)) continue;
                        this.ejectEntity(ent);
                    }
                }
            }
        }
    }

    private void removeItemEntities() {
        World w = this.cornerMin.w;
        for (int x = this.cornerMin.x - 16; x <= this.cornerMax.x + 16; x += 16) {
            for (int z = this.cornerMin.z - 16; z <= this.cornerMax.z + 16; z += 16) {
                if (!w.func_72899_e(x, 64, z)) continue;
                Chunk chunk = w.func_72938_d(x, z);
                for (int j = 0; j < chunk.field_76645_j.length; ++j) {
                    List l = chunk.field_76645_j[j];
                    for (int k = 0; k < l.size(); ++k) {
                        Entity ent = (Entity)l.get(k);
                        if (ent.field_70163_u < 0.0 || ent.field_70163_u > (double)w.func_72940_L() || ent == this || !(ent instanceof EntityItem)) continue;
                        this.ejectEntity(ent);
                    }
                }
            }
        }
    }

    boolean forbidEntityTransfer(Entity ent) {
        return ent.field_71088_bW > 0;
    }

    void takeEntity(Entity ent) {
        if (this.forbidEntityTransfer(ent)) {
            return;
        }
        IFzdsEntryControl ifec = null;
        if (ent instanceof IFzdsEntryControl && !(ifec = (IFzdsEntryControl)ent).canEnter(this)) {
            return;
        }
        World shadowWorld = DeltaChunk.getServerShadowWorld();
        Vec3 newLocation = this.real2shadow(Hammer.ent2vec(ent));
        this.transferEntity(ent, shadowWorld, newLocation);
        if (ifec != null) {
            ifec.onEnter(this);
        }
    }

    void ejectEntity(Entity ent) {
        if (this.forbidEntityTransfer(ent)) {
            return;
        }
        IFzdsEntryControl ifec = null;
        if (ent instanceof IFzdsEntryControl && !(ifec = (IFzdsEntryControl)ent).canExit(this)) {
            return;
        }
        Vec3 newLocation = this.shadow2real(Hammer.ent2vec(ent));
        this.transferEntity(ent, this.field_70170_p, newLocation);
        if (ifec != null) {
            ifec.onExit(this);
        }
    }

    void transferEntity(Entity ent, World newWorld, Vec3 newPosition) {
        if (ent instanceof IFzdsCustomTeleport) {
            ((IFzdsCustomTeleport)ent).transferEntity(this.field_70170_p, newPosition);
            return;
        }
        if (ent instanceof EntityPlayerMP) {
            if (!this.can(DeltaCapability.TRANSFER_PLAYERS)) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)ent;
            MinecraftServer ms = MinecraftServer.func_71276_C();
            ServerConfigurationManager manager = ms.func_71203_ab();
            DSTeleporter tp = new DSTeleporter((WorldServer)newWorld);
            tp.preciseDestination = newPosition;
            manager.transferPlayerToDimension(player, newWorld.field_73011_w.field_76574_g, (Teleporter)tp);
        } else {
            ent.field_70170_p.func_72900_e(ent);
            ent.field_70128_L = false;
            Entity phoenix = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)ent), (World)newWorld);
            if (phoenix == null) {
                return;
            }
            phoenix.func_82141_a(ent, true);
            phoenix.field_71088_bW = phoenix.func_82147_ab();
            ent.field_70128_L = true;
            phoenix.func_70107_b(newPosition.field_72450_a, newPosition.field_72448_b, newPosition.field_72449_c);
            newWorld.func_72838_d(phoenix);
        }
    }

    void endSlice() {
        DeltaChunk.getSlices(this.field_70170_p).remove(this);
        this.deregisterUniversalCollisionsForDeath();
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.endSlice();
    }

    public boolean func_70112_a(double distSquared) {
        int s = 160;
        return distSquared < (double)(s * s);
    }

    @Override
    public boolean canEnter(IDeltaChunk dse) {
        return false;
    }

    @Override
    public boolean canExit(IDeltaChunk dse) {
        return true;
    }

    @Override
    public void onEnter(IDeltaChunk dse) {
    }

    @Override
    public void onExit(IDeltaChunk dse) {
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int the_number_three) {
    }

    public void func_70024_g(double par1, double par3, double par5) {
        super.func_70024_g(par1, par3, par5);
        this.field_70160_al = false;
    }

    @Override
    public boolean can(DeltaCapability cap) {
        return cap.in(this.capabilities);
    }

    @Override
    public DimensionSliceEntity permit(DeltaCapability cap) {
        this.capabilities |= cap.bit;
        if (cap == DeltaCapability.ORACLE) {
            this.forbid(DeltaCapability.COLLIDE);
            this.forbid(DeltaCapability.DRAG);
            this.forbid(DeltaCapability.TAKE_INTERIOR_ENTITIES);
            this.forbid(DeltaCapability.REMOVE_EXTERIOR_ENTITIES);
            this.forbid(DeltaCapability.TRANSFER_PLAYERS);
            this.forbid(DeltaCapability.INTERACT);
            this.forbid(DeltaCapability.BLOCK_PLACE);
            this.forbid(DeltaCapability.BLOCK_MINE);
            this.forbid(DeltaCapability.REMOVE_ITEM_ENTITIES);
            this.forbid(DeltaCapability.REMOVE_ALL_ENTITIES);
            this.permit(DeltaCapability.SCALE);
            this.permit(DeltaCapability.TRANSPARENT);
        }
        return this;
    }

    @Override
    public DimensionSliceEntity forbid(DeltaCapability cap) {
        this.capabilities &= cap.bit ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    @Override
    public Quaternion getRotation() {
        return this.rotation;
    }

    @Override
    public Quaternion getRotationalVelocity() {
        return this.rotationalVelocity;
    }

    @Override
    public void setRotation(Quaternion r) {
        this.rotation = r;
    }

    @Override
    public void setRotationalVelocity(Quaternion w) {
        if (this.hasOrderedRotation()) {
            return;
        }
        this.rotationalVelocity = w;
    }

    @Override
    public boolean hasOrderedRotation() {
        return this.orderTimeStart != -1L;
    }

    @Override
    public void cancelOrderedRotation() {
        if (!this.field_70170_p.field_72995_K && this.orderTimeEnd > this.field_70170_p.func_82737_E()) {
            FMLProxyPacket toSend = HammerNet.makePacket((byte)12, this.func_145782_y(), this.getRotation(), this.getRotation(), -1, Interpolation.CONSTANT.ordinal());
            this.broadcastPacket(toSend);
        }
        this.orderTimeEnd = -1L;
        this.orderTimeStart = -1L;
    }

    @Override
    public void orderTargetRotation(Quaternion target, int tickTime, Interpolation interp) {
        target.incrNormalize();
        this.rotationStart = new Quaternion(this.getRotation());
        this.rotationEnd = new Quaternion(target);
        this.orderTimeStart = this.field_70170_p.func_82737_E();
        this.orderTimeEnd = this.orderTimeStart + (long)tickTime;
        this.orderInterp = interp;
        this.setRotationalVelocity(new Quaternion());
        if (!this.field_70170_p.field_72995_K) {
            FMLProxyPacket toSend = HammerNet.makePacket((byte)12, this.func_145782_y(), this.rotationStart, this.rotationEnd, tickTime, (byte)interp.ordinal());
            this.broadcastPacket(toSend);
        }
    }

    @Override
    public int getRemainingRotationTime() {
        long now = this.field_70170_p.func_82737_E();
        if (now > this.orderTimeEnd) {
            return 0;
        }
        return (int)(this.orderTimeEnd - now);
    }

    @Override
    public Quaternion getOrderedRotationTarget() {
        return this.rotationEnd;
    }

    @Override
    public Vec3 getRotationalCenterOffset() {
        return this.centerOffset;
    }

    @Override
    public void setRotationalCenterOffset(Vec3 newOffset) {
        this.centerOffset = newOffset;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (newOffset == null) {
            throw new NullPointerException();
        }
        FMLProxyPacket toSend = HammerNet.makePacket((byte)10, this.func_145782_y(), this.centerOffset);
        this.broadcastPacket(toSend);
    }

    private Quaternion getOrderedRotation(long tick) {
        Quaternion useStart = this.rotationStart;
        Quaternion useEnd = this.rotationEnd;
        IDeltaChunk parent = this.getParent();
        if (parent != null) {
            useStart = new Quaternion(useStart);
            useEnd = new Quaternion(useEnd);
            while (parent != null) {
                Quaternion pRot = parent.getRotation();
                pRot.incrToOtherMultiply(useEnd);
                parent = parent.getParent();
            }
        }
        if (tick <= this.orderTimeStart) {
            return new Quaternion(useStart);
        }
        if (tick >= this.orderTimeEnd) {
            return new Quaternion(useEnd);
        }
        double d = this.orderTimeEnd - this.orderTimeStart;
        double t = (double)(tick - this.orderTimeStart) / d;
        t = this.orderInterp.scale(t);
        Quaternion ret = useStart.slerp(useEnd, t);
        ret.incrNormalize();
        return ret;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    Entity[] getRayParts() {
        if (!this.field_70170_p.field_72995_K) {
            return null;
        }
        if (!this.can(DeltaCapability.INTERACT)) {
            return null;
        }
        if (this.rayOutOfDate) {
            if (this.raypart == null) {
                this.raypart = new Entity[1];
                this.rayTarget = new DseRayTarget(this);
                this.raypart[0] = this.rayTarget;
            }
            this.rayOutOfDate = false;
            Hammer.proxy.updateRayPosition(this.rayTarget);
        }
        return this.raypart;
    }

    private void broadcastPacket(FMLProxyPacket toSend) {
        HammerNet.channel.sendToAllAround(toSend, new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
    }

    public ItemStack[] func_70035_c() {
        return blast_protection;
    }

    static {
        ItemStack is = DimensionSliceEntity.blast_protection[0] = new ItemStack((Item)Items.field_151163_ad, 0, 0);
        is.func_77966_a(Enchantment.field_77327_f, 88);
    }
}

