/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.coremodhooks.HookTargetsClient;
import factorization.coremodhooks.IExtraChunkData;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.DseRayTarget;
import factorization.fzds.Hammer;
import factorization.fzds.HammerProxy;
import factorization.fzds.RenderDimensionSliceEntity;
import factorization.fzds.ShadowRenderGlobal;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.util.NumUtil;
import factorization.util.SpaceUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class HammerClientProxy
extends HammerProxy {
    private static World lastWorld = null;
    static ShadowRenderGlobal shadowRenderGlobal = null;
    private static NetHandlerPlayClient send_queue;
    private boolean send_queue_spam = false;
    private EntityClientPlayerMP real_player = null;
    private WorldClient real_world = null;
    private EntityClientPlayerMP fake_player = null;
    final Minecraft mc = Minecraft.func_71410_x();
    double _distance;
    MovingObjectPosition _shadowSelected;
    DseRayTarget _rayTarget;
    AxisAlignedBB _selectionBlockBounds;
    DimensionSliceEntity _hitSlice;

    public HammerClientProxy() {
        RenderDimensionSliceEntity rwe = new RenderDimensionSliceEntity();
        RenderingRegistry.registerEntityRenderingHandler(DimensionSliceEntity.class, (Render)rwe);
        Core.loadBus(rwe);
    }

    @Override
    public World getClientRealWorld() {
        if (this.real_world == null) {
            return Minecraft.func_71410_x().field_71441_e;
        }
        return this.real_world;
    }

    void checkForWorldChange() {
        WorldClient currentWorld = Minecraft.func_71410_x().field_71441_e;
        if (currentWorld != lastWorld) {
            lastWorld = currentWorld;
            if (lastWorld == null) {
                return;
            }
            if (Hammer.worldClient != null) {
                ((HammerWorldClient)Hammer.worldClient).clearAccesses();
                shadowRenderGlobal = new ShadowRenderGlobal((World)currentWorld);
                Hammer.worldClient.func_72954_a((IWorldAccess)shadowRenderGlobal);
            }
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.checkForWorldChange();
        this.runShadowTick();
        if (shadowRenderGlobal != null) {
            shadowRenderGlobal.removeStaleDamage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createClientShadowWorld() {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        if (world == null || mc.field_71439_g == null) {
            Hammer.worldClient = null;
            send_queue = null;
            this.fake_player = null;
            return;
        }
        send_queue = mc.field_71439_g.field_71174_a;
        WorldInfo wi = world.func_72912_H();
        try {
            HookTargetsClient.abort.set(Boolean.TRUE);
            Hammer.worldClient = new HammerWorldClient(send_queue, new WorldSettings(wi), Hammer.getDimensionId(), world.field_73013_u, Core.proxy.getProfiler());
        }
        finally {
            HookTargetsClient.abort.remove();
        }
        shadowRenderGlobal = new ShadowRenderGlobal((World)mc.field_71441_e);
        Hammer.worldClient.func_72954_a((IWorldAccess)shadowRenderGlobal);
    }

    @SubscribeEvent
    public void onClientLogout(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.cleanupClientWorld();
    }

    @Override
    public void cleanupClientWorld() {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
            return;
        }
        if (Hammer.worldClient != null) {
            ((HammerWorldClient)Hammer.worldClient).clearAccesses();
        }
        Hammer.worldClient = null;
        send_queue = null;
        this.fake_player = null;
        Hammer.clientSlices.clear();
    }

    private void setSendQueueWorld(WorldClient wc) {
        if (send_queue == null) {
            if (!this.send_queue_spam) {
                Core.logSevere("send_queue is null!?", new Object[0]);
                this.send_queue_spam = true;
            }
            return;
        }
        HammerClientProxy.send_queue.field_147300_g = wc;
    }

    private void setWorldAndPlayer(WorldClient wc, EntityClientPlayerMP player) {
        Minecraft mc = Minecraft.func_71410_x();
        if (wc == null) {
            Core.logSevere("Setting client world to null. PREPARE FOR IMPACT.", new Object[0]);
        }
        mc.field_71441_e = wc;
        mc.field_71439_g = player;
        mc.field_71439_g.field_70170_p = wc;
        this.setSendQueueWorld(wc);
        mc.field_71451_h = player;
        if (TileEntityRendererDispatcher.field_147556_a.field_147550_f != null) {
            TileEntityRendererDispatcher.field_147556_a.field_147550_f = wc;
        }
        if (RenderManager.field_78727_a.field_78722_g != null) {
            RenderManager.field_78727_a.field_78722_g = wc;
        }
        mc.field_71438_f.field_72769_h = wc;
    }

    @Override
    public void setShadowWorld() {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient w = (WorldClient)DeltaChunk.getClientShadowWorld();
        assert (w != null);
        if (this.real_player != null || this.real_world != null) {
            Core.logSevere("Tried to switch to Shadow world, but we're already in the shadow world", new Object[0]);
            return;
        }
        if (this.real_player == null) {
            this.real_player = mc.field_71439_g;
            if (this.real_player == null) {
                Core.logSevere("Swapping out to hammer world, but thePlayer is null", new Object[0]);
            }
        }
        if (this.real_world == null) {
            this.real_world = mc.field_71441_e;
            if (this.real_world == null) {
                Core.logSevere("Swapping out to hammer world, but theWorld is null", new Object[0]);
            }
        }
        this.real_player.field_70170_p = w;
        if (this.fake_player == null || w != this.fake_player.field_70170_p) {
            this.fake_player = new EntityClientPlayerMP(mc, (World)mc.field_71441_e, mc.func_110432_I(), this.real_player.field_71174_a, this.real_player.func_146107_m());
            this.fake_player.field_71158_b = this.real_player.field_71158_b;
        }
        this.setWorldAndPlayer(w, this.fake_player);
    }

    @Override
    public void restoreRealWorld() {
        this.setWorldAndPlayer(this.real_world, this.real_player);
        this.real_world = null;
        this.real_player = null;
    }

    @Override
    public boolean isInShadowWorld() {
        return this.real_world != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runShadowTick() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147113_T()) {
            return;
        }
        WorldClient mcWorld = mc.field_71441_e;
        if (mcWorld == null) {
            return;
        }
        EntityClientPlayerMP mcPlayer = mc.field_71439_g;
        if (mcPlayer == null) {
            return;
        }
        HammerWorldClient w = (HammerWorldClient)DeltaChunk.getClientShadowWorld();
        if (w == null) {
            return;
        }
        int range = 10;
        AxisAlignedBB nearby = mcPlayer.field_70121_D.func_72314_b((double)range, (double)range, (double)range);
        List nearbyChunks = mcWorld.func_72872_a(IDeltaChunk.class, nearby);
        this.setShadowWorld();
        Core.profileStart("FZDStick");
        try {
            w.func_72939_s();
            Vec3 playerPos = Vec3.func_72443_a((double)mcPlayer.field_70165_t, (double)mcPlayer.field_70163_u, (double)mcPlayer.field_70161_v);
            for (IDeltaChunk idc : nearbyChunks) {
                Vec3 center = idc.real2shadow(playerPos);
                w.func_73029_E((int)center.field_72450_a, (int)center.field_72448_b, (int)center.field_72449_c);
            }
            w.shadowTick();
        }
        finally {
            Core.profileEnd();
            this.restoreRealWorld();
        }
    }

    @Override
    public void clientInit() {
    }

    @SubscribeEvent
    public void resetTracing(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this._distance = Double.POSITIVE_INFINITY;
    }

    public void offerHit(MovingObjectPosition mop, DseRayTarget rayTarget, AxisAlignedBB moppedBounds) {
        double d = rayTarget.func_70068_e((Entity)this.mc.field_71439_g);
        if (d > this._distance) {
            return;
        }
        this._shadowSelected = mop;
        this._rayTarget = rayTarget;
        this._selectionBlockBounds = moppedBounds;
        this._hitSlice = rayTarget.parent;
        this._distance = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void renderSelection(DrawBlockHighlightEvent event) {
        if (!(event.target.field_72308_g instanceof DseRayTarget)) {
            return;
        }
        AxisAlignedBB box = this._selectionBlockBounds;
        MovingObjectPosition shadowSelected = this._shadowSelected;
        if (box == null || shadowSelected.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        Coord here = new Coord(DeltaChunk.getClientShadowWorld(), shadowSelected.field_72311_b, shadowSelected.field_72312_c, shadowSelected.field_72309_d);
        BlockRenderHelper hereBlock = BlockRenderHelper.instance;
        hereBlock.func_149676_a((float)(box.field_72340_a - (double)here.x), (float)(box.field_72338_b - (double)here.y), (float)(box.field_72339_c - (double)here.z), (float)(box.field_72336_d - (double)here.x), (float)(box.field_72337_e - (double)here.y), (float)(box.field_72334_f - (double)here.z));
        EntityPlayer player = event.player;
        RenderGlobal rg = event.context;
        ItemStack is = event.currentItem;
        float partialTicks = event.partialTicks;
        DimensionSliceEntity dse = this._hitSlice;
        Coord corner = dse.getCorner();
        Quaternion rotation = dse.prevTickRotation;
        try {
            GL11.glPushMatrix();
            this.setShadowWorld();
            GL11.glDisable((int)3008);
            GL11.glTranslated((double)NumUtil.interp(dse.field_70142_S - player.field_70142_S, dse.field_70165_t - player.field_70165_t, (double)partialTicks), (double)NumUtil.interp(dse.field_70137_T - player.field_70137_T, dse.field_70163_u - player.field_70163_u, (double)partialTicks), (double)NumUtil.interp(dse.field_70136_U - player.field_70136_U, dse.field_70161_v - player.field_70161_v, (double)partialTicks));
            Quaternion rot = new Quaternion(rotation);
            rot.incrNormalize();
            rot.glRotate();
            Vec3 centerOffset = dse.getRotationalCenterOffset();
            GL11.glTranslated((double)(-centerOffset.field_72450_a - (double)corner.x), (double)(-centerOffset.field_72448_b - (double)corner.y), (double)(-centerOffset.field_72449_c - (double)corner.z));
            double savePlayerX = player.field_70165_t;
            double savePlayerY = player.field_70163_u;
            double savePlayerZ = player.field_70161_v;
            partialTicks = 1.0f;
            player.field_70161_v = 0.0;
            player.field_70163_u = 0.0;
            player.field_70165_t = 0.0;
            if (!ForgeHooksClient.onDrawBlockHighlight((RenderGlobal)rg, (EntityPlayer)player, (MovingObjectPosition)shadowSelected, (int)shadowSelected.subHit, (ItemStack)is, (float)partialTicks)) {
                rg.func_72731_b(player, shadowSelected, 0, partialTicks);
            }
            player.field_70165_t = savePlayerX;
            player.field_70163_u = savePlayerY;
            player.field_70161_v = savePlayerZ;
        }
        finally {
            GL11.glEnable((int)3008);
            this.restoreRealWorld();
            GL11.glPopMatrix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void updateRayPosition(DseRayTarget ray) {
        if (ray.parent.metaAABB == null) {
            return;
        }
        origMouseOver = this.mc.field_71476_x;
        this.mc.field_71476_x = null;
        player = this.mc.field_71439_g;
        realPos = player.func_70666_h(1.0f);
        tmp = player.func_70040_Z();
        SpaceUtil.incrAdd(tmp, realPos);
        realLookEnd = tmp;
        shadowPos = ray.parent.real2shadow(realPos);
        tmp_shadowLookEnd = ray.parent.real2shadow(realLookEnd);
        SpaceUtil.incrSubtract(tmp_shadowLookEnd, shadowPos);
        shadowLook = tmp_shadowLookEnd;
        xz_len = Math.hypot(shadowLook.field_72450_a, shadowLook.field_72449_c);
        shadow_pitch = -Math.toDegrees(Math.atan2(shadowLook.field_72448_b, xz_len));
        shadow_yaw = Math.toDegrees(Math.atan2(-shadowLook.field_72450_a, shadowLook.field_72449_c));
        try {
            mop = null;
            mopBox = null;
            this.setShadowWorld();
            try {
                this.mc.field_71439_g.field_70165_t = shadowPos.field_72450_a;
                this.mc.field_71439_g.field_70163_u = shadowPos.field_72448_b;
                this.mc.field_71439_g.field_70161_v = shadowPos.field_72449_c;
                this.mc.field_71439_g.field_70125_A = (float)shadow_pitch;
                this.mc.field_71439_g.field_70177_z = (float)shadow_yaw;
                origType = this.mc.field_71442_b.field_78779_k;
                this.mc.field_71442_b.field_78779_k = WorldSettings.GameType.CREATIVE;
                try {
                    this.mc.field_71460_t.func_78473_a(1.0f);
                }
                finally {
                    this.mc.field_71442_b.field_78779_k = origType;
                }
                mop = this.mc.field_71476_x;
                if (mop == null) {
                    return;
                }
                switch (1.$SwitchMap$net$minecraft$util$MovingObjectPosition$MovingObjectType[mop.field_72313_a.ordinal()]) {
                    case 1: {
                        mopBox = mop.field_72308_g.field_70121_D;
                        ** break;
lbl45:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        w = DeltaChunk.getClientShadowWorld();
                        block = w.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                        mopBox = block.func_149633_g(w, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                        ** break;
lbl51:
                        // 1 sources

                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            finally {
                this.restoreRealWorld();
            }
            if (mopBox == null) {
                ray.func_70107_b(0.0, -1000.0, 0.0);
                return;
            }
            corners = SpaceUtil.getCorners(mopBox);
            min = ray.parent.shadow2real(corners[0]);
            max = min.func_72441_c(0.0, 0.0, 0.0);
            for (i = 1; i < corners.length; ++i) {
                c = ray.parent.shadow2real(corners[i]);
                min.field_72450_a = Math.min(c.field_72450_a, min.field_72450_a);
                min.field_72448_b = Math.min(c.field_72448_b, min.field_72448_b);
                min.field_72449_c = Math.min(c.field_72449_c, min.field_72449_c);
                max.field_72450_a = Math.max(c.field_72450_a, max.field_72450_a);
                max.field_72448_b = Math.max(c.field_72448_b, max.field_72448_b);
                max.field_72449_c = Math.max(c.field_72449_c, max.field_72449_c);
            }
            ray.func_70107_b((min.field_72450_a + max.field_72450_a) / 2.0, (min.field_72448_b + max.field_72448_b) / 2.0, (min.field_72449_c + max.field_72449_c) / 2.0);
            SpaceUtil.setMin(ray.field_70121_D, min);
            SpaceUtil.setMax(ray.field_70121_D, max);
            this.offerHit(mop, ray, mopBox);
            return;
        }
        finally {
            this.mc.field_71476_x = origMouseOver;
        }
    }

    @Override
    MovingObjectPosition getShadowHit() {
        return this._shadowSelected;
    }

    @Override
    IDeltaChunk getHitIDC() {
        return this._hitSlice;
    }

    @SubscribeEvent
    public void showUniversalCollidersInfo(RenderGameOverlayEvent.Text event) {
        if (this.mc.field_71439_g == null) {
            return;
        }
        if (!this.mc.field_71474_y.field_74330_P) {
            return;
        }
        Coord at = new Coord((Entity)this.mc.field_71439_g);
        IExtraChunkData ed = (IExtraChunkData)at.getChunk();
        Entity[] objs = ed.getConstantColliders();
        if (objs == null) {
            return;
        }
        event.left.add("uc: " + objs.length);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$net$minecraft$util$MovingObjectPosition$MovingObjectType;

        static {
            $SwitchMap$net$minecraft$util$MovingObjectPosition$MovingObjectType = new int[MovingObjectPosition.MovingObjectType.values().length];
            try {
                1.$SwitchMap$net$minecraft$util$MovingObjectPosition$MovingObjectType[MovingObjectPosition.MovingObjectType.ENTITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$minecraft$util$MovingObjectPosition$MovingObjectType[MovingObjectPosition.MovingObjectType.BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class HammerWorldClient
    extends WorldClient {
        public HammerWorldClient(NetHandlerPlayClient par1NetClientHandler, WorldSettings par2WorldSettings, int par3, EnumDifficulty par4, Profiler par5Profiler) {
            super(par1NetClientHandler, par2WorldSettings, par3, par4, par5Profiler);
        }

        public void func_72956_a(Entity par1Entity, String par2Str, float par3, float par4) {
            super.func_72956_a(par1Entity, par2Str, par3, par4);
        }

        public void clearAccesses() {
            this.field_73021_x.clear();
        }

        public void shadowTick() {
            this.field_73033_b.func_73156_b();
        }
    }

    public static class HammerChunkProviderClient
    extends ChunkProviderClient {
        public HammerChunkProviderClient(World par1World) {
            super(par1World);
        }
    }
}

