/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import factorization.api.Coord;
import factorization.common.FzConfig;
import factorization.misc.LagssieWatchDog;
import factorization.misc.MiscClientCommands;
import factorization.util.ItemUtil;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;

public class MiscClientTickHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    int count = 0;
    boolean hit = false;
    boolean wasClicked = false;
    static KeyBinding sprint = new KeyBinding("Sprint (FZ)", 0, "key.categories.movement");
    boolean prevState = false;
    long old_now = -1L;
    long interval = 30L;
    String last_msg = null;
    boolean mentioned_disabling = false;

    @SubscribeEvent
    public void clientTicks(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.type != TickEvent.Type.CLIENT) {
            return;
        }
        this.emitLoadAlert();
        this.checkPickBlockKey();
        this.checkSprintKey();
        MiscClientCommands.tick();
        this.notifyTimeOnFullScreen();
    }

    private void emitLoadAlert() {
        if (this.hit) {
            return;
        }
        if (this.count == 40) {
            if (this.mc.field_71462_r instanceof GuiMainMenu) {
                this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
            this.hit = true;
            LagssieWatchDog.start();
        }
        ++this.count;
    }

    private void checkPickBlockKey() {
        if (!this.mc.field_71474_y.field_74322_I.func_151470_d()) {
            this.wasClicked = false;
            return;
        }
        EntityClientPlayerMP player = this.mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (this.mc.field_71462_r != null) {
            return;
        }
        if (this.wasClicked) {
            return;
        }
        this.wasClicked = true;
        MovingObjectPosition mop = this.mc.field_71476_x;
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        Coord here = new Coord(player.field_70170_p, mop);
        if (this.vanillaSatisfied(mop, here, (EntityPlayer)player)) {
            return;
        }
        List<ItemStack> validItems = Arrays.asList(here.getPickBlock(mop), here.getBrokenBlock(), new ItemStack(here.getId(), 1, here.getMd()));
        int firstEmpty = -1;
        if (player.func_70694_bm() == null) {
            firstEmpty = player.field_71071_by.field_70461_c;
        }
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            for (ItemStack needle : validItems) {
                if (needle == null) continue;
                ItemStack is = player.field_71071_by.field_70462_a[i];
                if (is == null && firstEmpty == -1 && i < 9) {
                    firstEmpty = i;
                }
                if (is == null || !ItemUtil.couldMerge(needle, is)) continue;
                if (i < 9) {
                    player.field_71071_by.field_70461_c = i;
                    return;
                }
                if (firstEmpty != -1) {
                    player.field_71071_by.field_70461_c = firstEmpty;
                }
                int targetSlot = player.field_71071_by.field_70461_c;
                this.mc.field_71442_b.func_78753_a(player.field_71069_bz.field_75152_c, i, targetSlot, 2, (EntityPlayer)player);
                return;
            }
        }
    }

    private boolean vanillaSatisfied(MovingObjectPosition mop, Coord here, EntityPlayer player) {
        ItemStack held = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
        if (held == null) {
            return false;
        }
        if (ItemUtil.couldMerge(held, here.getPickBlock(mop))) {
            return true;
        }
        return ItemUtil.couldMerge(held, here.getBrokenBlock());
    }

    private void checkSprintKey() {
        if (this.mc.field_71462_r != null) {
            return;
        }
        if (this.mc.field_71439_g == null) {
            return;
        }
        if (sprint.func_151463_i() == 0) {
            return;
        }
        boolean state = sprint.func_151470_d();
        int forwardCode = this.mc.field_71474_y.field_74351_w.func_151463_i();
        if (state) {
            if (!this.mc.field_71439_g.func_70093_af()) {
                KeyBinding.func_74510_a((int)forwardCode, (boolean)true);
                this.mc.field_71439_g.func_70031_b(true);
            }
        } else if (this.prevState) {
            KeyBinding.func_74510_a((int)forwardCode, (boolean)false);
            this.mc.field_71439_g.func_70031_b(false);
        }
        this.prevState = state;
    }

    long getNow() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return -1L;
        }
        Calendar cal = world.func_83015_S();
        return (long)cal.get(12) / this.interval;
    }

    public void notifyTimeOnFullScreen() {
        if (!FzConfig.show_time_on_fullscreen) {
            return;
        }
        if (this.interval <= 0L) {
            return;
        }
        long now = this.getNow();
        if (now == this.old_now || now == -1L) {
            return;
        }
        this.old_now = now;
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_71372_G()) {
            return;
        }
        DateFormat df = DateFormat.getTimeInstance(3);
        String msg = df.format(new Date());
        if (!this.mentioned_disabling) {
            msg = msg + " (via FZ)";
            this.mentioned_disabling = true;
        }
        ChatStyle style = new ChatStyle().func_150217_b(Boolean.valueOf(true)).func_150238_a(EnumChatFormatting.GRAY);
        mc.field_71456_v.func_146158_b().func_146234_a(new ChatComponentText(msg).func_150255_a(style), 20392);
        this.last_msg = msg;
    }

    static {
        ClientRegistry.registerKeyBinding((KeyBinding)sprint);
    }
}

