/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.common.BlockIcons;
import factorization.servo.Decorator;
import factorization.servo.ServoComponent;
import factorization.servo.TileEntityServoRail;
import factorization.shared.Core;
import factorization.shared.ItemFactorization;
import factorization.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemServoRailWidget
extends ItemFactorization {
    private List<ItemStack> subItemsCache = null;

    public ItemServoRailWidget(String name2) {
        super(name2, Core.TabType.SERVOS);
    }

    public String func_77667_c(ItemStack is) {
        ServoComponent sc = this.get(is);
        if (sc == null) {
            return super.func_77658_a();
        }
        return super.func_77667_c(is) + "." + sc.getName();
    }

    public String func_77653_i(ItemStack is) {
        String s = super.func_77653_i(is);
        if (s == null || s.length() == 0) {
            s = this.func_77667_c(is);
        }
        return s;
    }

    ServoComponent get(ItemStack is) {
        if (!is.func_77942_o()) {
            return null;
        }
        return ServoComponent.load(is.func_77978_p());
    }

    void update(ItemStack is, ServoComponent sc) {
        if (sc != null) {
            sc.save(ItemUtil.getTag(is));
        } else {
            is.func_77982_d(null);
        }
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float vx, float vy, float vz) {
        ServoComponent sc = this.get(is);
        if (sc == null) {
            return false;
        }
        Coord here = new Coord(world, x, y, z);
        TileEntityServoRail rail = here.getTE(TileEntityServoRail.class);
        if (rail == null) {
            sc.onItemUse(here, player);
        } else if (sc instanceof Decorator) {
            Decorator dec = (Decorator)sc;
            if (rail != null && rail.decoration == null) {
                rail.setDecoration(dec);
                if (world.field_72995_K) {
                    here.redraw();
                } else {
                    here.markBlockForUpdate();
                    rail.showDecorNotification(player);
                }
                if (!dec.isFreeToPlace() && !player.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                }
            }
        }
        return super.func_77648_a(is, player, world, x, y, z, side, vx, vy, vz);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addExtraInformation(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        ServoComponent sc = this.get(is);
        if (sc != null) {
            sc.addInformation(list);
        }
    }

    void loadSubItems() {
        if (this.subItemsCache != null) {
            return;
        }
        this.subItemsCache = this == Core.registry.servo_widget_instruction ? ServoComponent.sorted_instructions : (this == Core.registry.servo_widget_decor ? ServoComponent.sorted_decors : new ArrayList<ItemStack>());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs tab, List list) {
        this.loadSubItems();
        list.addAll(this.subItemsCache);
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.getIcon(stack, renderPass);
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 0) {
            return BlockIcons.servo$instruction_plate;
        }
        if (pass == 1) {
            ServoComponent sc = this.get(stack);
            IIcon ret = null;
            if (sc instanceof Decorator) {
                ret = ((Decorator)sc).getIcon(ForgeDirection.UNKNOWN);
            }
            if (ret == null) {
                ret = BlockIcons.uv_test;
            }
            return ret;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IIconRegister) {
    }
}

