/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import factorization.api.Coord;
import factorization.api.FzColor;
import factorization.api.FzOrientation;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.servo.ServoMotor;
import factorization.servo.TileEntityServoRail;
import factorization.shared.Core;
import factorization.util.SpaceUtil;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class MotionHandler {
    public final ServoMotor motor;
    Coord pos_prev;
    Coord pos_next;
    float pos_progress;
    FzOrientation prevOrientation = FzOrientation.UNKNOWN;
    FzOrientation orientation = FzOrientation.UNKNOWN;
    FzOrientation pendingClientOrientation = FzOrientation.UNKNOWN;
    ForgeDirection nextDirection = ForgeDirection.UNKNOWN;
    ForgeDirection lastDirection = ForgeDirection.UNKNOWN;
    byte speed_b;
    byte target_speed_index = (byte)2;
    static final byte max_speed_b = 127;
    double accumulated_motion;
    boolean stopped = false;
    FzColor color = FzColor.NO_COLOR;
    double sprocket_rotation = 0.0;
    double prev_sprocket_rotation = 0.0;
    double servo_reorient = 0.0;
    double prev_servo_reorient = 0.0;
    private static final byte normal_speed_byte = 31;
    private static final byte[] target_speeds_b = new byte[]{10, 15, 31, 62, 124};
    private static final double normal_speed_double = 0.0875;
    private static final double max_speed_double = 0.35;

    public MotionHandler(ServoMotor motor) {
        this.motor = motor;
        this.pos_prev = new Coord(motor.field_70170_p, 0, 0, 0);
        this.pos_next = this.pos_prev.copy();
    }

    void putData(DataHelper data) throws IOException {
        this.orientation = data.as(Share.VISIBLE, "Orient").putFzOrientation(this.orientation);
        this.nextDirection = data.as(Share.VISIBLE, "nextDir").putEnum(this.nextDirection);
        this.lastDirection = data.as(Share.VISIBLE, "lastDir").putEnum(this.lastDirection);
        this.speed_b = data.as(Share.VISIBLE, "speedb").putByte(this.speed_b);
        this.setTargetSpeed(data.as(Share.VISIBLE, "speedt").putByte(this.target_speed_index));
        this.accumulated_motion = data.as(Share.VISIBLE, "accumulated_motion").putDouble(this.accumulated_motion);
        this.stopped = data.as(Share.VISIBLE, "stop").putBoolean(this.stopped);
        this.pos_next = data.as(Share.VISIBLE, "pos_next").put(this.pos_next);
        this.pos_prev = data.as(Share.VISIBLE, "pos_prev").put(this.pos_prev);
        this.pos_progress = data.as(Share.VISIBLE, "pos_progress").putFloat(this.pos_progress);
        if (this.target_speed_index < 0) {
            this.target_speed_index = 0;
        } else if (this.target_speed_index >= target_speeds_b.length) {
            this.target_speed_index = (byte)(target_speeds_b.length - 1);
        }
        if (data.isNBT() && data.isReader() && !data.hasLegacy("color")) {
            this.color = FzColor.NO_COLOR;
        }
        this.color = data.as(Share.VISIBLE, "color").putEnum(this.color);
        if (this.color == null) {
            this.color = FzColor.NO_COLOR;
        }
    }

    public void setTargetSpeed(byte newSpeed) {
        if (newSpeed < 0) {
            newSpeed = 0;
        } else if (newSpeed >= target_speeds_b.length) {
            newSpeed = (byte)(target_speeds_b.length - 1);
        }
        this.target_speed_index = newSpeed;
    }

    void beforeSpawn() {
        this.pos_prev = new Coord(this.motor);
        this.pos_next = this.pos_prev.copy();
        this.pickNextOrientation();
        this.pickNextOrientation();
        this.interpolatePosition(0.0f);
        this.prevOrientation = this.orientation;
    }

    public void interpolatePosition(float interp) {
        this.motor.func_70107_b(MotionHandler.ip(this.pos_prev.x, this.pos_next.x, interp), MotionHandler.ip(this.pos_prev.y, this.pos_next.y, interp), MotionHandler.ip(this.pos_prev.z, this.pos_next.z, interp));
    }

    static double ip(int a, int b, float interp) {
        return (float)a + (float)(b - a) * interp;
    }

    void updateSpeed() {
        boolean should_accelerate;
        byte target_speed_b = target_speeds_b[this.target_speed_index];
        boolean bl = should_accelerate = this.speed_b < target_speed_b && this.orientation != FzOrientation.UNKNOWN;
        if (this.speed_b > target_speed_b) {
            this.speed_b = (byte)Math.max(target_speed_b, this.speed_b * 3 / 4 - 1);
            return;
        }
        long now = this.motor.field_70170_p.func_82737_E();
        int m = 1 + this.target_speed_index;
        if (should_accelerate && now % 3L == 0L && (Core.cheat_servo_energy || this.motor.extractCharge(2))) {
            this.accelerate();
        }
    }

    public void penalizeSpeed() {
        if (this.speed_b > 4) {
            this.speed_b = (byte)(this.speed_b - 1);
        }
    }

    boolean validPosition(Coord c, boolean desperate) {
        TileEntityServoRail sr = c.getTE(TileEntityServoRail.class);
        if (sr == null) {
            return false;
        }
        return (sr.priority >= 0 || desperate) && !this.color.conflictsWith(sr.color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validDirection(ForgeDirection dir, boolean desperate) {
        Coord at = this.motor.getCurrentPos();
        at.adjust(dir);
        try {
            boolean bl = this.validPosition(at, desperate);
            return bl;
        }
        finally {
            at.adjust(dir.getOpposite());
        }
    }

    public boolean testDirection(ForgeDirection d, boolean desperate) {
        if (d == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.validDirection(d, desperate);
    }

    static int similarity(FzOrientation base, FzOrientation novel) {
        int score = 0;
        return score;
    }

    boolean pickNextOrientation() {
        boolean ret = this.pickNextOrientation_impl();
        this.pos_next = this.pos_prev.add(this.orientation.facing);
        return ret;
    }

    public void changeOrientation(ForgeDirection dir) {
        ForgeDirection orig_direction = this.orientation.facing;
        ForgeDirection orig_top = this.orientation.top;
        FzOrientation start = FzOrientation.fromDirection(dir);
        FzOrientation perfect = start.pointTopTo(orig_top);
        if (perfect == FzOrientation.UNKNOWN) {
            if (dir == orig_top) {
                perfect = start.pointTopTo(orig_direction.getOpposite());
            } else if (dir == orig_top.getOpposite()) {
                perfect = start.pointTopTo(orig_direction);
            }
            if (perfect == FzOrientation.UNKNOWN) {
                perfect = start;
            }
        }
        this.orientation = perfect;
        this.lastDirection = orig_direction;
        if (this.orientation.facing == this.nextDirection) {
            this.nextDirection = ForgeDirection.UNKNOWN;
        }
    }

    boolean pickNextOrientation_impl() {
        ArrayList<ForgeDirection> dirs = SpaceUtil.getRandomDirections(this.motor.field_70170_p.field_73012_v);
        int available_nonbackwards_directions = 0;
        Coord look = this.pos_next.copy();
        int all_count = 0;
        for (int i = 0; i < dirs.size(); ++i) {
            ForgeDirection fd = dirs.get(i);
            look.set(this.pos_next);
            look.adjust(fd);
            TileEntityServoRail sr = look.getTE(TileEntityServoRail.class);
            if (sr == null || this.color.conflictsWith(sr.color)) continue;
            ++all_count;
            if (fd == this.orientation.facing.getOpposite()) continue;
            if (sr.priority > 0) {
                this.changeOrientation(fd);
                return true;
            }
            if (sr.priority != 0) continue;
            ++available_nonbackwards_directions;
        }
        if (all_count == 0) {
            this.speed_b = 0;
            return false;
        }
        boolean desperate = available_nonbackwards_directions < 1;
        ForgeDirection direction = this.orientation.facing;
        ForgeDirection opposite = direction.getOpposite();
        if (this.nextDirection != opposite && this.testDirection(this.nextDirection, desperate)) {
            this.changeOrientation(this.nextDirection);
            return true;
        }
        if (this.testDirection(direction, desperate)) {
            return true;
        }
        if (this.lastDirection != opposite && this.testDirection(this.lastDirection, desperate)) {
            this.changeOrientation(this.lastDirection);
            return true;
        }
        ForgeDirection top = this.orientation.top;
        if (this.testDirection(top, desperate)) {
            this.changeOrientation(top);
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = dirs.get(i);
            if (d == this.nextDirection || d == direction || d == opposite || d == this.lastDirection || d == top || !this.validDirection(d, desperate)) continue;
            this.changeOrientation(d);
            return true;
        }
        if (this.validDirection(opposite, true)) {
            this.orientation = FzOrientation.fromDirection(opposite).pointTopTo(top);
            if (this.orientation != FzOrientation.UNKNOWN) {
                return true;
            }
        }
        this.orientation = FzOrientation.UNKNOWN;
        return false;
    }

    void accelerate() {
        this.speed_b = (byte)(this.speed_b + 1);
        this.speed_b = (byte)Math.min(this.speed_b, 127);
    }

    void moveMotor() {
        if (this.accumulated_motion == 0.0) {
            return;
        }
        double move = Math.min(this.accumulated_motion, (double)(1.0f - this.pos_progress));
        this.accumulated_motion -= move;
        this.pos_progress = (float)((double)this.pos_progress + move);
        if (this.motor.field_70170_p.field_72995_K) {
            this.sprocket_rotation += move;
            if (this.orientation != this.prevOrientation) {
                this.servo_reorient += move;
                if (this.servo_reorient >= 0.95) {
                    this.prev_servo_reorient = this.servo_reorient = 0.0;
                    this.prevOrientation = this.orientation;
                }
            } else {
                this.servo_reorient = 0.0;
            }
        }
    }

    public double getProperSpeed() {
        double perc = (double)this.speed_b / 127.0;
        return 0.35 * perc;
    }

    public void setStopped(boolean newState) {
        if (this.stopped == newState) {
            return;
        }
        this.stopped = newState;
    }

    void updateServoMotion() {
        this.prev_sprocket_rotation = this.sprocket_rotation;
        this.prev_servo_reorient = this.servo_reorient;
        this.doMotionLogic();
        this.interpolatePosition(this.pos_progress);
        if (this.stopped && this.motor.getCurrentPos().isWeaklyPowered()) {
            this.setStopped(false);
        }
    }

    void doMotionLogic() {
        this.doLogic();
        if (this.stopped) {
            this.speed_b = 0;
        }
    }

    private void doLogic() {
        double speed;
        if (this.stopped) {
            this.motor.updateSocket();
            return;
        }
        if (this.orientation == FzOrientation.UNKNOWN) {
            this.pickNextOrientation();
        }
        if (!this.motor.field_70170_p.field_72995_K) {
            this.updateSpeed();
        }
        if ((speed = this.getProperSpeed()) <= 0.0 || this.orientation == FzOrientation.UNKNOWN) {
            this.motor.updateSocket();
            return;
        }
        this.accumulated_motion += speed;
        this.moveMotor();
        if (this.pos_progress >= 1.0f) {
            this.pos_progress -= 1.0f;
            this.accumulated_motion = Math.min((double)this.pos_progress, speed);
            Chunk oldChunk = this.pos_prev.getChunk();
            Chunk newChunk = this.pos_next.getChunk();
            this.pos_prev = this.pos_next;
            this.motor.updateSocket();
            this.motor.onEnterNewBlock();
            this.pickNextOrientation();
            if (oldChunk != newChunk) {
                oldChunk.func_76630_e();
                newChunk.func_76630_e();
            }
        } else {
            this.motor.updateSocket();
        }
    }

    void onEnterNewBlock() {
        int m = this.target_speed_index + 1;
        if (!this.motor.extractCharge(m * 2)) {
            this.speed_b = (byte)Math.max(0, this.speed_b * 3 / 4 - 1);
        }
    }
}

