/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.datahelpers.DataInByteBuf;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataOutNBT;
import factorization.api.datahelpers.DataOutPacket;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import factorization.servo.instructions.BooleanValue;
import factorization.servo.instructions.Compare;
import factorization.servo.instructions.CountItems;
import factorization.servo.instructions.Drop;
import factorization.servo.instructions.Dup;
import factorization.servo.instructions.EntryControl;
import factorization.servo.instructions.GlassServoGrate;
import factorization.servo.instructions.InstructionGroup;
import factorization.servo.instructions.IntegerValue;
import factorization.servo.instructions.IronServoGrate;
import factorization.servo.instructions.Jump;
import factorization.servo.instructions.Product;
import factorization.servo.instructions.ReadRedstone;
import factorization.servo.instructions.RedstonePulse;
import factorization.servo.instructions.RotateTop;
import factorization.servo.instructions.ScanColor;
import factorization.servo.instructions.SetDirection;
import factorization.servo.instructions.SetEntryAction;
import factorization.servo.instructions.SetRepeatedInstruction;
import factorization.servo.instructions.SetSpeed;
import factorization.servo.instructions.ShifterControl;
import factorization.servo.instructions.SocketCtrl;
import factorization.servo.instructions.Spin;
import factorization.servo.instructions.Sum;
import factorization.servo.instructions.Trap;
import factorization.servo.instructions.WoodenServoGrate;
import factorization.shared.Core;
import factorization.util.RenderUtil;
import io.netty.buffer.ByteBuf;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ServoComponent
implements IDataSerializable {
    private static HashMap<String, Class<? extends ServoComponent>> componentMap = new HashMap(50, 0.5f);
    private static final String componentTagKey = "SCId";
    private static BiMap<Short, Class<? extends ServoComponent>> the_idMap = null;
    static ArrayList<ItemStack> sorted_instructions = new ArrayList();
    static ArrayList<ItemStack> sorted_decors = new ArrayList();

    public static void register(Class<? extends ServoComponent> componentClass, ArrayList<ItemStack> sortedList) {
        ServoComponent decor;
        try {
            decor = componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            Core.logSevere("Unable to instantiate %s: %s", componentClass, e);
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        String name2 = decor.getName();
        componentMap.put(name2, componentClass);
        sortedList.add(decor.toItem());
    }

    public static Class<? extends ServoComponent> getComponent(String name2) {
        return componentMap.get(name2);
    }

    private static BiMap<Short, Class<? extends ServoComponent>> getPacketIdMap() {
        if (the_idMap == null) {
            ArrayList<String> names = new ArrayList<String>(componentMap.keySet());
            Collections.sort(names);
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            for (short i = 0; i < names.size(); i = (short)(i + 1)) {
                builder.put((Object)i, componentMap.get(names.get(i)));
            }
            the_idMap = builder.build();
        }
        return the_idMap;
    }

    public static Iterable<Class<? extends ServoComponent>> getComponents() {
        return ServoComponent.getPacketIdMap().values();
    }

    public short getNetworkId() {
        BiMap map = ServoComponent.getPacketIdMap().inverse();
        Short o = (Short)map.get(this.getClass());
        if (o == null) {
            throw new IllegalArgumentException(this.getClass() + " is not a registered ServoComponent");
        }
        return o;
    }

    static ServoComponent load(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b(componentTagKey)) {
            return null;
        }
        String componentName = tag.func_74779_i(componentTagKey);
        Class<? extends ServoComponent> componentClass = ServoComponent.getComponent(componentName);
        if (componentClass == null) {
            Core.logWarning("Unknown servo component with ID %s. Removing tag info!", componentName);
            Core.logWarning("The tag: %s", tag);
            Thread.dumpStack();
            tag.func_82580_o(componentTagKey);
            return null;
        }
        try {
            ServoComponent decor = componentClass.newInstance();
            new DataInNBT(tag).as(Share.VISIBLE, "sc").put(decor);
            return decor;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    protected final void save(NBTTagCompound tag) {
        tag.func_74778_a(componentTagKey, this.getName());
        try {
            new DataOutNBT(tag).as(Share.VISIBLE, "sc").put(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void writeToPacket(DataOutputStream dos) throws IOException {
        dos.writeShort(this.getNetworkId());
        new DataOutPacket(dos, Side.SERVER).as(Share.VISIBLE, "sc").put(this);
    }

    static ServoComponent readFromPacket(ByteBuf dis) throws IOException {
        short id = dis.readShort();
        Class componentClass = (Class)ServoComponent.getPacketIdMap().get((Object)id);
        if (componentClass == null) {
            Core.logWarning("Unknown servo component with #ID %s", id);
            return null;
        }
        try {
            ServoComponent decor = (ServoComponent)componentClass.newInstance();
            new DataInByteBuf(dis, Side.CLIENT).as(Share.VISIBLE, "sc").put(decor);
            return decor;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemStack toItem() {
        ItemStack ret = this instanceof Instruction ? new ItemStack((Item)Core.registry.servo_widget_instruction) : new ItemStack((Item)Core.registry.servo_widget_decor);
        NBTTagCompound tag = new NBTTagCompound();
        this.save(tag);
        ret.func_77982_d(tag);
        String name2 = this.getName();
        int dmg = Math.abs(name2.hashCode()) % Short.MAX_VALUE;
        ret.func_77964_b(dmg);
        return ret;
    }

    public ServoComponent copyComponent() {
        NBTTagCompound tag = new NBTTagCompound();
        this.save(tag);
        return ServoComponent.load(tag);
    }

    public static ServoComponent fromItem(ItemStack is) {
        if (!is.func_77942_o()) {
            return null;
        }
        return ServoComponent.load(is.func_77978_p());
    }

    public abstract boolean onClick(EntityPlayer var1, Coord var2, ForgeDirection var3);

    public abstract boolean onClick(EntityPlayer var1, ServoMotor var2);

    public abstract String getName();

    @SideOnly(value=Side.CLIENT)
    public abstract void renderStatic(Coord var1, RenderBlocks var2);

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic() {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        this.renderStatic(null, RenderUtil.getRB());
        tess.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List info) {
    }

    public static void setupRecipes() {
        for (Class<? extends ServoComponent> klazz : componentMap.values()) {
            try {
                klazz.newInstance().addRecipes();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void addRecipes() {
    }

    public void onItemUse(Coord here, EntityPlayer player) {
    }

    static {
        Class[] decorations = new Class[]{WoodenServoGrate.class, GlassServoGrate.class, IronServoGrate.class, ScanColor.class};
        Class[] instructions = new Class[]{EntryControl.class, SetDirection.class, Spin.class, RotateTop.class, SetSpeed.class, Trap.class, RedstonePulse.class, SocketCtrl.class, ReadRedstone.class, CountItems.class, ShifterControl.class, Drop.class, Dup.class, IntegerValue.class, Sum.class, Product.class, BooleanValue.class, Compare.class, Jump.class, SetEntryAction.class, SetRepeatedInstruction.class, InstructionGroup.class};
        for (Class cl : decorations) {
            ServoComponent.register(cl, sorted_decors);
        }
        for (Class cl : instructions) {
            ServoComponent.register(cl, sorted_instructions);
        }
    }
}

