/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.BlockIcons;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class IntegerValue
extends Instruction {
    private int val = 1;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.setVal(data.asSameShare(prefix + "val").put(this.getVal()));
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Blocks.field_150411_aY);
    }

    @Override
    public void motorHit(ServoMotor motor) {
        motor.getArgStack().push(this.getVal());
    }

    @Override
    public IIcon getIcon(ForgeDirection side) {
        if (this.getVal() == 1) {
            return BlockIcons.servo$one;
        }
        if (this.getVal() == 0) {
            return BlockIcons.servo$zero;
        }
        if (this.getVal() == -1) {
            return BlockIcons.servo$negative_one;
        }
        return BlockIcons.servo$number;
    }

    @Override
    public String getName() {
        return "fz.instruction.integervalue";
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (IntegerValue.playerHasProgrammer(player)) {
            if (this.getVal() == -1) {
                this.setVal(1);
                return true;
            }
            if (this.getVal() == 1) {
                this.setVal(0);
                return true;
            }
            if (this.getVal() == 0) {
                this.setVal(-1);
                return true;
            }
        }
        return false;
    }

    @Override
    public String getInfo() {
        return "" + this.getVal();
    }

    public int getVal() {
        return this.val;
    }

    public void setVal(int val) {
        this.val = val;
    }
}

