/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import factorization.shared.Core;
import factorization.shared.ICaptureDrops;
import factorization.util.ItemUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;

public enum DropCaptureHandler {
    CATCHER;

    private ThreadLocal<ICaptureDrops> catchers = new ThreadLocal();

    private DropCaptureHandler() {
        Core.loadBus((Object)this);
    }

    public static void startCapture(ICaptureDrops catcher) {
        DropCaptureHandler.CATCHER.catchers.set(catcher);
    }

    public static void endCapture() {
        DropCaptureHandler.CATCHER.catchers.set(null);
    }

    void removeInvalids(Collection<ItemStack> drops) {
        Iterator<ItemStack> it = drops.iterator();
        while (it.hasNext()) {
            if (ItemUtil.normalize(it.next()) != null) continue;
            it.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void captureBlockDrops(BlockEvent.HarvestDropsEvent event) {
        ICaptureDrops catcher = this.catchers.get();
        if (catcher == null) {
            return;
        }
        this.removeInvalids(event.drops);
        if (catcher.captureDrops(event.x, event.y, event.z, event.drops)) {
            this.removeInvalids(event.drops);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void captureMobDrops(LivingDropsEvent event) {
        ICaptureDrops catcher = this.catchers.get();
        if (catcher == null) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (EntityItem ent : event.drops) {
            drops.add(ent.func_92059_d());
        }
        this.removeInvalids(drops);
        if (catcher.captureDrops((int)event.entity.field_70165_t, (int)event.entity.field_70163_u, (int)event.entity.field_70161_v, drops)) {
            Iterator it = event.drops.iterator();
            while (it.hasNext()) {
                EntityItem ent;
                ent = (EntityItem)it.next();
                if (ent != null && ItemUtil.normalize(ent.func_92059_d()) != null) continue;
                it.remove();
            }
        }
    }
}

