/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class ReservoirSampler<E>
implements Iterable<E> {
    private final ArrayList<E> samples;
    private final int desired;
    private final Random rand;
    private int given = 0;

    public ReservoirSampler(int desired, Random rand) {
        this.samples = new ArrayList(desired);
        this.desired = desired;
        if (rand == null) {
            rand = new Random();
        }
        this.rand = rand;
    }

    public void give(E sample) {
        if (this.given++ < this.desired) {
            this.samples.add(sample);
        } else {
            int j = this.rand.nextInt(this.given);
            if (j < this.desired) {
                this.samples.set(j, sample);
            }
        }
    }

    public List<E> getSamples() {
        return this.samples;
    }

    @Override
    public Iterator<E> iterator() {
        return this.samples.iterator();
    }

    public int size() {
        return this.samples.size();
    }
}

