/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzColor;
import factorization.api.IChargeConductor;
import factorization.api.ICoord;
import factorization.api.IFactoryType;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataOutByteBuf;
import factorization.api.datahelpers.DataOutNBT;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.migration.MigrationHelper;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzNetDispatch;
import factorization.shared.NetworkFactorization;
import factorization.util.ItemUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityCommon
extends TileEntity
implements ICoord,
IFactoryType {
    public static final byte serialization_version = 1;
    public static final String serialization_version_key = ".";
    protected static Random rand = new Random();
    public String customName = null;
    private long pulseTime = -1000L;
    public static final ForgeDirection[] empty_rotation_array = new ForgeDirection[0];
    public static final ForgeDirection[] flat_rotation_array = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    public static final ForgeDirection[] full_rotation_array = new ForgeDirection[6];

    public abstract BlockClass getBlockClass();

    public abstract void putData(DataHelper var1) throws IOException;

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.error;
    }

    public FMLProxyPacket getDescriptionPacket() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteBuf buf = Unpooled.buffer();
        DataOutByteBuf data = new DataOutByteBuf(buf, Side.SERVER);
        try {
            NetworkFactorization.MessageType.FactoryType.write(buf);
            buf.writeInt(this.field_145851_c);
            buf.writeInt(this.field_145848_d);
            buf.writeInt(this.field_145849_e);
            int ftId = this.getFactoryType().md;
            buf.writeByte(ftId);
            this.putData(data);
            return FzNetDispatch.generate(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void onRemove() {
        if (this instanceof IChargeConductor) {
            ((IChargeConductor)((Object)this)).getCharge().remove();
        }
    }

    protected void sendFullDescription(EntityPlayer player) {
    }

    public boolean canPlaceAgainst(EntityPlayer player, Coord c, int side) {
        return true;
    }

    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        if (is != null && is.func_77942_o()) {
            this.loadFromStack(is);
        }
    }

    public void loadFromStack(ItemStack is) {
        this.customName = ItemUtil.getCustomItemName(is);
    }

    protected boolean removedByPlayer(EntityPlayer player, boolean willHarvest) {
        return this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void click(EntityPlayer entityplayer) {
    }

    public void neighborChanged() {
    }

    public void pulse() {
        Coord here = this.getCoord();
        if (here.w.field_72995_K) {
            return;
        }
        long now = this.field_145850_b.func_82737_E();
        if (this.pulseTime + 4L >= now) {
            return;
        }
        this.pulseTime = now;
        here.notifyNeighbors();
        here.scheduleUpdate(4);
    }

    public boolean power() {
        return this.pulseTime + 4L > this.field_145850_b.func_82737_E();
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        this.setBlockBounds(Core.registry.resource_block);
        AxisAlignedBB ret = Core.registry.resource_block.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Core.registry.resource_block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return ret;
    }

    public boolean addCollisionBoxesToList(Block block, AxisAlignedBB aabb, List list, Entity entity) {
        return false;
    }

    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        return Blocks.field_150348_b.func_149731_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, startVec, endVec);
    }

    public void setBlockBounds(Block b) {
        b.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public Coord getCoord() {
        return new Coord(this);
    }

    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        FactoryType type = this.getFactoryType();
        if (type.hasGui) {
            if (!entityplayer.field_70170_p.field_72995_K) {
                this.sendFullDescription(entityplayer);
                entityplayer.openGui((Object)Core.instance, type.gui, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        return false;
    }

    public boolean isBlockSolidOnSide(int side) {
        return true;
    }

    public boolean takeUpgrade(ItemStack is) {
        return false;
    }

    public final void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a(serialization_version_key, (byte)1);
        if (this.customName != null) {
            tag.func_74778_a("customName", this.customName);
        }
        if (this.field_145850_b != null && this.power()) {
            tag.func_74772_a("rps", this.pulseTime);
        }
        try {
            DataOutNBT data = new DataOutNBT(tag);
            this.putData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void func_145839_a(NBTTagCompound tag) {
        byte v;
        super.func_145839_a(tag);
        if (tag.func_74764_b("customName")) {
            this.customName = tag.func_74779_i("customName");
        }
        if (tag.func_74764_b("rps")) {
            this.pulseTime = tag.func_74763_f("rps");
        }
        if ((v = tag.func_74771_c(serialization_version_key)) < 1) {
            MigrationHelper.migrate(v, this.getFactoryType(), this, tag);
            this.func_70296_d();
        }
        try {
            DataInNBT data = new DataInNBT(tag);
            this.putData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected final void writeBuffer(String bufferName, NBTTagCompound tag, ArrayList<ItemStack> outputBuffer) {
        if (outputBuffer.size() > 0) {
            NBTTagList buffer = new NBTTagList();
            for (ItemStack item : outputBuffer) {
                if (item == null) continue;
                NBTTagCompound btag = new NBTTagCompound();
                item.func_77955_b(btag);
                buffer.func_74742_a((NBTBase)btag);
            }
            tag.func_74782_a(bufferName, (NBTBase)buffer);
        }
    }

    protected final void readBuffer(String bufferName, NBTTagCompound tag, ArrayList<ItemStack> outputBuffer) {
        NBTTagList buffer;
        int bufferSize;
        outputBuffer.clear();
        if (tag.func_74764_b(bufferName) && (bufferSize = (buffer = tag.func_150295_c(bufferName, 10)).func_74745_c()) > 0) {
            for (int i = 0; i < bufferSize; ++i) {
                NBTTagCompound it = buffer.func_150305_b(i);
                outputBuffer.add(ItemStack.func_77949_a((NBTTagCompound)it));
            }
        }
    }

    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        return false;
    }

    public boolean handleMessageFromClient(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        return false;
    }

    public void broadcastMessage(EntityPlayer who, NetworkFactorization.MessageType messageType, Object ... msg) {
        Core.network.broadcastMessage(who, this.getCoord(), messageType, msg);
    }

    public void broadcastMessage(EntityPlayer who, FMLProxyPacket toSend) {
        Core.network.broadcastPacket(who, this.getCoord(), toSend);
    }

    public void func_145843_s() {
        if (this instanceof IChargeConductor) {
            IChargeConductor me = (IChargeConductor)((Object)this);
            me.getCharge().invalidate();
        }
        super.func_145843_s();
    }

    public boolean rotate(ForgeDirection axis) {
        return false;
    }

    public ForgeDirection[] getValidRotations() {
        return empty_rotation_array;
    }

    public int getDynamicLight() {
        return 0;
    }

    public int getComparatorValue(ForgeDirection side) {
        if (this instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)this));
        }
        return 0;
    }

    public String toString() {
        return (Object)((Object)this.getFactoryType()) + " at " + this.getCoord();
    }

    public ItemStack getDroppedBlock() {
        return new ItemStack((Item)Core.registry.item_factorization, 1, this.getFactoryType().md);
    }

    public ItemStack getPickedBlock() {
        return this.getDroppedBlock();
    }

    public void onNeighborTileChanged(int tilex, int tiley, int tilez) {
    }

    public void representYoSelf() {
        Core.loadBus(this);
    }

    public void mappingsChanged(FMLModIdMappingEvent event) {
    }

    public void spawnDisplayTickParticles(Random rand) {
    }

    public boolean recolourBlock(ForgeDirection side, FzColor fzColor) {
        return false;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            TileEntityCommon.full_rotation_array[i] = ForgeDirection.getOrientation((int)i);
        }
    }
}

