/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.servo.RenderServoMotor;
import factorization.servo.ServoMotor;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.sockets.ISocketHolder;
import factorization.sockets.TileEntitySocketBase;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import java.io.IOException;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ReportedException;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class SocketRobotHand
extends TileEntitySocketBase {
    boolean wasPowered = false;
    boolean firstTry = false;
    EntityPlayer fakePlayer;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOCKET_ROBOTHAND;
    }

    @Override
    public FactoryType getParentFactoryType() {
        return FactoryType.SOCKET_EMPTY;
    }

    @Override
    public ItemStack getCreatingItem() {
        return Core.registry.socket_robot_hand;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.wasPowered = data.as(Share.PRIVATE, "pow").putBoolean(this.wasPowered);
        return this;
    }

    @Override
    public void genericUpdate(ISocketHolder socket, Coord coord, boolean powered) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.wasPowered || !powered) {
            this.wasPowered = powered;
            return;
        }
        this.wasPowered = true;
        this.firstTry = true;
        FzOrientation orientation = FzOrientation.fromDirection(this.facing).getSwapped();
        this.fakePlayer = null;
        this.rayTrace(socket, coord, orientation, powered, true, false);
        if (this.fakePlayer != null) {
            this.fakePlayer.field_70128_L = true;
        }
        this.fakePlayer = null;
    }

    @Override
    public boolean handleRay(ISocketHolder socket, MovingObjectPosition mop, boolean mopIsThis, boolean powered) {
        boolean ret = this.doHandleRay(socket, mop, mopIsThis, powered);
        if (!ret && !mopIsThis && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return !this.field_145850_b.func_147437_c(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        }
        return ret;
    }

    private boolean doHandleRay(ISocketHolder socket, MovingObjectPosition mop, boolean mopIsThis, boolean powered) {
        if (this.fakePlayer == null) {
            this.fakePlayer = this.getFakePlayer();
        }
        EntityPlayer player = this.fakePlayer;
        InvUtil.FzInv inv = InvUtil.openInventory(this.getBackingInventory(socket), this.facing);
        if (inv == null) {
            return this.clickWithoutInventory(player, mop);
        }
        boolean foundAny = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack is = inv.get(i);
            if (is == null || is.field_77994_a <= 0 || !inv.canExtract(i, is)) continue;
            player.field_71071_by.field_70462_a[0] = is;
            foundAny = true;
            if (!this.clickWithInventory(i, inv, player, is, mop)) continue;
            return true;
        }
        if (!foundAny) {
            return this.clickWithoutInventory(player, mop);
        }
        return false;
    }

    private boolean clickWithoutInventory(EntityPlayer player, MovingObjectPosition mop) {
        return this.clickItem(player, null, mop);
    }

    boolean clickWithInventory(int i, InvUtil.FzInv inv, EntityPlayer player, ItemStack is, MovingObjectPosition mop) {
        ItemStack orig = is == null ? null : is.func_77946_l();
        boolean result = this.clickItem(player, is, mop);
        this.firstTry = false;
        int newSize = ItemUtil.getStackSize(is);
        is = player.field_71071_by.field_70462_a[0];
        if (newSize <= 0 || !ItemUtil.couldMerge(orig, is)) {
            inv.set(i, null);
            if (newSize > 0 && ((is = inv.pushInto(i, is)) == null || is.field_77994_a <= 0)) {
                player.field_71071_by.field_70462_a[0] = null;
            }
        } else {
            inv.set(i, is);
            player.field_71071_by.field_70462_a[0] = null;
        }
        Coord here = null;
        for (int j = 0; j < player.field_71071_by.func_70302_i_(); ++j) {
            ItemStack toPush = player.field_71071_by.func_70301_a(j);
            ItemStack toDrop = inv.push(toPush);
            if (toDrop != null && toDrop.field_77994_a > 0) {
                if (here == null) {
                    here = this.getCoord();
                }
                here.spawnItem(toDrop);
            }
            player.field_71071_by.func_70299_a(j, null);
        }
        inv.onInvChanged();
        return result;
    }

    boolean clickItem(EntityPlayer player, ItemStack is, MovingObjectPosition mop) {
        try {
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                return this.mcClick(player, mop, is);
            }
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && player.func_70998_m(mop.field_72308_g)) {
                return true;
            }
        }
        catch (Throwable t) {
            CrashReport err = new CrashReport("clicking item", t);
            CrashReportCategory cat = err.func_85058_a("clicked item");
            cat.func_71507_a("Item", (Object)is);
            cat.func_71507_a("Mop", (Object)mop);
            throw new ReportedException(err);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean mcClick(EntityPlayer player, MovingObjectPosition mop, ItemStack itemstack) {
        world = player.field_70170_p;
        x = mop.field_72311_b;
        y = mop.field_72312_c;
        z = mop.field_72309_d;
        side = mop.field_72310_e;
        hitVec = mop.field_72307_f;
        dx = (float)hitVec.field_72450_a - (float)x;
        dy = (float)hitVec.field_72448_b - (float)y;
        dz = (float)hitVec.field_72449_c - (float)z;
        item = itemstack == null ? null : itemstack.func_77973_b();
        origItemHash = ItemUtil.getItemHash(itemstack);
        ret = false;
        if (!this.firstTry || itemstack == null) ** GOTO lbl-1000
        orig = itemstack.func_77946_l();
        if (item.onItemUseFirst(itemstack, player, world, x, y, z, side, dx, dy, dz)) {
            ret = true;
        } else if (!ItemUtil.identical(itemstack, orig)) {
            ret = true;
        } else lbl-1000:
        // 2 sources

        {
            ret = (player.func_70093_af() == false || itemstack == null || item.doesSneakBypassUse(world, x, y, z, player) != false) && (blockId = world.func_147439_a(x, y, z)) != null && blockId.func_149727_a(world, x, y, z, player, side, dx, dy, dz) != false ? true : (itemstack == null ? false : itemstack.func_77943_a(player, world, x, y, z, side, dx, dy, dz));
        }
        if (itemstack == null) {
            return ret;
        }
        origSize = ItemUtil.getStackSize(itemstack);
        mutatedItem = itemstack.func_77957_a(world, player);
        ret = ret | mutatedItem != itemstack | origSize != ItemUtil.getStackSize(mutatedItem) | ItemUtil.identical(mutatedItem, itemstack) == false | origItemHash != ItemUtil.getItemHash(mutatedItem);
        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = mutatedItem;
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(ServoMotor motor, Tessellator tess) {
        BlockRenderHelper block = BlockRenderHelper.instance;
        float w = 0.375f;
        block.setBlockBoundsOffset(w, 0.0f, w);
        block.useTextures(BlockIcons.socket$hand, null, BlockIcons.socket$arm0, BlockIcons.socket$arm1, BlockIcons.socket$arm2, BlockIcons.socket$arm3);
        block.beginWithRotatedUVs();
        block.rotateCenter(Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite())));
        if (motor != null) {
            block.translate(0.0f, -0.125f, 0.0f);
        }
        block.renderRotated(tess, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItemOnServo(RenderServoMotor render, ServoMotor motor, ItemStack is, float partial) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.0625f, (float)0.75f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        render.renderItem(is);
        GL11.glPopMatrix();
    }
}

