/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import factorization.api.Coord;
import factorization.shared.Core;
import factorization.util.ItemUtil;
import factorization.util.PlayerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public final class CraftUtil {
    private static final ItemStack[] slots3x3 = new ItemStack[9];
    public static boolean craft_succeeded = false;
    public static ArrayList<ItemStack> emptyArrayList = new ArrayList(0);
    static ArrayList<IRecipe> recipeCache = new ArrayList();
    private static int cache_fear = 10;
    private static IRecipe stupid_hacky_vanilla_item_repair_recipe = new IRecipe(){
        ItemStack firstItem;
        ItemStack secondItem;
        ItemStack result;

        void update(IInventory par1InventoryCrafting) {
            this.result = null;
            this.secondItem = null;
            this.firstItem = null;
            int i = 0;
            for (int j = 0; j < par1InventoryCrafting.func_70302_i_(); ++j) {
                ItemStack itemstack2 = par1InventoryCrafting.func_70301_a(j);
                if (itemstack2 == null) continue;
                if (i == 0) {
                    this.firstItem = itemstack2;
                }
                if (i == 1) {
                    this.secondItem = itemstack2;
                }
                ++i;
            }
            if (i == 2 && this.firstItem.func_77973_b() == this.secondItem.func_77973_b() && this.firstItem.field_77994_a == 1 && this.secondItem.field_77994_a == 1 && this.firstItem.func_77973_b().isRepairable()) {
                Item item = this.firstItem.func_77973_b();
                int j1 = item.func_77612_l() - this.firstItem.func_77952_i();
                int k = item.func_77612_l() - this.secondItem.func_77952_i();
                int l = j1 + k + item.func_77612_l() * 5 / 100;
                int i1 = item.func_77612_l() - l;
                if (i1 < 0) {
                    i1 = 0;
                }
                this.result = new ItemStack(this.firstItem.func_77973_b(), 1, i1);
            }
        }

        public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
            this.update((IInventory)inventorycrafting);
            return this.result != null;
        }

        public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
            this.update((IInventory)inventorycrafting);
            return this.result;
        }

        public int func_77570_a() {
            return 2;
        }

        public ItemStack func_77571_b() {
            return null;
        }
    };

    public static InventoryCrafting makeCraftingGrid() {
        return new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer entityplayer) {
                return false;
            }

            public void func_75130_a(IInventory iinventory) {
            }
        }, 3, 3);
    }

    public static void addInventoryToArray(IInventory inv, ArrayList<ItemStack> ret) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack is = ItemUtil.normalize(inv.func_70301_a(i));
            if (is == null) continue;
            ret.add(is);
        }
    }

    static InventoryCrafting getCrafter(ItemStack ... slots) {
        InventoryCrafting craft = CraftUtil.makeCraftingGrid();
        for (int i = 0; i < 9; ++i) {
            craft.func_70299_a(i, slots[i]);
        }
        return craft;
    }

    static boolean wantSize(int size, TileEntity where, ItemStack ... slots) {
        if (slots.length != size) {
            System.out.println("Tried to craft with items.length != " + size);
            if (where != null) {
                System.out.println("At " + new Coord(where));
            }
            Thread.dumpStack();
            return true;
        }
        return false;
    }

    public static List<ItemStack> craft1x1(TileEntity where, boolean fake, ItemStack what) {
        for (int i = 0; i < slots3x3.length; ++i) {
            CraftUtil.slots3x3[i] = null;
        }
        CraftUtil.slots3x3[4] = what;
        return CraftUtil.craft3x3(where, fake, false, slots3x3);
    }

    public static List<ItemStack> craft2x2(TileEntity where, boolean fake, ItemStack ... slots) {
        if (CraftUtil.wantSize(4, where, slots)) {
            return Arrays.asList(slots);
        }
        for (int i = 0; i < slots3x3.length; ++i) {
            CraftUtil.slots3x3[i] = null;
        }
        CraftUtil.slots3x3[0] = slots[0];
        CraftUtil.slots3x3[1] = slots[1];
        CraftUtil.slots3x3[3] = slots[2];
        CraftUtil.slots3x3[4] = slots[3];
        return CraftUtil.craft3x3(where, fake, false, slots3x3);
    }

    public static List<ItemStack> craft3x3(TileEntity where, boolean fake, boolean leaveSlots, ItemStack ... slots) {
        craft_succeeded = false;
        if (CraftUtil.wantSize(9, where, slots)) {
            return leaveSlots ? emptyArrayList : Arrays.asList(slots);
        }
        InventoryCrafting craft = CraftUtil.getCrafter(slots);
        IRecipe recipe = CraftUtil.findMatchingRecipe(craft, where == null ? null : where.func_145831_w());
        ItemStack result = null;
        if (recipe != null) {
            result = recipe.func_77572_b(craft);
        }
        if (result == null) {
            return leaveSlots ? emptyArrayList : Arrays.asList(slots);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (fake) {
            ret.add(result);
            craft_succeeded = true;
            return ret;
        }
        Coord pos = null;
        if (where != null) {
            pos = new Coord(where);
        }
        EntityPlayer fakePlayer = PlayerUtil.makePlayer(pos, "Crafting");
        if (pos != null) {
            pos.setAsEntityLocation((Entity)fakePlayer);
        }
        InventoryCraftResult craftResult = new InventoryCraftResult();
        craftResult.func_70299_a(0, result);
        SlotCrafting slot = new SlotCrafting(fakePlayer, (IInventory)craft, (IInventory)craftResult, 0, 0, 0);
        slot.func_82870_a(fakePlayer, result);
        ret.add(result);
        if (!leaveSlots) {
            CraftUtil.addInventoryToArray((IInventory)craft, ret);
        }
        CraftUtil.addInventoryToArray((IInventory)fakePlayer.field_71071_by, ret);
        craft_succeeded = true;
        return ret;
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting inv, World world) {
        if (Core.serverStarted) {
            List craftingManagerRecipes = CraftingManager.func_77594_a().func_77592_b();
            if (--cache_fear > 0) {
                return CraftUtil.lookupRecipeUncached(inv, world);
            }
            if (craftingManagerRecipes.size() != recipeCache.size()) {
                if (cache_fear < 0) {
                    cache_fear = 10;
                    return CraftUtil.lookupRecipeUncached(inv, world);
                }
                recipeCache.clear();
                recipeCache.ensureCapacity(craftingManagerRecipes.size());
                recipeCache.addAll(craftingManagerRecipes);
                recipeCache.add(stupid_hacky_vanilla_item_repair_recipe);
            }
            for (int i = 0; i < recipeCache.size(); ++i) {
                IRecipe recipe = recipeCache.get(i);
                if (recipe == null || !recipe.func_77569_a(inv, world)) continue;
                if (i > 50) {
                    int j = i / 3;
                    IRecipe swapeh = recipeCache.get(j);
                    recipeCache.set(j, recipe);
                    recipeCache.set(i, swapeh);
                }
                return recipe;
            }
        } else {
            return CraftUtil.lookupRecipeUncached(inv, world);
        }
        return null;
    }

    public static IRecipe lookupRecipeUncached(InventoryCrafting inv, World world) {
        List craftingManagerRecipes = CraftingManager.func_77594_a().func_77592_b();
        for (int i = 0; i < craftingManagerRecipes.size(); ++i) {
            IRecipe recipe = (IRecipe)craftingManagerRecipes.get(i);
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe;
        }
        return null;
    }

    public static IRecipe createShapedRecipe(ItemStack result, Object ... args) {
        String var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (args[var4] instanceof String[]) {
            String[] var7 = (String[])args[var4++];
            for (int var8 = 0; var8 < var7.length; ++var8) {
                String var9 = var7[var8];
                ++var6;
                var5 = var9.length();
                var3 = var3 + var9;
            }
        } else {
            while (args[var4] instanceof String) {
                String var11 = (String)args[var4++];
                ++var6;
                var5 = var11.length();
                var3 = var3 + var11;
            }
        }
        HashMap<Character, ItemStack> var12 = new HashMap<Character, ItemStack>();
        while (var4 < args.length) {
            Character var13 = (Character)args[var4];
            ItemStack var14 = null;
            if (args[var4 + 1] instanceof Item) {
                var14 = new ItemStack((Item)args[var4 + 1]);
            } else if (args[var4 + 1] instanceof Block) {
                var14 = new ItemStack((Block)args[var4 + 1], 1, -1);
            } else if (args[var4 + 1] instanceof ItemStack) {
                var14 = (ItemStack)args[var4 + 1];
            }
            var12.put(var13, var14);
            var4 += 2;
        }
        ItemStack[] var15 = new ItemStack[var5 * var6];
        for (int var16 = 0; var16 < var5 * var6; ++var16) {
            char var10 = var3.charAt(var16);
            var15[var16] = var12.containsKey(Character.valueOf(var10)) ? ((ItemStack)var12.get(Character.valueOf(var10))).func_77946_l() : null;
        }
        return new ShapedRecipes(var5, var6, var15, result);
    }

    public static IRecipe createShapelessRecipe(ItemStack result, Object ... args) {
        ArrayList<ItemStack> var3 = new ArrayList<ItemStack>();
        for (Object var7 : args) {
            if (var7 instanceof ItemStack) {
                var3.add(((ItemStack)var7).func_77946_l());
                continue;
            }
            if (var7 instanceof Item) {
                var3.add(new ItemStack((Item)var7));
                continue;
            }
            if (!(var7 instanceof Block)) {
                throw new RuntimeException("Invalid shapeless recipy!");
            }
            var3.add(new ItemStack((Block)var7));
        }
        return new ShapelessRecipes(result, var3);
    }
}

