/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import factorization.api.Coord;
import factorization.shared.TileEntityCommon;
import factorization.util.ItemUtil;
import factorization.util.NumUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class InvUtil {
    public static void givePlayerItem(EntityPlayer player, ItemStack is) {
        FzInv inv = InvUtil.openInventory((IInventory)player.field_71071_by, ForgeDirection.UP);
        ItemStack drop = inv.push(is);
        if (drop != null) {
            player.func_71019_a(drop, false);
        }
        player.field_71070_bA.func_75142_b();
    }

    public static ItemStack transferSlotToSlots(EntityPlayer player, Slot clickSlot, Iterable<Slot> destinations) {
        ItemStack got = InvUtil.tryTransferSlotToSlots(player, clickSlot, destinations);
        if (got != null) {
            clickSlot.func_75215_d(got);
        }
        return null;
    }

    public static ItemStack tryTransferSlotToSlots(EntityPlayer player, Slot clickSlot, Iterable<Slot> destinations) {
        ItemStack clickStack = ItemUtil.normalize(clickSlot.func_75211_c());
        if (clickStack == null) {
            return null;
        }
        clickSlot.func_82870_a(player, clickStack);
        for (Slot slot : destinations) {
            int freeSpace;
            ItemStack is = ItemUtil.normalize(slot.func_75211_c());
            if (is == null || !ItemUtil.couldMerge(is, clickStack) || (freeSpace = Math.min(is.func_77976_d() - is.field_77994_a, slot.func_75219_a() - is.field_77994_a)) <= 0 || !slot.func_75214_a(clickStack)) continue;
            int delta = Math.min(freeSpace, clickStack.field_77994_a);
            is.field_77994_a += delta;
            slot.func_75215_d(is);
            clickStack.field_77994_a -= delta;
            if (clickStack.field_77994_a > 0) continue;
            clickSlot.func_75215_d(null);
            return null;
        }
        for (Slot slot : destinations) {
            if (slot.func_75216_d() || !slot.func_75214_a(clickStack)) continue;
            int freeSpace = Math.min(slot.func_75219_a(), clickStack.func_77976_d());
            int delta = Math.min(freeSpace, clickStack.field_77994_a);
            ItemStack toPut = clickStack.func_77946_l();
            toPut.field_77994_a = delta;
            slot.func_75215_d(toPut);
            clickStack.field_77994_a -= delta;
            if ((clickStack = ItemUtil.normalize(clickStack)) != null) continue;
            clickSlot.func_75215_d(null);
            return null;
        }
        return ItemUtil.normalize(clickStack);
    }

    public static FzInv openInventory(IInventory orig_inv, ForgeDirection side) {
        return InvUtil.openInventory(orig_inv, side.ordinal(), true);
    }

    public static FzInv openInventory(IInventory orig_inv, ForgeDirection side, boolean openBothChests) {
        return InvUtil.openInventory(orig_inv, side.ordinal(), openBothChests);
    }

    public static FzInv openInventory(IInventory orig_inv, int side) {
        return InvUtil.openInventory(orig_inv, side, true);
    }

    public static FzInv openInventory(IInventory orig_inv, final int side, boolean openBothChests) {
        if (orig_inv == null) {
            return null;
        }
        if (orig_inv instanceof TileEntityChest && (orig_inv = InvUtil.openDoubleChest((TileEntityChest)orig_inv, openBothChests)) == null) {
            return null;
        }
        if (orig_inv instanceof ISidedInventory) {
            final ISidedInventory inv = (ISidedInventory)orig_inv;
            int[] _ = inv.func_94128_d(side);
            if (_ == null) {
                _ = new int[]{};
            }
            final int[] slotMap = _;
            return new FzInv((IInventory)inv){

                @Override
                int slotIndex(int i) {
                    return slotMap[i];
                }

                @Override
                public int size() {
                    return slotMap.length;
                }

                @Override
                public boolean canExtract(int slot, ItemStack is) {
                    if (is == null) {
                        return false;
                    }
                    return inv.func_102008_b(slotMap[slot], is, side);
                }

                @Override
                public boolean canInsert(int i, ItemStack is) {
                    if (this.forceInsert) {
                        return true;
                    }
                    return super.canInsert(i, is) && inv.func_102007_a(this.slotIndex(i), is, side);
                }
            };
        }
        return new PlainInvWrapper(orig_inv);
    }

    public static FzInv openInventory(Entity ent, boolean access_players) {
        if (ent instanceof EntityPlayer && !access_players) {
            return null;
        }
        if (ent instanceof IInventory) {
            return InvUtil.openInventory((IInventory)ent, ForgeDirection.UP);
        }
        if (ent instanceof EntityPlayer) {
            InventoryPlayer ip = ((EntityPlayer)ent).field_71071_by;
            return InvUtil.openInventory((IInventory)ip, ForgeDirection.UP).slice(0, ip.field_70462_a.length);
        }
        return null;
    }

    public static boolean canAccessSlot(IInventory inv, int slot) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory isi = (ISidedInventory)inv;
            for (int i = 0; i < 6; ++i) {
                int[] slots = isi.func_94128_d(i);
                for (int j = 0; j < slots.length; ++j) {
                    if (slots[j] != slot) continue;
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public static IInventory openDoubleChest(TileEntityChest chest, boolean openBothSides) {
        TileEntityChest origChest = chest;
        World world = chest.func_145831_w();
        int i = chest.field_145851_c;
        int j = chest.field_145848_d;
        int k = chest.field_145849_e;
        Block cb = chest.func_145838_q();
        if (cb == null) {
            return null;
        }
        BlockChest chestBlock = Blocks.field_150486_ae;
        if (world.func_147439_a(i - 1, j, k) == chestBlock) {
            return new InventoryLargeChest(origChest.func_145825_b(), (IInventory)((TileEntityChest)world.func_147438_o(i - 1, j, k)), (IInventory)origChest);
        }
        if (world.func_147439_a(i, j, k - 1) == chestBlock) {
            return new InventoryLargeChest(origChest.func_145825_b(), (IInventory)((TileEntityChest)world.func_147438_o(i, j, k - 1)), (IInventory)origChest);
        }
        if (world.func_147439_a(i + 1, j, k) == chestBlock) {
            if (openBothSides) {
                return new InventoryLargeChest(origChest.func_145825_b(), (IInventory)origChest, (IInventory)((TileEntityChest)world.func_147438_o(i + 1, j, k)));
            }
            return null;
        }
        if (world.func_147439_a(i, j, k + 1) == chestBlock) {
            if (openBothSides) {
                return new InventoryLargeChest(origChest.func_145825_b(), (IInventory)origChest, (IInventory)((TileEntityChest)world.func_147438_o(i, j, k + 1)));
            }
            return null;
        }
        return chest;
    }

    public static IInventory openDoubleChest(IInventory inv, boolean openBothSides) {
        if (inv instanceof TileEntityChest) {
            return InvUtil.openDoubleChest((TileEntityChest)inv, openBothSides);
        }
        return inv;
    }

    public static void collapseItemList(List<ItemStack> total) {
        int i = 0;
        while (i < total.size()) {
            ItemStack is = ItemUtil.normalize(total.get(i));
            if (is == null) {
                total.remove(i);
                continue;
            }
            int s = i + 1;
            while (s < total.size()) {
                ItemStack other = ItemUtil.normalize(total.get(s));
                if (other == null) {
                    total.remove(s);
                    continue;
                }
                if (ItemUtil.couldMerge(is, other)) {
                    int free = is.func_77976_d() - is.field_77994_a;
                    if (free <= 0) break;
                    int delta = Math.min(free, other.field_77994_a);
                    is.field_77994_a += delta;
                    other.field_77994_a -= delta;
                    if (other.field_77994_a <= 0) {
                        total.remove(s);
                        continue;
                    }
                }
                ++s;
            }
            ++i;
        }
    }

    public static boolean emptyBuffer(EntityPlayer entityplayer, List<ItemStack> buffer, TileEntityCommon te) {
        if (buffer.isEmpty()) {
            return false;
        }
        ItemStack is = buffer.remove(0);
        new Coord(te).spawnItem(is).func_70100_b_(entityplayer);
        te.func_70296_d();
        return true;
    }

    public static EntityItem spawnItemStack(Coord c, ItemStack item) {
        if (item == null) {
            return null;
        }
        EntityItem entityitem = new EntityItem(c.w, (double)c.x + 0.5, (double)c.y + 0.5, (double)c.z + 0.5, item);
        entityitem.field_70181_x = 0.2 + NumUtil.rand.nextGaussian() * 0.02;
        entityitem.field_70159_w = NumUtil.rand.nextGaussian() * 0.02;
        entityitem.field_70179_y = NumUtil.rand.nextGaussian() * 0.02;
        c.w.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public static EntityItem spawnItemStack(Entity c, ItemStack item) {
        if (item == null) {
            return null;
        }
        EntityItem entityitem = new EntityItem(c.field_70170_p, c.field_70165_t + (double)(c.field_70130_N / 2.0f), c.field_70163_u + (double)(c.field_70131_O / 2.0f), c.field_70161_v + (double)(c.field_70130_N / 2.0f), item);
        entityitem.field_70181_x = 0.2 + NumUtil.rand.nextGaussian() * 0.02;
        entityitem.field_70159_w = NumUtil.rand.nextGaussian() * 0.02;
        entityitem.field_70179_y = NumUtil.rand.nextGaussian() * 0.02;
        c.field_70170_p.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public static class Container2IInventory
    implements IInventory {
        Container cont;

        public Container2IInventory(Container cont) {
            this.cont = cont;
        }

        public int func_70302_i_() {
            return this.cont.func_75138_a().size();
        }

        public ItemStack func_70301_a(int i) {
            return this.cont.func_75139_a(i).func_75211_c();
        }

        public ItemStack func_70298_a(int i, int j) {
            return this.cont.func_75139_a(i).func_75209_a(j);
        }

        public ItemStack func_70304_b(int i) {
            return null;
        }

        public void func_70299_a(int i, ItemStack itemstack) {
            this.cont.func_75141_a(i, itemstack);
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return this.cont.func_75139_a(i).func_75214_a(itemstack);
        }

        public String func_145825_b() {
            return "Container2IInventory wrapper";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer entityplayer) {
            return false;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }
    }

    public static class PlainInvWrapper
    extends FzInv {
        final int length;

        public PlainInvWrapper(IInventory inv) {
            super(inv);
            this.length = inv.func_70302_i_();
        }

        @Override
        int slotIndex(int i) {
            return i;
        }

        @Override
        public int size() {
            return this.length;
        }
    }

    public static class SubsetInv
    extends FzInv {
        final FzInv ui;
        int start;
        int end;

        public SubsetInv(FzInv ui, int start, int end) {
            super(ui.under);
            this.ui = ui;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        int slotIndex(int i) {
            return this.ui.slotIndex(this.start + i);
        }
    }

    public static abstract class FzInv {
        boolean forceInsert = false;
        boolean callInvChanged = true;
        public final IInventory under;

        public abstract int size();

        abstract int slotIndex(int var1);

        public FzInv(IInventory inv) {
            this.under = inv;
        }

        public void setInsertForce(boolean b) {
            this.forceInsert = b;
        }

        public void setCallOnInventoryChanged(boolean b) {
            this.callInvChanged = b;
        }

        public void onInvChanged() {
            if (this.callInvChanged) {
                this.under.func_70296_d();
            }
        }

        public ItemStack get(int i) {
            return this.under.func_70301_a(this.slotIndex(i));
        }

        public void set(int i, ItemStack is) {
            this.under.func_70299_a(this.slotIndex(i), is);
        }

        public int getFreeSpace(int i) {
            ItemStack dest = this.get(i);
            if (dest == null) {
                return this.under.func_70297_j_();
            }
            int ret = Math.min(this.under.func_70297_j_(), dest.func_77976_d()) - dest.field_77994_a;
            return Math.max(0, ret);
        }

        public int getFreeSpaceFor(ItemStack target, int maxNeeded) {
            int space = 0;
            int spaceInEmpty = Math.min(target.func_77976_d(), this.under.func_70297_j_());
            for (int i = 0; i < this.size(); ++i) {
                if (!this.canInsert(i, target)) continue;
                ItemStack is = this.get(i);
                if (is == null) {
                    space += spaceInEmpty;
                } else {
                    if (!ItemUtil.couldMerge(target, is)) continue;
                    space += spaceInEmpty - is.field_77994_a;
                }
                if (space < maxNeeded) continue;
                return space;
            }
            return space;
        }

        public boolean canPush(ItemStack is) {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack here = this.get(i);
                if (this.get(i) == null) {
                    return true;
                }
                if (!ItemUtil.couldMerge(here, is)) continue;
                return true;
            }
            return false;
        }

        public ItemStack pushInto(int i, ItemStack is) {
            int slotIndex = this.slotIndex(i);
            if (!this.canInsert(i, is)) {
                return is;
            }
            ItemStack dest = this.under.func_70301_a(slotIndex);
            if (dest == null) {
                ItemStack toPut = is;
                int stack_limit = this.under.func_70297_j_();
                if (toPut.field_77994_a > stack_limit) {
                    toPut = is.func_77979_a(stack_limit);
                } else {
                    is = null;
                }
                this.under.func_70299_a(slotIndex, toPut);
                this.onInvChanged();
                return is;
            }
            if (!ItemUtil.couldMerge(dest, is)) {
                return is;
            }
            int dest_free = this.getFreeSpace(i);
            if (dest_free < 1) {
                return is;
            }
            int delta = Math.min(dest_free, is.field_77994_a);
            dest.field_77994_a += delta;
            is.field_77994_a -= delta;
            this.under.func_70299_a(slotIndex, dest);
            this.onInvChanged();
            return ItemUtil.normalize(is);
        }

        public boolean canExtract(int slot, ItemStack is) {
            return true;
        }

        public boolean canInsert(int i, ItemStack is) {
            if (this.forceInsert) {
                return true;
            }
            return this.under.func_94041_b(this.slotIndex(i), is) && ItemUtil.couldMerge(this.get(i), is);
        }

        public boolean isEmpty() {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == null) continue;
                return false;
            }
            return true;
        }

        public boolean transfer(FzInv dest_inv, int max_transfer, ItemStack exclude) {
            for (int i = 0; i < this.size(); ++i) {
                int orig_size;
                ItemStack is = ItemUtil.normalize(this.get(i));
                if (is == null || is == exclude || !this.canExtract(i, is)) continue;
                if (is.field_77994_a <= max_transfer) {
                    int orig_size2 = is.field_77994_a;
                    if (orig_size2 == ItemUtil.getStackSize(is = dest_inv.push(is))) continue;
                    this.set(i, is);
                    this.onInvChanged();
                    return true;
                }
                ItemStack to_push = is.func_77946_l();
                to_push.field_77994_a = orig_size = Math.min(to_push.field_77994_a, max_transfer);
                int taken = orig_size - ItemUtil.getStackSize(to_push = dest_inv.push(to_push));
                if (taken <= 0) continue;
                is.field_77994_a -= taken;
                is = ItemUtil.normalize(is);
                this.set(i, is);
                this.onInvChanged();
                return true;
            }
            return false;
        }

        public int transfer(int i, FzInv dest_inv, int dest_i, int max_transfer) {
            ItemStack src = ItemUtil.normalize(this.get(i));
            if (src == null) {
                return 0;
            }
            if (!this.canExtract(i, src)) {
                return 0;
            }
            ItemStack dest = dest_inv.get(dest_i);
            if (dest == null) {
                dest = src.func_77946_l();
                dest.field_77994_a = 0;
            } else if (!ItemUtil.couldMerge(src, dest)) {
                return 0;
            }
            if (!dest_inv.canInsert(dest_i, src)) {
                return 0;
            }
            int dest_free = dest_inv.getFreeSpace(dest_i);
            if (dest_free < 1) {
                return 0;
            }
            int delta = Math.min(dest_free, src.field_77994_a);
            delta = Math.min(max_transfer, delta);
            dest.field_77994_a += delta;
            src.field_77994_a -= delta;
            src = ItemUtil.normalize(src);
            dest_inv.set(dest_i, dest);
            this.set(i, src);
            if (this.callInvChanged) {
                dest_inv.under.func_70296_d();
                this.under.func_70296_d();
            }
            return delta;
        }

        public ItemStack push(ItemStack is) {
            ItemStack dest;
            int i;
            is = ItemUtil.normalize(is);
            for (i = 0; i < this.size(); ++i) {
                if (is == null) {
                    return null;
                }
                dest = this.get(i);
                if (dest == null) continue;
                is = ItemUtil.normalize(this.pushInto(i, is));
            }
            for (i = 0; i < this.size(); ++i) {
                if (is == null) {
                    return null;
                }
                dest = this.get(i);
                if (dest != null) continue;
                is = ItemUtil.normalize(this.pushInto(i, is));
            }
            return is;
        }

        public ItemStack peek() {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack is = ItemUtil.normalize(this.get(i));
                if (is == null) continue;
                return is;
            }
            return null;
        }

        public ItemStack pull() {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack ret = this.pull(i, 64);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }

        public ItemStack pullFromSlot(int slot) {
            return this.pull(slot, 64);
        }

        public ItemStack pullWithLimit(int limit) {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack ret = this.pull(i, limit);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }

        public ItemStack pull(int slot, int limit) {
            int i = this.slotIndex(slot);
            ItemStack is = this.under.func_70301_a(i);
            if (ItemUtil.normalize(is) == null) {
                return null;
            }
            if (!this.canExtract(slot, is)) {
                return null;
            }
            return this.under.func_70298_a(i, limit);
        }

        public ItemStack pull(ItemStack toMatch, int limit, boolean strict) {
            ItemStack ret = null;
            for (int i = 0; i < this.size(); ++i) {
                ItemStack pulled;
                ItemStack is = this.get(i);
                if ((!strict ? !ItemUtil.wildcardSimilar(toMatch, is) : !ItemUtil.couldMerge(toMatch, is)) || (pulled = ItemUtil.normalize(this.pull(i, limit))) == null) continue;
                limit -= pulled.field_77994_a;
                if (ret == null) {
                    ret = pulled;
                } else {
                    ret.field_77994_a += pulled.field_77994_a;
                }
                if (limit <= 0) break;
            }
            return ret;
        }

        private int slice_index(int i) {
            int size = this.size();
            while (i < 0 && size > 0) {
                i += size;
            }
            return i;
        }

        public FzInv slice(int start, int end) {
            start = this.slice_index(start);
            end = this.slice_index(end);
            start = Math.max(start, 0);
            if ((end = Math.min(end, this.size())) < start) {
                end = start;
            }
            if (start > end) {
                start = end;
            }
            return new SubsetInv(this, start, end);
        }
    }
}

