/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import java.util.Random;

public final class NumUtil {
    public static Random rand = new Random();
    private static ThreadLocal<Random> random_cache = new ThreadLocal();

    public static boolean significantChange(float a, float b, float threshold) {
        if (a == b) {
            return false;
        }
        if ((a == 0.0f || b == 0.0f) && (a = Math.abs(a)) + (b = Math.abs(b)) < 2.0f) {
            return true;
        }
        float thresh = Math.abs(a - b) / Math.max(a, b);
        return thresh > threshold;
    }

    public static boolean significantChange(float a, float b) {
        return NumUtil.significantChange(a, b, 0.05f);
    }

    public static float interp(float oldValue, float newValue, float partial) {
        return oldValue * (1.0f - partial) + newValue * partial;
    }

    public static double interp(double oldValue, double newValue, double partial) {
        return oldValue * (1.0 - partial) + newValue * partial;
    }

    public static float uninterp(float lowValue, float highValue, float currentValue) {
        if (currentValue < lowValue) {
            return 0.0f;
        }
        if (currentValue > highValue) {
            return 1.0f;
        }
        return (currentValue - lowValue) / (highValue - lowValue);
    }

    public static double uninterp(double lowValue, double highValue, double currentValue) {
        if (currentValue < lowValue) {
            return 0.0;
        }
        if (currentValue > highValue) {
            return 1.0;
        }
        return (currentValue - lowValue) / (highValue - lowValue);
    }

    public static double roundDown(double value, double units) {
        double scaled = value / units;
        return Math.floor(scaled) * units;
    }

    public static boolean intersect(double la, double ha, double lb, double hb) {
        return !(ha < lb) && !(hb < la);
    }

    public static Random dirtyRandomCache() {
        Random ret = random_cache.get();
        if (ret == null) {
            ret = new Random();
            random_cache.set(ret);
        }
        return ret;
    }
}

