/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import factorization.api.DeltaCoord;
import factorization.api.FzOrientation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public final class SpaceUtil {
    public static final byte GET_POINT_MIN = 0;
    public static final byte GET_POINT_MAX = 7;
    private static ThreadLocal<ArrayList<ForgeDirection>> direction_cache = new ThreadLocal();

    public static int determineOrientation(EntityPlayer player) {
        if (player.field_70125_A > 75.0f) {
            return 0;
        }
        if (player.field_70125_A <= -75.0f) {
            return 1;
        }
        return SpaceUtil.determineFlatOrientation(player);
    }

    public static int determineFlatOrientation(EntityPlayer player) {
        int var7 = MathHelper.func_76128_c((double)((double)((180.0f + player.field_70177_z) * 4.0f / 360.0f) + 0.5)) & 3;
        return var7 == 0 ? 2 : (var7 == 1 ? 5 : (var7 == 2 ? 3 : (var7 == 3 ? 4 : 0)));
    }

    public static DeltaCoord getFlatDiagonalFacing(EntityPlayer player) {
        double angle = Math.toRadians(90.0f + player.field_70177_z);
        int dx = Math.cos(angle) > 0.0 ? 1 : -1;
        int dz = Math.sin(angle) > 0.0 ? 1 : -1;
        return new DeltaCoord(dx, 0, dz);
    }

    public static byte getOpposite(int dir) {
        return (byte)ForgeDirection.getOrientation((int)dir).getOpposite().ordinal();
    }

    public static Vec3 copy(Vec3 a) {
        return Vec3.func_72443_a((double)a.field_72450_a, (double)a.field_72448_b, (double)a.field_72449_c);
    }

    public static Vec3 newVec() {
        return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }

    public static Vec3 fromEntPos(Entity ent) {
        return Vec3.func_72443_a((double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v);
    }

    public static void toEntPos(Entity ent, Vec3 pos) {
        ent.field_70165_t = pos.field_72450_a;
        ent.field_70163_u = pos.field_72448_b;
        ent.field_70161_v = pos.field_72449_c;
    }

    public static Vec3 set(Vec3 dest, Vec3 orig) {
        dest.field_72450_a = orig.field_72450_a;
        dest.field_72448_b = orig.field_72448_b;
        dest.field_72449_c = orig.field_72449_c;
        return dest;
    }

    public static void setMin(AxisAlignedBB aabb, Vec3 v) {
        aabb.field_72340_a = v.field_72450_a;
        aabb.field_72338_b = v.field_72448_b;
        aabb.field_72339_c = v.field_72449_c;
    }

    public static Vec3 getMax(AxisAlignedBB aabb) {
        return Vec3.func_72443_a((double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f);
    }

    public static Vec3 getMin(AxisAlignedBB aabb) {
        return Vec3.func_72443_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c);
    }

    public static void getMax(AxisAlignedBB box, Vec3 target) {
        target.field_72450_a = box.field_72336_d;
        target.field_72448_b = box.field_72337_e;
        target.field_72449_c = box.field_72334_f;
    }

    public static void getMin(AxisAlignedBB box, Vec3 target) {
        target.field_72450_a = box.field_72340_a;
        target.field_72448_b = box.field_72338_b;
        target.field_72449_c = box.field_72339_c;
    }

    public static void setMax(AxisAlignedBB aabb, Vec3 v) {
        aabb.field_72336_d = v.field_72450_a;
        aabb.field_72337_e = v.field_72448_b;
        aabb.field_72334_f = v.field_72449_c;
    }

    public static void setMiddle(AxisAlignedBB ab, Vec3 v) {
        v.field_72450_a = (ab.field_72340_a + ab.field_72336_d) / 2.0;
        v.field_72448_b = (ab.field_72338_b + ab.field_72337_e) / 2.0;
        v.field_72449_c = (ab.field_72339_c + ab.field_72334_f) / 2.0;
    }

    public static AxisAlignedBB newBox() {
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public static Vec3 newVec3() {
        return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }

    public static Vec3 fromDirection(ForgeDirection dir) {
        return Vec3.func_72443_a((double)dir.offsetX, (double)dir.offsetY, (double)dir.offsetZ);
    }

    public static void sort(Vec3 min, Vec3 max) {
        double big;
        if (min.field_72450_a > max.field_72450_a) {
            big = min.field_72450_a;
            min.field_72450_a = max.field_72450_a;
            max.field_72450_a = big;
        }
        if (min.field_72448_b > max.field_72448_b) {
            big = min.field_72448_b;
            min.field_72448_b = max.field_72448_b;
            max.field_72448_b = big;
        }
        if (min.field_72449_c > max.field_72449_c) {
            big = min.field_72449_c;
            min.field_72449_c = max.field_72449_c;
            max.field_72449_c = big;
        }
    }

    public static void getPoint(AxisAlignedBB box, byte pointFlags, Vec3 target) {
        boolean xSide = (pointFlags & 1) == 1;
        boolean ySide = (pointFlags & 2) == 2;
        boolean zSide = (pointFlags & 4) == 4;
        target.field_72450_a = xSide ? box.field_72340_a : box.field_72336_d;
        target.field_72448_b = ySide ? box.field_72338_b : box.field_72337_e;
        target.field_72449_c = zSide ? box.field_72339_c : box.field_72334_f;
    }

    public static double getDiagonalLength(AxisAlignedBB ab) {
        double x = ab.field_72336_d - ab.field_72340_a;
        double y = ab.field_72337_e - ab.field_72338_b;
        double z = ab.field_72334_f - ab.field_72339_c;
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static Vec3 averageVec(Vec3 a, Vec3 b) {
        return Vec3.func_72443_a((double)((a.field_72450_a + b.field_72450_a) / 2.0), (double)((a.field_72448_b + b.field_72448_b) / 2.0), (double)((a.field_72449_c + b.field_72449_c) / 2.0));
    }

    public static void assignVecFrom(Vec3 dest, Vec3 orig) {
        dest.field_72450_a = orig.field_72450_a;
        dest.field_72448_b = orig.field_72448_b;
        dest.field_72449_c = orig.field_72449_c;
    }

    public static Vec3 incrAdd(Vec3 base, Vec3 add) {
        base.field_72450_a += add.field_72450_a;
        base.field_72448_b += add.field_72448_b;
        base.field_72449_c += add.field_72449_c;
        return base;
    }

    public static Vec3 add(Vec3 a, Vec3 b) {
        Vec3 ret = Vec3.func_72443_a((double)a.field_72450_a, (double)a.field_72448_b, (double)a.field_72449_c);
        SpaceUtil.incrAdd(ret, b);
        return ret;
    }

    public static Vec3 incrSubtract(Vec3 base, Vec3 sub) {
        base.field_72450_a -= sub.field_72450_a;
        base.field_72448_b -= sub.field_72448_b;
        base.field_72449_c -= sub.field_72449_c;
        return base;
    }

    public static Vec3 subtract(Vec3 a, Vec3 b) {
        Vec3 ret = Vec3.func_72443_a((double)a.field_72450_a, (double)a.field_72448_b, (double)a.field_72449_c);
        SpaceUtil.incrSubtract(ret, b);
        return ret;
    }

    public static double getAngle(Vec3 a, Vec3 b) {
        return Math.abs(a.func_72430_b(b));
    }

    public static void setAABB(AxisAlignedBB target, Vec3 min, Vec3 max) {
        target.field_72340_a = min.field_72450_a;
        target.field_72338_b = min.field_72448_b;
        target.field_72339_c = min.field_72449_c;
        target.field_72336_d = max.field_72450_a;
        target.field_72337_e = max.field_72448_b;
        target.field_72334_f = max.field_72449_c;
    }

    public static void incrScale(Vec3 base, double s) {
        base.field_72450_a *= s;
        base.field_72448_b *= s;
        base.field_72449_c *= s;
    }

    public static Vec3 scale(Vec3 base, double s) {
        Vec3 ret = SpaceUtil.copy(base);
        SpaceUtil.incrScale(ret, s);
        return ret;
    }

    public static AxisAlignedBB createAABB(Vec3 min, Vec3 max) {
        double minX = Math.min(min.field_72450_a, max.field_72450_a);
        double minY = Math.min(min.field_72448_b, max.field_72448_b);
        double minZ = Math.min(min.field_72449_c, max.field_72449_c);
        double maxX = Math.max(min.field_72450_a, max.field_72450_a);
        double maxY = Math.max(min.field_72448_b, max.field_72448_b);
        double maxZ = Math.max(min.field_72449_c, max.field_72449_c);
        return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public static void updateAABB(AxisAlignedBB box, Vec3 min, Vec3 max) {
        box.field_72340_a = min.field_72450_a;
        box.field_72338_b = min.field_72448_b;
        box.field_72339_c = min.field_72449_c;
        box.field_72336_d = max.field_72450_a;
        box.field_72337_e = max.field_72448_b;
        box.field_72334_f = max.field_72449_c;
    }

    public static void assignBoxFrom(AxisAlignedBB dest, AxisAlignedBB orig) {
        dest.func_72328_c(orig);
    }

    public static void incrAddCoord(AxisAlignedBB box, Vec3 vec) {
        if (vec.field_72450_a < box.field_72340_a) {
            box.field_72340_a = vec.field_72450_a;
        }
        if (box.field_72336_d < vec.field_72450_a) {
            box.field_72336_d = vec.field_72450_a;
        }
        if (vec.field_72448_b < box.field_72338_b) {
            box.field_72338_b = vec.field_72448_b;
        }
        if (box.field_72337_e < vec.field_72448_b) {
            box.field_72337_e = vec.field_72448_b;
        }
        if (vec.field_72449_c < box.field_72339_c) {
            box.field_72339_c = vec.field_72449_c;
        }
        if (box.field_72334_f < vec.field_72449_c) {
            box.field_72334_f = vec.field_72449_c;
        }
    }

    public static Vec3[] getCorners(AxisAlignedBB box) {
        return new Vec3[]{Vec3.func_72443_a((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72339_c), Vec3.func_72443_a((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72339_c), Vec3.func_72443_a((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72339_c), Vec3.func_72443_a((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72339_c), Vec3.func_72443_a((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72334_f), Vec3.func_72443_a((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72334_f), Vec3.func_72443_a((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72334_f), Vec3.func_72443_a((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72334_f)};
    }

    public static ArrayList<ForgeDirection> getRandomDirections(Random rand) {
        ArrayList<Object> ret = direction_cache.get();
        if (ret == null) {
            ret = new ArrayList(6);
            for (int i = 0; i < 6; ++i) {
                ret.add(ForgeDirection.getOrientation((int)i));
            }
            direction_cache.set(ret);
        }
        Collections.shuffle(ret, rand);
        return ret;
    }

    public static int getAxis(ForgeDirection fd) {
        if (fd.offsetX != 0) {
            return 1;
        }
        if (fd.offsetY != 0) {
            return 2;
        }
        if (fd.offsetZ != 0) {
            return 3;
        }
        return 0;
    }

    public static boolean isZero(Vec3 vec) {
        return vec.field_72450_a == 0.0 && vec.field_72448_b == 0.0 && vec.field_72449_c == 0.0;
    }

    public static double lineDistance(Vec3 lineVec, Vec3 point) {
        double mag = lineVec.func_72433_c();
        Vec3 nPoint = SpaceUtil.scale(point, -1.0);
        return lineVec.func_72431_c(nPoint).func_72433_c() / mag;
    }

    public static FzOrientation getOrientation(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        FzOrientation perfect;
        double dist;
        FzOrientation perfect2;
        ForgeDirection facing = ForgeDirection.getOrientation((int)side);
        double u = 0.5;
        double v = 0.5;
        switch (facing) {
            case UNKNOWN: 
            case DOWN: {
                u = 1.0f - hitX;
                v = hitZ;
                break;
            }
            case UP: {
                u = hitX;
                v = hitZ;
                break;
            }
            case NORTH: {
                u = hitX;
                v = hitY;
                break;
            }
            case SOUTH: {
                u = 1.0f - hitX;
                v = hitY;
                break;
            }
            case WEST: {
                u = 1.0f - hitZ;
                v = hitY;
                break;
            }
            case EAST: {
                u = hitZ;
                v = hitY;
            }
        }
        double angle = Math.toDegrees(Math.atan2(v -= 0.5, u -= 0.5)) + 180.0;
        angle = (angle + 45.0) % 360.0;
        int pointy = (int)(angle / 90.0);
        pointy = (pointy + 1) % 4;
        FzOrientation fo = FzOrientation.fromDirection(facing);
        for (int X = 0; X < pointy; ++X) {
            fo = fo.getNextRotationOnFace();
        }
        if (SpaceUtil.determineOrientation(player) >= 2 && side < 2 && (perfect2 = (fo = FzOrientation.fromDirection(ForgeDirection.getOrientation((int)(side = SpaceUtil.determineOrientation(player))).getOpposite())).pointTopTo(ForgeDirection.UP)) != FzOrientation.UNKNOWN) {
            fo = perfect2;
        }
        if ((dist = Math.max(Math.abs(u), Math.abs(v))) < 0.33 && (perfect = fo.pointTopTo(ForgeDirection.UP)) != FzOrientation.UNKNOWN) {
            fo = perfect;
        }
        return fo;
    }
}

