/*
 * Decompiled with CFR 0.152.
 */
package factorization.aabbdebug;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import factorization.shared.Core;
import factorization.util.SpaceUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public enum AabbDebugger {
    INSTANCE;

    static ArrayList<AxisAlignedBB> boxes;
    static ArrayList<AxisAlignedBB> frozen;
    static ArrayList<Line> lines;
    static ArrayList<Line> frozen_lines;
    static boolean freeze;

    private AabbDebugger() {
        Core.loadBus((Object)this);
        ClientCommandHandler.instance.func_71560_a(new ICommand(){

            public int compareTo(ICommand other) {
                return this.func_71517_b().compareTo(other.func_71517_b());
            }

            public int compareTo(Object obj) {
                return this.compareTo((ICommand)obj);
            }

            public String func_71517_b() {
                return "boxdbg";
            }

            public String func_71518_a(ICommandSender p_71518_1_) {
                return "/bxdbg freeze|thaw";
            }

            public List func_71514_a() {
                return null;
            }

            public void func_71515_b(ICommandSender player, String[] args) {
                if (args[0].equals("freeze")) {
                    freeze = true;
                } else if (args[0].equals("thaw")) {
                    frozen.clear();
                    frozen_lines.clear();
                }
            }

            public boolean func_71519_b(ICommandSender p_71519_1_) {
                return true;
            }

            public List func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
                return null;
            }

            public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
                return false;
            }
        });
    }

    public static void addBox(AxisAlignedBB box) {
        if (box == null) {
            return;
        }
        boxes.add(box.func_72329_c());
    }

    public static void addLine(Vec3 start, Vec3 end) {
        Line line = new Line();
        line.start = SpaceUtil.copy(start);
        line.end = SpaceUtil.copy(end);
        lines.add(line);
    }

    @SubscribeEvent
    public void clearBox(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (freeze) {
                if (!boxes.isEmpty() || !lines.isEmpty()) {
                    freeze = false;
                }
                frozen.addAll(boxes);
                frozen_lines.addAll(lines);
            }
            boxes.clear();
            lines.clear();
        }
    }

    boolean hasBoxes() {
        return !frozen.isEmpty() || !boxes.isEmpty() || !lines.isEmpty() || !frozen_lines.isEmpty();
    }

    @SubscribeEvent
    public void drawBoxes(RenderWorldLastEvent event) {
        if (!this.hasBoxes()) {
            return;
        }
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return;
        }
        EntityLivingBase camera = Minecraft.func_71410_x().field_71451_h;
        double cx = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)event.partialTicks;
        double cy = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)event.partialTicks;
        double cz = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)event.partialTicks;
        GL11.glPushAttrib((int)24576);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-cx), (double)(-cy), (double)(-cz));
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)1.0f);
        for (AxisAlignedBB box : boxes) {
            RenderGlobal.func_147590_a((AxisAlignedBB)box, (int)0x800000);
        }
        for (AxisAlignedBB box : frozen) {
            RenderGlobal.func_147590_a((AxisAlignedBB)box, (int)0x4040B0);
        }
        GL11.glLineWidth((float)2.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)1);
        for (Line line : lines) {
            GL11.glVertex3d((double)line.start.field_72450_a, (double)line.start.field_72448_b, (double)line.start.field_72449_c);
            GL11.glVertex3d((double)line.end.field_72450_a, (double)line.end.field_72448_b, (double)line.end.field_72449_c);
        }
        GL11.glEnd();
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)1);
        for (Line line : frozen_lines) {
            GL11.glVertex3d((double)line.start.field_72450_a, (double)line.start.field_72448_b, (double)line.start.field_72449_c);
            GL11.glVertex3d((double)line.end.field_72450_a, (double)line.end.field_72448_b, (double)line.end.field_72449_c);
        }
        GL11.glEnd();
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    static {
        boxes = new ArrayList();
        frozen = new ArrayList();
        lines = new ArrayList();
        frozen_lines = new ArrayList();
        freeze = false;
    }

    private static class Line {
        Vec3 start;
        Vec3 end;

        private Line() {
        }
    }
}

