/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import com.google.common.base.Splitter;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class DeltaCoord
implements IDataSerializable {
    public int x;
    public int y;
    public int z;
    public static final DeltaCoord ZERO = new DeltaCoord();
    public static DeltaCoord[] directNeighbors = new DeltaCoord[]{DeltaCoord.d(1, 0, 0), DeltaCoord.d(-1, 0, 0), DeltaCoord.d(0, -1, 0), DeltaCoord.d(0, 1, 0), DeltaCoord.d(0, 0, -1), DeltaCoord.d(0, 0, 1)};
    public static DeltaCoord[] planeNeighbors = new DeltaCoord[]{DeltaCoord.d(1, 0, 0), DeltaCoord.d(-1, 0, 0), DeltaCoord.d(0, 0, -1), DeltaCoord.d(0, 0, 1)};
    private static Splitter COMMA_SPLITTER = Splitter.on((char)',');

    public DeltaCoord() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public DeltaCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public DeltaCoord add(DeltaCoord o) {
        return new DeltaCoord(this.x + o.x, this.y + o.y, this.z + o.z);
    }

    public DeltaCoord scale(double d) {
        return new DeltaCoord((int)((double)this.x * d), (int)((double)this.y * d), (int)((double)this.z * d));
    }

    public boolean isZero() {
        return this.x == 0 && this.y == 0 && this.z == 0;
    }

    public String toString() {
        return "DeltaCoord(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    private static DeltaCoord d(int x, int y, int z) {
        return new DeltaCoord(x, y, z);
    }

    public double getAngleHorizontal() {
        return Math.atan2(this.z, -this.x);
    }

    public ForgeDirection getDirection() {
        ForgeDirection[] values = ForgeDirection.VALID_DIRECTIONS;
        for (int i = 0; i < values.length; ++i) {
            ForgeDirection d = values[i];
            if (d.offsetX != this.x || d.offsetY != this.y || d.offsetZ != this.z) continue;
            return d;
        }
        return ForgeDirection.UNKNOWN;
    }

    public int getFaceSide() {
        if (this.x == 0 && this.z == 0) {
            if (this.y == -1) {
                return 0;
            }
            if (this.y == 1) {
                return 1;
            }
        } else if (this.y == 0 && this.x == 0) {
            if (this.z == -1) {
                return 2;
            }
            if (this.z == 1) {
                return 3;
            }
        } else if (this.y == 0 && this.z == 0) {
            if (this.x == -1) {
                return 4;
            }
            if (this.x == 1) {
                return 5;
            }
        }
        return -1;
    }

    public DeltaCoord reverse() {
        return new DeltaCoord(-this.x, -this.y, -this.z);
    }

    public boolean isSubmissive() {
        return this.x < 0 || this.y < 0 || this.z < 0;
    }

    public boolean equals(DeltaCoord o) {
        return this.x == o.x && this.y == o.y && this.z == o.z;
    }

    public void alignToAxis() {
        int ax = Math.abs(this.x);
        int ay = Math.abs(this.y);
        int az = Math.abs(this.z);
        if (ax >= ay && ax >= az) {
            this.x = (int)Math.signum(this.x);
            return;
        }
        if (ay >= ax && ay >= az) {
            this.y = (int)Math.signum(this.y);
            return;
        }
        if (az >= ay && az >= ax) {
            this.z = (int)Math.signum(this.z);
            return;
        }
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public int get(int id) {
        switch (id) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new RuntimeException("not an dimension index");
    }

    public void set(int id, int val) {
        switch (id) {
            case 0: {
                this.x = val;
                break;
            }
            case 1: {
                this.y = val;
                break;
            }
            case 2: {
                this.z = val;
                break;
            }
            default: {
                throw new RuntimeException("not an dimension index");
            }
        }
    }

    public void init(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void writeToTag(String prefix, NBTTagCompound tag) {
        tag.func_74768_a(prefix + "dx", this.x);
        tag.func_74768_a(prefix + "dy", this.y);
        tag.func_74768_a(prefix + "dz", this.z);
    }

    public static DeltaCoord readFromTag(String prefix, NBTTagCompound tag) {
        return new DeltaCoord(tag.func_74762_e(prefix + "dx"), tag.func_74762_e(prefix + "dy"), tag.func_74762_e(prefix + "dz"));
    }

    public static DeltaCoord read(ByteBuf di) throws IOException {
        return new DeltaCoord(di.readInt(), di.readInt(), di.readInt());
    }

    public void write(ByteBuf out) throws IOException {
        for (int i = 0; i < 3; ++i) {
            out.writeInt(this.get(i));
        }
    }

    public static DeltaCoord parse(String input) {
        DeltaCoord ret = new DeltaCoord();
        int i = 0;
        for (String s : COMMA_SPLITTER.split((CharSequence)input)) {
            ret.set(i, Integer.parseInt(s));
            ++i;
        }
        return ret;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.x = data.asSameShare(prefix + "dx").put(this.x);
        this.y = data.asSameShare(prefix + "dy").put(this.y);
        this.z = data.asSameShare(prefix + "dz").put(this.z);
        return this;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }
}

