/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;

public class DataInByteBuf
extends DataHelper {
    private final ByteBuf dis;
    private final Side side;

    public DataInByteBuf(ByteBuf dis, Side side) {
        this.dis = dis;
        this.side = side;
    }

    @Override
    protected boolean shouldStore(Share share) {
        return share.is_public;
    }

    @Override
    public boolean isReader() {
        return true;
    }

    @Override
    protected <E> E putImplementation(E o) throws IOException {
        if (o instanceof Boolean) {
            return (E)Boolean.valueOf(this.dis.readBoolean());
        }
        if (o instanceof Byte) {
            return (E)Byte.valueOf(this.dis.readByte());
        }
        if (o instanceof Short) {
            return (E)Short.valueOf(this.dis.readShort());
        }
        if (o instanceof Integer) {
            return (E)Integer.valueOf(this.dis.readInt());
        }
        if (o instanceof Long) {
            return (E)Long.valueOf(this.dis.readLong());
        }
        if (o instanceof Float) {
            return (E)Float.valueOf(this.dis.readFloat());
        }
        if (o instanceof Double) {
            return (E)Double.valueOf(this.dis.readDouble());
        }
        if (o instanceof String) {
            return (E)ByteBufUtils.readUTF8String((ByteBuf)this.dis);
        }
        if (o instanceof NBTTagCompound) {
            return (E)ByteBufUtils.readTag((ByteBuf)this.dis);
        }
        return o;
    }
}

