/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;

public class DataOutByteBuf
extends DataHelper {
    private final ByteBuf dos;
    private final Side side;

    public DataOutByteBuf(ByteBuf dos, Side side) {
        this.dos = dos;
        this.side = side;
    }

    @Override
    protected boolean shouldStore(Share share) {
        return share.is_public;
    }

    @Override
    public boolean isReader() {
        return false;
    }

    @Override
    protected <E> E putImplementation(E value) throws IOException {
        if (value instanceof Boolean) {
            this.dos.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            this.dos.writeByte((int)((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.dos.writeShort((int)((Short)value).shortValue());
        } else if (value instanceof Integer) {
            this.dos.writeInt(((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.dos.writeLong(((Long)value).longValue());
        } else if (value instanceof Float) {
            this.dos.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.dos.writeDouble(((Double)value).doubleValue());
        } else if (value instanceof String) {
            ByteBufUtils.writeUTF8String((ByteBuf)this.dos, (String)((String)value));
        } else if (value instanceof NBTTagCompound) {
            ByteBufUtils.writeTag((ByteBuf)this.dos, (NBTTagCompound)((NBTTagCompound)value));
        }
        return value;
    }
}

