/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import factorization.api.datahelpers.DataHelperNBT;
import factorization.api.datahelpers.Share;
import factorization.util.ItemUtil;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DataOutNBT
extends DataHelperNBT {
    public DataOutNBT(NBTTagCompound theTag) {
        this.tag = theTag;
    }

    public DataOutNBT() {
        this(new NBTTagCompound());
    }

    @Override
    public NBTTagCompound getTag() {
        return this.tag;
    }

    @Override
    protected boolean shouldStore(Share share) {
        return !share.is_transient;
    }

    @Override
    public boolean isReader() {
        return false;
    }

    @Override
    protected <E> E putImplementation(E value) throws IOException {
        if (value instanceof Boolean) {
            this.tag.func_74757_a(this.name, ((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            this.tag.func_74774_a(this.name, ((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.tag.func_74777_a(this.name, ((Short)value).shortValue());
        } else if (value instanceof Integer) {
            this.tag.func_74768_a(this.name, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.tag.func_74772_a(this.name, ((Long)value).longValue());
        } else if (value instanceof Float) {
            this.tag.func_74776_a(this.name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.tag.func_74780_a(this.name, ((Double)value).doubleValue());
        } else if (value instanceof String) {
            this.tag.func_74778_a(this.name, (String)value);
        } else if (value instanceof NBTTagCompound) {
            this.tag.func_74782_a(this.name, (NBTBase)((NBTTagCompound)value));
        }
        return value;
    }

    @Override
    protected ArrayList<ItemStack> putItemArray_efficient(ArrayList<ItemStack> value) throws IOException {
        if (value.isEmpty()) {
            return value;
        }
        NBTTagList buffer = new NBTTagList();
        for (ItemStack item : value) {
            if (ItemUtil.normalize(item) == null) continue;
            NBTTagCompound btag = new NBTTagCompound();
            item.func_77955_b(btag);
            buffer.func_74742_a((NBTBase)btag);
        }
        this.tag.func_74782_a(this.name, (NBTBase)buffer);
        return value;
    }
}

