/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.charge.TileEntityBattery;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FactorizationBlockRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class BlockRenderBattery
extends FactorizationBlockRender {
    float item_fullness = 0.0f;

    @Override
    public boolean render(RenderBlocks rb) {
        TileEntityBattery bat;
        if (this.world_mode) {
            bat = (TileEntityBattery)this.te;
        } else {
            bat = (TileEntityBattery)FactoryType.BATTERY.getRepresentative();
            if (this.is != null && this.is.func_77942_o()) {
                bat.loadFromStack(this.is);
            }
        }
        if (bat == null) {
            return false;
        }
        this.renderBatteryDisplay(rb, bat.getFullness());
        this.renderNormalBlock(rb, FactoryType.BATTERY.md);
        return true;
    }

    void renderInventoryMode(RenderBlocks rb, IItemRenderer.ItemRenderType type) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(Core.blockAtlas);
        this.renderNormalBlock(rb, FactoryType.BATTERY.md);
        GL11.glPushMatrix();
        this.renderBatteryDisplay(rb, this.item_fullness);
        GL11.glPopMatrix();
    }

    void renderBatteryDisplay(RenderBlocks rb, float fullness) {
        fullness = Math.min(fullness, 1.0f);
        Tessellator tes = Tessellator.field_78398_a;
        float pixels = Math.round(fullness * 11.0f);
        if (pixels < 1.0f) {
            return;
        }
        float h = 0.0625f + pixels / 16.0f;
        float d = 0.0078125f;
        int brightness = this.world_mode ? Core.registry.factory_block.func_149677_c((IBlockAccess)this.getCoord().w, this.x, this.y, this.z) : 0xC000C0;
        tes.func_78380_c(brightness);
        float color = Math.min(1.0f, fullness * 0.8f + 0.2f);
        tes.func_78386_a(color, fullness, fullness);
        BlockRenderHelper block = BlockRenderHelper.instance;
        IIcon meter = BlockIcons.battery_meter;
        block.useTextures(null, null, meter, meter, meter, meter);
        block.func_149676_a(-0.0078125f, 0.0f, -0.0078125f, 1.0078125f, h, 1.0078125f);
        if (this.world_mode) {
            block.render(rb, this.x, this.y, this.z);
        } else {
            block.renderForInventory(rb);
        }
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.BATTERY;
    }
}

