/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GargantuanBlock
extends Block {
    @SideOnly(value=Side.CLIENT)
    IIcon end;
    @SideOnly(value=Side.CLIENT)
    IIcon low;
    @SideOnly(value=Side.CLIENT)
    IIcon high;
    @SideOnly(value=Side.CLIENT)
    IIcon low_f;
    @SideOnly(value=Side.CLIENT)
    IIcon high_f;
    @SideOnly(value=Side.CLIENT)
    IIcon low_fu;
    @SideOnly(value=Side.CLIENT)
    IIcon high_fu;

    public GargantuanBlock() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(field_149780_i);
    }

    public void func_149651_a(IIconRegister registry) {
        this.end = registry.func_94245_a("factorization:colossi/gargantuan_end");
        this.low = registry.func_94245_a("factorization:colossi/gargantuan_low");
        this.high = registry.func_94245_a("factorization:colossi/gargantuan_high");
        this.low_f = registry.func_94245_a("factorization:colossi/gargantuan_low_f");
        this.high_f = registry.func_94245_a("factorization:colossi/gargantuan_high_f");
        this.low_fu = new IconFlipped(this.low_f, true, false);
        this.high_fu = new IconFlipped(this.high_f, true, false);
    }

    ForgeDirection getDir(int md) {
        return ForgeDirection.getOrientation((int)md);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        Coord at = new Coord(world, x, y, z);
        int md = at.getMd();
        ForgeDirection dir = this.getDir(md);
        boolean good = false;
        if (dir != ForgeDirection.UNKNOWN) {
            Coord child = at.add(dir);
            if (child.getId() == this && this.getDir(child.getMd()) == dir.getOpposite()) {
                child.setAir();
                good = true;
            } else {
                good = dir.offsetX + dir.offsetY + dir.offsetZ > 0;
            }
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest) && good;
    }

    public IIcon func_149691_a(int side_, int md) {
        ForgeDirection side;
        ForgeDirection dir = this.getDir(md);
        if (dir == (side = ForgeDirection.getOrientation((int)side_)) || dir.getOpposite() == side) {
            return this.end;
        }
        if (dir.offsetX != 0) {
            return dir == ForgeDirection.EAST ^ side.offsetZ == -1 ? this.high : this.low;
        }
        if (dir == ForgeDirection.SOUTH) {
            if (side == ForgeDirection.DOWN) {
                return this.high_fu;
            }
            if (side == ForgeDirection.UP) {
                return this.high_fu;
            }
            if (side == ForgeDirection.EAST) {
                return this.low;
            }
            if (side == ForgeDirection.WEST) {
                return this.high;
            }
        }
        if (dir == ForgeDirection.NORTH) {
            if (side == ForgeDirection.DOWN) {
                return this.low_fu;
            }
            if (side == ForgeDirection.UP) {
                return this.low_fu;
            }
            if (side == ForgeDirection.EAST) {
                return this.high;
            }
            if (side == ForgeDirection.WEST) {
                return this.low;
            }
        }
        if (dir == ForgeDirection.DOWN) {
            return this.high_fu;
        }
        if (dir == ForgeDirection.UP) {
            return this.low_fu;
        }
        return this.end;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return super.getDrops(world, x, y, z, metadata, fortune);
    }
}

