/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.api.Coord;
import factorization.colossi.Brush;
import net.minecraftforge.common.util.ForgeDirection;

public class MaskTemplate {
    int width;
    String[] template;
    ForgeDirection anchor = ForgeDirection.UNKNOWN;
    int anchor_points = 0;
    int anchor_x;
    int anchor_y;
    int weight = 100;
    char MASK = (char)35;
    char AIR = (char)46;
    char EYE = (char)64;

    public MaskTemplate(String ... template) {
        this.template = template;
        this.width = template[0].length();
        int START = 0;
        int END = template.length - 1;
        for (int lineIndex = START; lineIndex <= END; ++lineIndex) {
            String s = template[lineIndex];
            if (s.length() != this.width) {
                throw new IllegalArgumentException("Template has inconsistent width");
            }
            for (int i = 0; i < this.width; ++i) {
                char c = s.charAt(i);
                ForgeDirection fd = this.toAnchor(c);
                if (fd == ForgeDirection.UNKNOWN) {
                    if (c == this.MASK || c == this.EYE || c == this.AIR) continue;
                    throw new IllegalArgumentException("Invalid template character: '" + c + "'");
                }
                if (this.anchor != fd) {
                    if (this.anchor != ForgeDirection.UNKNOWN) {
                        throw new IllegalArgumentException("Mixed anchor types");
                    }
                    this.anchor = fd;
                    this.anchor_x = i;
                    this.anchor_y = END - lineIndex;
                }
                ++this.anchor_points;
            }
        }
    }

    ForgeDirection toAnchor(char c) {
        switch (c) {
            case 'V': 
            case 'v': {
                return ForgeDirection.DOWN;
            }
            case '^': {
                return ForgeDirection.UP;
            }
            case '<': {
                return ForgeDirection.NORTH;
            }
            case '>': {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public String toString() {
        String ret = "weight " + this.weight;
        for (String s : this.template) {
            ret = ret + "\n" + s;
        }
        ret = ret + "\n' width " + this.width;
        ret = ret + "\n' anchor " + this.anchor;
        ret = ret + "\n' anchor_points " + this.anchor_points;
        return ret;
    }

    public void paint(Coord anchor, Brush mask, Brush eye) {
        for (int ty = 0; ty < this.template.length; ++ty) {
            for (int tz = 0; tz < this.width; ++tz) {
                char c = this.template[ty].charAt(tz);
                if (c != '@' && c != '#') continue;
                Coord here = anchor.add(0, this.template.length - ty - this.anchor_y, tz - this.anchor_x);
                if (c == '@') {
                    eye.paint(here);
                    continue;
                }
                mask.paint(here);
            }
        }
    }
}

