/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.colossi.Awakener;
import factorization.colossi.ColossusController;
import factorization.colossi.IStateMachine;
import java.io.IOException;

public class StateMachineExecutor<E extends Enum<E>>
implements IDataSerializable {
    final ColossusController controller;
    E state;
    int age = 0;
    final String machineName;

    public StateMachineExecutor(ColossusController controller, String machineName, E initialState) {
        this.controller = controller;
        this.machineName = machineName + "_";
        this.state = initialState;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.age = data.as(Share.PRIVATE, this.machineName + prefix + "_age").putInt(this.age);
        this.state = data.as(Share.PRIVATE, this.machineName + prefix + "_state").putEnum(this.state);
        return this;
    }

    public void forceState(E nextState) {
        Awakener.msg(this.machineName + nextState, new Object[0]);
        ((IStateMachine)this.state).onExitState(this.controller, nextState);
        ((IStateMachine)nextState).onEnterState(this.controller, this.state);
        this.age = 0;
        this.state = nextState;
    }

    public E getState() {
        return this.state;
    }

    void tick() {
        Object nextState;
        if ((nextState = ((IStateMachine)this.state).tick(this.controller, this.age++)) != this.state) {
            this.forceState(nextState);
        }
    }
}

