/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoordFunction;
import factorization.api.Quaternion;
import factorization.colossi.ColossusController;
import factorization.colossi.IStateMachine;
import factorization.colossi.LimbInfo;
import factorization.colossi.TechniqueKind;
import factorization.fzds.TransferLib;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.Interpolation;
import factorization.shared.Core;
import factorization.shared.ReservoirSampler;
import factorization.util.SpaceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public enum Technique implements IStateMachine<Technique>
{
    STATE_MACHINE_ENTRY{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age > 25) {
                return INITIAL_BOW;
            }
            return this;
        }
    }
    ,
    PICK_NEXT_TECHNIQUE{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.IDLER;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (controller.func_110143_aJ() <= 0.0f) {
                return DEATH_FALL;
            }
            if (age == 0) {
                Vec3 rot = controller.body.getRotation().toRotationVector();
                double err = Math.abs(rot.field_72450_a) + Math.abs(rot.field_72449_c);
                if (err > 0.01) {
                    Quaternion bodyRot = controller.body.getRotation();
                    double yRot = bodyRot.toRotationVector().field_72448_b;
                    Quaternion straightRot = Quaternion.getRotationQuaternionRadians(yRot, ForgeDirection.UP);
                    controller.bodyLimbInfo.target(straightRot, 1.0);
                    return FINISH_MOVE;
                }
            }
            boolean use_defense = controller.checkHurt(true);
            List<Technique> avail = Arrays.asList(Technique.values());
            Collections.shuffle(avail);
            Technique chosen_offense = null;
            Technique chosen_defense = null;
            boolean force_idler = this.iteratePotentialPlayers(controller) == null;
            for (Technique tech : avail) {
                TechniqueKind kind = tech.getKind();
                if (use_defense && kind != TechniqueKind.DEFENSIVE) continue;
                switch (kind) {
                    case TRANSITION: {
                        break;
                    }
                    case OFFENSIVE: {
                        chosen_offense = this.grade(chosen_offense, controller, tech);
                        if (chosen_offense == null) break;
                        return chosen_offense;
                    }
                    case DEFENSIVE: 
                    case IDLER: {
                        chosen_defense = this.grade(chosen_defense, controller, tech);
                    }
                }
            }
            if (chosen_defense != null) {
                return chosen_defense;
            }
            return STAND_STILL;
        }

        Technique grade(Technique orig, ColossusController controller, Technique next) {
            if (orig == null && next.usable(controller)) {
                return next;
            }
            return orig;
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            return player;
        }
    }
    ,
    STAND_STILL{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.IDLER;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            Quaternion bodyRot = controller.body.getRotation();
            double yRot = bodyRot.toRotationVector().field_72448_b;
            Quaternion straightRot = Quaternion.getRotationQuaternionRadians(yRot, ForgeDirection.UP);
            controller.bodyLimbInfo.target(straightRot, 1.0);
            int time = controller.bodyLimbInfo.idc.getEntity().getRemainingRotationTime();
            for (LimbInfo li : controller.limbs) {
                if (!li.type.isArmOrLeg()) continue;
                Quaternion or = li.idc.getEntity().getRotation();
                li.idc.getEntity().orderTargetRotation(or, time, Interpolation.SMOOTH3);
                li.target(new Quaternion(), 1.0);
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (HIT_WITH_LIMB.usable(controller)) {
                return HIT_WITH_LIMB;
            }
            if (age > 300 || controller.checkHurt(false)) {
                return this.finishMove(controller);
            }
            return this;
        }
    }
    ,
    FINISH_MOVE{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller);
        }
    }
    ,
    INITIAL_BOW{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            this.playNoise(controller);
            BOW.onEnterState(controller, this);
            final ReservoirSampler sampler = new ReservoirSampler(1, controller.field_70170_p.field_73012_v);
            Coord.iterateCube(controller.body.getCorner(), controller.body.getFarCorner(), new ICoordFunction(){

                @Override
                public void handle(Coord here) {
                    if (here.getBlock() != Core.registry.colossal_block) {
                        return;
                    }
                    if (here.getMd() != 0) {
                        return;
                    }
                    if (!here.add(ForgeDirection.UP).isAir()) {
                        return;
                    }
                    if (here.add(ForgeDirection.EAST).isAir()) {
                        return;
                    }
                    sampler.give(here.copy());
                }
            });
            Iterator i$ = sampler.iterator();
            if (i$.hasNext()) {
                Coord found = (Coord)i$.next();
                if (found.getMd() == 0 && found.getId() == Core.registry.colossal_block) {
                    found.setIdMd(Core.registry.colossal_block, 9, true);
                } else {
                    found.setIdMd(Core.registry.colossal_block, 1, true);
                }
                return;
            }
            controller.crackBroken();
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (controller.checkHurt(false)) {
                return INITIAL_UNBOW;
            }
            return this;
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            int count = controller.getNaturalCrackCount();
            final ReservoirSampler sampler = new ReservoirSampler(count, controller.field_70170_p.field_73012_v);
            Coord.iterateCube(controller.body.getCorner(), controller.body.getFarCorner(), new ICoordFunction(){

                @Override
                public void handle(Coord here) {
                    if (this.isExposedSkin(here)) {
                        sampler.give(here.copy());
                    }
                    if (here.getBlock() == Core.registry.colossal_block && here.getMd() == 5) {
                        here.setMd(7, true);
                    }
                }
            });
            for (Coord found : sampler) {
                found.setIdMd(Core.registry.colossal_block, 1, true);
            }
            int newCracks = sampler.size();
            int destroyed = controller.getDestroyedCracks();
            controller.setTotalCracks(newCracks + destroyed);
        }

        boolean isExposedSkin(Coord cell) {
            if (cell.getBlock() != Core.registry.colossal_block) {
                return false;
            }
            if (cell.getMd() != 4) {
                return false;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Coord n = cell.add(dir);
                if (!n.isAir() && !n.isReplacable()) continue;
                return true;
            }
            return false;
        }
    }
    ,
    BOW{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        boolean usable(ColossusController controller) {
            if ((double)controller.field_70170_p.field_73012_v.nextFloat() < 0.5) {
                return false;
            }
            return this.iteratePotentialPlayers(controller) != null;
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            if (player.field_70163_u < controller.field_70163_u) {
                return null;
            }
            double height = controller.bodyLimbInfo.length;
            if (player.field_70163_u > controller.field_70163_u + height + 5.0) {
                return null;
            }
            Coord top = controller.body.getFarCorner().copy();
            controller.body.shadow2real(top);
            if (player.field_70163_u > (double)top.y) {
                return null;
            }
            double radius = this.getTotalSize(controller) + 2.0;
            if (controller.func_70068_e((Entity)player) > radius * radius) {
                return null;
            }
            return player;
        }

        double getTotalSize(ColossusController controller) {
            int bodWidth = this.measureWidth(controller.body);
            int armWidth = this.measureWidth(controller.body);
            return (double)(bodWidth + armWidth) / 2.0;
        }

        int measureWidth(IDeltaChunk bod) {
            return bod.getFarCorner().difference((Coord)bod.getCorner()).z;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            if (prevState != INITIAL_BOW) {
                this.playNoise(controller);
            }
            double bowAngle = Math.toRadians(70.0);
            Quaternion bow = Quaternion.getRotationQuaternionRadians(bowAngle, ForgeDirection.NORTH);
            Quaternion bodyBend = controller.body.getRotation().multiply(bow);
            controller.bodyLimbInfo.target(bodyBend, 0.4, bendInterp);
            int bodyBendTime = controller.body.hasOrderedRotation() ? controller.body.getRemainingRotationTime() : 60;
            Quaternion legBend = Quaternion.getRotationQuaternionRadians(-bowAngle * 1.5, ForgeDirection.NORTH);
            for (LimbInfo limb : controller.limbs) {
                IDeltaChunk idc = limb.idc.getEntity();
                if (idc == null) continue;
                if (limb.type == ColossusController.LimbType.LEG) {
                    idc.orderTargetRotation(legBend, bodyBendTime, bendInterp);
                    continue;
                }
                if (limb.type != ColossusController.LimbType.ARM) continue;
                double armFlap = Math.toRadians(limb.side == ColossusController.BodySide.RIGHT ? -25.0 : 25.0);
                double armHang = Math.toRadians(-135.0);
                Quaternion flap = Quaternion.getRotationQuaternionRadians(armFlap, ForgeDirection.EAST);
                Quaternion hang = Quaternion.getRotationQuaternionRadians(armHang, ForgeDirection.NORTH);
                idc.orderTargetRotation(flap.multiply(hang).multiply(bow), bodyBendTime, Interpolation.SMOOTH);
            }
            controller.setTarget(null);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (controller.checkHurt(false)) {
                return UNBOW;
            }
            if (age > 300) {
                return UNBOW;
            }
            return this;
        }
    }
    ,
    INITIAL_UNBOW{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            this.playNoise(controller);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age > 100) {
                return INITIAL_UNBOW2;
            }
            return this;
        }
    }
    ,
    INITIAL_UNBOW2{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            UNBOW.onEnterState(controller, this);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return UNBOW.tick(controller, age);
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            UNBOW.onExitState(controller, nextState);
        }
    }
    ,
    UNBOW{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            double yRot;
            Quaternion straightRot;
            Quaternion bodyRot;
            if (prevState != INITIAL_UNBOW) {
                this.playNoise(controller);
            }
            if ((bodyRot = controller.body.getRotation()).dotProduct(straightRot = Quaternion.getRotationQuaternionRadians(-(yRot = bodyRot.toRotationVector().field_72448_b), ForgeDirection.UP)) < 0.0) {
                straightRot.incrConjugate();
            }
            controller.bodyLimbInfo.target(straightRot, 1.0);
            Quaternion straightenIsh = new Quaternion().slerp(bodyRot, 0.5);
            int time = controller.bodyLimbInfo.idc.getEntity().getRemainingRotationTime();
            for (LimbInfo li : controller.limbs) {
                if (!li.type.isArmOrLeg()) continue;
                li.idc.getEntity().orderTargetRotation(straightenIsh, time, Interpolation.SMOOTH);
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller);
        }
    }
    ,
    CHASE_PLAYER{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.OFFENSIVE;
        }

        @Override
        boolean usable(ColossusController controller) {
            return this.iteratePotentialPlayers(controller) != null;
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            if (!player.field_70122_E) {
                return CONTINUE;
            }
            double dx = controller.field_70165_t - player.field_70165_t;
            double dz = controller.field_70161_v - player.field_70161_v;
            double d = Math.sqrt(dx * dx + dz * dz);
            if (d < (double)(controller.leg_size + 2)) {
                return CONTINUE;
            }
            return player;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            EntityPlayer player = (EntityPlayer)this.iteratePotentialPlayers(controller);
            if (player == null) {
                return;
            }
            controller.setTarget(new Coord((Entity)player));
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (controller.atTarget()) {
                return PICK_NEXT_TECHNIQUE;
            }
            return this;
        }
    }
    ,
    SIT_DOWN{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.IDLER;
        }

        @Override
        boolean usable(ColossusController controller) {
            return this.iteratePotentialPlayers(controller) == null;
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            return player;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            double v = (double)controller.leg_length / 60.0;
            controller.body.func_70016_h(0.0, -v, 0.0);
            Quaternion legBend = Quaternion.getRotationQuaternionRadians(1.5707963267948966, ForgeDirection.SOUTH);
            for (LimbInfo limb : controller.limbs) {
                if (limb.type != ColossusController.LimbType.LEG) continue;
                limb.setTargetRotation(legBend, 60, Interpolation.SMOOTH);
            }
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            controller.body.func_70016_h(0.0, 0.0, 0.0);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age >= 60) {
                return SIT_WAIT;
            }
            return this;
        }
    }
    ,
    SIT_WAIT{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age % 60 == 0 && this.iteratePotentialPlayers(controller) != null) {
                return STAND_UP;
            }
            if (controller.checkHurt(false)) {
                return STAND_UP;
            }
            return this;
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            return player;
        }
    }
    ,
    STAND_UP{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            double v = (double)controller.leg_length / 60.0;
            controller.body.func_70016_h(0.0, v, 0.0);
            for (LimbInfo limb : controller.limbs) {
                if (!limb.type.isArmOrLeg()) continue;
                limb.setTargetRotation(new Quaternion(), 60, Interpolation.SMOOTH);
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age >= 60) {
                return PICK_NEXT_TECHNIQUE;
            }
            return this;
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            controller.body.func_70016_h(0.0, 0.0, 0.0);
        }
    }
    ,
    HIT_WITH_LIMB{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.OFFENSIVE;
        }

        @Override
        boolean usable(ColossusController controller) {
            return this.findSmashable(controller) != null;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            TargetSmash smash = this.findSmashable(controller);
            if (smash == null) {
                return;
            }
            smash.limb.causesPain(true);
            smash.limb.target(smash.rotation, 8.0, Interpolation.CUBIC);
            this.playNoise(controller);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller, FINISH_HIT);
        }

        TargetSmash findSmashable(ColossusController controller) {
            return (TargetSmash)this.iteratePotentialPlayers(controller);
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            DeltaCoord bodySize = controller.body.getFarCorner().difference(controller.body.getCorner());
            double halfBodyWidth = bodySize.x / 2;
            for (LimbInfo li : controller.limbs) {
                IDeltaChunk idc;
                if (li.type != ColossusController.LimbType.ARM && li.type != ColossusController.LimbType.LEG || (idc = li.idc.getEntity()) == null || idc.hasOrderedRotation() || li.type == ColossusController.LimbType.LEG && player.field_70163_u > idc.field_70163_u) continue;
                double farthest = li.length + 2;
                double nearest = li.length - 2;
                double dist = idc.func_70032_d((Entity)player);
                if (dist > farthest || dist < nearest) continue;
                Vec3 li2player = SpaceUtil.subtract(SpaceUtil.fromEntPos((Entity)player), SpaceUtil.fromEntPos(idc));
                Vec3 localOffset = SpaceUtil.copy(li2player);
                controller.body.getRotation().applyReverseRotation(localOffset);
                if ((li.side != ColossusController.BodySide.LEFT ? localOffset.field_72449_c < -halfBodyWidth : localOffset.field_72449_c > halfBodyWidth) || localOffset.field_72450_a < 0.0) continue;
                Vec3 src = Vec3.func_72443_a((double)0.0, (double)-1.0, (double)0.0);
                Vec3 dst = li2player.func_72432_b();
                Vec3 axis = src.func_72431_c(dst);
                double angle = SpaceUtil.getAngle(src, dst);
                controller.body.getRotation().applyReverseRotation(axis);
                Quaternion hitQuat = Quaternion.getRotationQuaternionRadians(angle *= 1.5, axis);
                TargetSmash smash = new TargetSmash();
                smash.limb = li;
                smash.rotation = hitQuat;
                return smash;
            }
            return CONTINUE;
        }

        class TargetSmash {
            LimbInfo limb;
            Quaternion rotation;

            TargetSmash() {
            }
        }
    }
    ,
    FINISH_HIT{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            Quaternion bodyRotation = controller.body.getRotation();
            for (LimbInfo li : controller.limbs) {
                if (!li.type.isArmOrLeg()) continue;
                li.causesPain(false);
                double error = li.idc.getEntity().getRotation().getAngleBetween(bodyRotation);
                if (error < 0.001) continue;
                li.target(new Quaternion(), 1.0, Interpolation.SMOOTH);
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller);
        }
    }
    ,
    SPIN_WINDUP{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.DEFENSIVE;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            this.playNoise(controller);
            ColossusController.BodySide side = controller.field_70170_p.field_73012_v.nextBoolean() ? ColossusController.BodySide.LEFT : ColossusController.BodySide.RIGHT;
            ColossusController.BodySide oppositeSide = controller.spin_direction == ColossusController.BodySide.LEFT ? ColossusController.BodySide.RIGHT : ColossusController.BodySide.LEFT;
            controller.spin_direction = side;
            for (LimbInfo li : controller.limbs) {
                this.targetLimb(li, side);
            }
            for (LimbInfo li : controller.limbs) {
                if (li.type != ColossusController.LimbType.LEG || li.side != oppositeSide) continue;
                Quaternion rot = Quaternion.getRotationQuaternionRadians(0.9424777960769379, ForgeDirection.NORTH);
                li.target(rot, 1.0, Interpolation.SMOOTH);
                break;
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller, SPIN_UNWIND);
        }
    }
    ,
    SPIN_UNWIND{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            ColossusController.BodySide oppositeSide = controller.spin_direction == ColossusController.BodySide.LEFT ? ColossusController.BodySide.RIGHT : ColossusController.BodySide.LEFT;
            for (LimbInfo li : controller.limbs) {
                this.targetLimb(li, oppositeSide);
                if (!li.type.isArmOrLeg()) continue;
                li.causesPain(true);
            }
            Quaternion newTarget = this.getBestTargetAngle(controller);
            controller.bodyLimbInfo.target(newTarget, 1.0, Interpolation.SMOOTHER);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller, FINISH_MOVE);
        }

        Quaternion getBestTargetAngle(ColossusController controller) {
            double currentAngle;
            double dist;
            EntityPlayer player = this.getClosestPlayer(controller);
            if (player == null) {
                return this.getDefaultSpin(controller);
            }
            Vec3 forward = SpaceUtil.fromDirection(ForgeDirection.EAST);
            Vec3 playerOffset = SpaceUtil.subtract(SpaceUtil.fromEntPos((Entity)player), SpaceUtil.fromEntPos(controller));
            playerOffset.field_72448_b = 0.0;
            double targetAngle = SpaceUtil.getAngle(forward, playerOffset = playerOffset.func_72432_b());
            if (Math.signum(targetAngle) != (double)this.getSpinDirection(controller)) {
                targetAngle = Math.PI * 2 - targetAngle;
            }
            if ((dist = Math.abs(targetAngle - (currentAngle = controller.body.getRotation().toRotationVector().field_72448_b))) < 1.5707963267948966) {
                return this.getDefaultSpin(controller);
            }
            return Quaternion.getRotationQuaternionRadians(targetAngle, ForgeDirection.UP);
        }

        Quaternion getDefaultSpin(ColossusController controller) {
            double d = this.getSpinDirection(controller);
            Quaternion bod = controller.body.getRotation();
            Quaternion newBod = bod.multiply(Quaternion.getRotationQuaternionRadians(d * Math.PI * 1.75, ForgeDirection.UP));
            newBod.incrLongFor(bod);
            return newBod;
        }

        private int getSpinDirection(ColossusController controller) {
            return controller.spin_direction == ColossusController.BodySide.LEFT ? -1 : 1;
        }

        EntityPlayer getClosestPlayer(ColossusController controller) {
            EntityPlayer best = null;
            double bestDist = Double.MAX_VALUE;
            for (EntityPlayer player : controller.field_70170_p.field_73010_i) {
                if (!this.targetablePlayer(player, controller) || !player.field_70122_E || !(player.field_70163_u < controller.field_70163_u)) continue;
                double dist = player.func_70068_e((Entity)controller);
                if (best != null && !(dist < bestDist)) continue;
                bestDist = dist;
                best = player;
            }
            return best;
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            return null;
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            for (LimbInfo li : controller.limbs) {
                li.causesPain(false);
            }
            STAND_STILL.onEnterState(controller, this);
        }
    }
    ,
    SHRUG{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.DEFENSIVE;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            for (LimbInfo li : controller.limbs) {
                IDeltaChunk idc = li.idc.getEntity();
                if (idc == null || li.type != ColossusController.LimbType.ARM) continue;
                double angle = (double)(li.side == ColossusController.BodySide.RIGHT ? -1 : 1) * Math.toRadians(135.0);
                Quaternion rot = Quaternion.getRotationQuaternionRadians(angle, ForgeDirection.EAST);
                li.target(rot, 1.0, Interpolation.SMOOTH);
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller, UNSHRUG);
        }
    }
    ,
    UNSHRUG{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            STAND_STILL.onEnterState(controller, prevState);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller);
        }
    }
    ,
    WANDER{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.IDLER;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (controller.atTarget()) {
                return PICK_NEXT_TECHNIQUE;
            }
            return this;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            double range = 32.0;
            Coord target = controller.getHome().copy();
            double dx = this.rng(controller) * range;
            double dz = this.rng(controller) * range;
            target = target.add((int)dx, 0, (int)dz);
            controller.setTarget(target);
        }

        double rng(ColossusController controller) {
            return controller.field_70170_p.field_73012_v.nextDouble() * 2.0 - 1.0;
        }
    }
    ,
    DEATH_FALL{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        boolean usable(ColossusController controller) {
            return controller.func_110143_aJ() <= 0.0f;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            this.playNoise(controller);
            for (LimbInfo li : controller.limbs) {
                IDeltaChunk idc = li.idc.getEntity();
                idc.func_70016_h(0.0, 0.0, 0.0);
                idc.setRotationalVelocity(new Quaternion());
                idc.permit(DeltaCapability.VIOLENT_COLLISIONS);
            }
            Quaternion fallAxis = Quaternion.getRotationQuaternionRadians(1.5707963267948966, ForgeDirection.SOUTH);
            Quaternion rotation = controller.body.getRotation();
            fallAxis = rotation.multiply(fallAxis);
            controller.body.orderTargetRotation(fallAxis, 50, Interpolation.SQUARE);
            controller.setTarget(null);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return controller.body.hasOrderedRotation() ? this : DEATH_EXPLODE;
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            for (LimbInfo li : controller.limbs) {
                IDeltaChunk idc = li.idc.getEntity();
                idc.func_70016_h(0.0, 0.0, 0.0);
                idc.setRotationalVelocity(new Quaternion());
            }
        }
    }
    ,
    DEATH_EXPLODE{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age % 15 != 0) {
                return this;
            }
            boolean any = false;
            double n = 1.0 + (double)controller.leg_size / 2.0 * (double)(age / 45);
            for (LimbInfo li : controller.limbs) {
                final ReservoirSampler sampler = new ReservoirSampler((int)n, null);
                IDeltaChunk idc = li.idc.getEntity();
                Coord.iterateCube(idc.getCorner(), idc.getFarCorner(), new ICoordFunction(){

                    @Override
                    public void handle(Coord here) {
                        if (here.isAir()) {
                            return;
                        }
                        if (here.getBlock() == Core.registry.colossal_block) {
                            int md = here.getMd();
                            if (md == 0) {
                                return;
                            }
                            if (md == 6) {
                                return;
                            }
                        }
                        sampler.give(here.copy());
                    }
                });
                for (Coord c : sampler) {
                    this.dislodge(idc, c);
                    any = true;
                }
            }
            if (any) {
                for (LimbInfo li : controller.limbs) {
                    IDeltaChunk idc = li.idc.getEntity();
                    idc.field_70179_y = 0.0;
                    idc.field_70181_x = 0.0;
                    idc.field_70159_w = 0.0;
                }
            }
            return any ? this : DEATH_EXPIRE;
        }

        void dislodge(IDeltaChunk idc, Coord src) {
            Coord dest = src.copy();
            idc.shadow2real(dest);
            Block b = src.getBlock();
            int md = src.getMd();
            float explosionPower = 2.0f;
            float explodeChance = 0.125f;
            if (b == Core.registry.colossal_block && md == 5) {
                explodeChance = 1.0f;
                explodeChance = 4.0f;
            }
            if (src.w.field_73012_v.nextFloat() < explodeChance) {
                dest.w.func_72876_a(null, (double)dest.x + 0.5, (double)dest.y + 0.5, (double)dest.z + 0.5, explosionPower, false);
            }
            if (!dest.isReplacable() || src.getTE() != null) {
                src.breakBlock();
                src.setAir();
                return;
            }
            if (b == Core.registry.colossal_block || src.getHardness() <= 0.0f) {
                src.setAir();
                return;
            }
            TransferLib.move(src, dest, true, true);
            EntityFallingBlock sand = new EntityFallingBlock(dest.w, (double)dest.x, (double)dest.y, (double)dest.z, dest.getId(), dest.getMd());
            sand.field_145812_b = 1;
            dest.setAir();
            double gs = 0.05;
            sand.field_70159_w = 0.0;
            sand.field_70179_y = 0.0;
            sand.field_70181_x = Math.abs(dest.w.field_73012_v.nextGaussian() * gs);
            sand.field_70170_p.func_72838_d((Entity)sand);
        }
    }
    ,
    DEATH_EXPIRE{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this;
        }

        @Override
        public void onEnterState(final ColossusController controller, Technique prevState) {
            final ArrayList lmps = new ArrayList();
            for (LimbInfo li : controller.limbs) {
                final IDeltaChunk idc = li.idc.getEntity();
                Coord min = idc.getCorner();
                Coord max = idc.getFarCorner();
                Coord.iterateCube(min, max, new ICoordFunction(){

                    @Override
                    public void handle(Coord here) {
                        if (here.getBlock() != Core.registry.colossal_block) {
                            return;
                        }
                        int md = here.getMd();
                        switch (md) {
                            default: {
                                return;
                            }
                            case 1: 
                            case 5: 
                            case 6: {
                                here.setAir();
                                Vec3 core = idc.shadow2real(here.createVector().func_72441_c(0.5, 0.5, 0.5));
                                controller.field_70170_p.func_72885_a(null, core.field_72450_a, core.field_72448_b, core.field_72449_c, 0.25f, false, true);
                                if (md != 6) break;
                                ItemStack lmp = new ItemStack((Item)Core.registry.logicMatrixProgrammer);
                                EntityItem ei = new EntityItem(controller.field_70170_p, core.field_72450_a, core.field_72448_b, core.field_72449_c, lmp);
                                ei.field_83001_bt = true;
                                ei.field_70181_x = 1.0;
                                lmps.add(ei);
                                EntityFireworkRocket flare = new EntityFireworkRocket(controller.field_70170_p, core.field_72450_a, core.field_72448_b, core.field_72449_c, null);
                                lmps.add(flare);
                                break;
                            }
                            case 0: {
                                here.setAir();
                                Coord real = here.copy();
                                idc.shadow2real(real);
                                if (!real.isReplacable()) break;
                                EntityFallingBlock mask = new EntityFallingBlock(real.w, (double)real.x, (double)real.y, (double)real.z, Core.registry.colossal_block, 0);
                                mask.field_145812_b = 1;
                                lmps.add(mask);
                            }
                        }
                    }
                });
            }
            for (Entity l : lmps) {
                l.field_70170_p.func_72838_d(l);
            }
            for (LimbInfo li : controller.limbs) {
                li.idc.getEntity().func_70106_y();
            }
            controller.func_70106_y();
        }
    };

    static final double bow_power = 0.4;
    static final Interpolation bendInterp;
    private static final double distSq = 1600.0;
    protected static final Object CONTINUE;
    static final int SIT_FALL_TIME = 60;

    abstract TechniqueKind getKind();

    boolean usable(ColossusController controller) {
        return true;
    }

    @Override
    public Technique tick(ColossusController controller, int age) {
        return this;
    }

    @Override
    public void onEnterState(ColossusController controller, Technique prevState) {
    }

    @Override
    public void onExitState(ColossusController controller, Technique nextState) {
    }

    protected Technique finishMove(ColossusController controller, Technique next) {
        for (LimbInfo li : controller.limbs) {
            if (!li.isTurning()) continue;
            return this;
        }
        return next;
    }

    protected Technique finishMove(ColossusController controller) {
        return this.finishMove(controller, PICK_NEXT_TECHNIQUE);
    }

    protected void targetLimb(LimbInfo li, ColossusController.BodySide turnDirection) {
        if (li.type != ColossusController.LimbType.ARM) {
            return;
        }
        double d = turnDirection == ColossusController.BodySide.RIGHT ? -1.0 : 1.0;
        Quaternion rot = Quaternion.getRotationQuaternionRadians(1.5707963267948966, ForgeDirection.SOUTH);
        double turn = li.side == turnDirection ? 90.0 : 45.0;
        turn = Math.toRadians(turn) * d;
        rot = Quaternion.getRotationQuaternionRadians(turn, ForgeDirection.UP).multiply(rot);
        li.target(rot, 1.0, Interpolation.SMOOTH);
    }

    protected <E> E iteratePotentialPlayers(ColossusController controller) {
        ArrayList allPlayers = new ArrayList(controller.field_70170_p.field_73010_i);
        Collections.shuffle(allPlayers, controller.field_70170_p.field_73012_v);
        for (EntityPlayer player : allPlayers) {
            Object res;
            if (!this.targetablePlayer(player, controller) || (res = this.visitPlayer(player, controller)) == CONTINUE) continue;
            return (E)res;
        }
        return null;
    }

    boolean targetablePlayer(EntityPlayer player, ColossusController controller) {
        if (player.func_70068_e((Entity)controller) > 1600.0) {
            return false;
        }
        return !player.field_71075_bZ.field_75098_d || Core.dev_environ;
    }

    protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
        return null;
    }

    void playNoise(ColossusController controller) {
        float volume = 10.0f;
        float pitch = 1.0f;
        controller.field_70170_p.func_72956_a((Entity)controller, "factorization:colossus.tech_" + this, volume, pitch);
    }

    static {
        bendInterp = Interpolation.LINEAR;
        CONTINUE = new Object();
    }
}

