/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import factorization.colossi.WorldGenColossus;
import factorization.common.DarkIronOreGenerator;
import factorization.common.FzConfig;
import factorization.shared.Core;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.world.ChunkDataEvent;

public class WorldgenManager {
    IWorldGenerator silverGen;
    IWorldGenerator darkIronGen;
    private static ArrayList<Chunk> retrogenQueue = new ArrayList();

    public WorldgenManager() {
        Core.loadBus(this);
        this.setupWorldGenerators();
    }

    void setupWorldGenerators() {
        if (FzConfig.gen_silver_ore) {
            this.silverGen = new IWorldGenerator(){
                WorldGenMinable gen;
                {
                    this.gen = new WorldGenMinable((Block)Core.registry.resource_block, FzConfig.silver_ore_node_new_size);
                }

                public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
                    if (!FzConfig.gen_silver_ore) {
                        return;
                    }
                    if (!world.field_73011_w.func_76569_d()) {
                        return;
                    }
                    int count = 1;
                    for (int i = 0; i < count; ++i) {
                        int x = chunkX * 16 + rand.nextInt(16);
                        int z = chunkZ * 16 + rand.nextInt(16);
                        int y = 4 + rand.nextInt(42);
                        this.gen.func_76484_a(world, rand, x, y, z);
                    }
                }
            };
            GameRegistry.registerWorldGenerator((IWorldGenerator)this.silverGen, (int)0);
        }
        if (FzConfig.gen_dark_iron_ore) {
            this.darkIronGen = new DarkIronOreGenerator();
            GameRegistry.registerWorldGenerator((IWorldGenerator)this.darkIronGen, (int)10);
        }
        if (FzConfig.gen_colossi) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenColossus(), (int)-50);
        }
    }

    @SubscribeEvent
    public void enqueueRetrogen(ChunkDataEvent.Load event) {
        if (!FzConfig.enable_retrogen) {
            return;
        }
        NBTTagCompound data = event.getData();
        String oldKey = data.func_74779_i("fzRetro");
        if (FzConfig.retrogen_key.equals(oldKey)) {
            return;
        }
        if (FzConfig.retrogen_silver || FzConfig.retrogen_dark_iron) {
            retrogenQueue.add(event.getChunk());
        }
    }

    @SubscribeEvent
    public void saveRetroKey(ChunkDataEvent.Save event) {
        NBTTagCompound data = event.getData();
        data.func_74778_a("fzRetro", FzConfig.retrogen_key);
    }

    void doRetrogen(boolean test, Chunk chunk, String genType, IWorldGenerator gen) {
        if (!test) {
            return;
        }
        int chunkX = chunk.field_76635_g;
        int chunkZ = chunk.field_76647_h;
        World world = chunk.field_76637_e;
        long worldSeed = world.func_72905_C();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        fmlRandom.setSeed(chunkSeed);
        IChunkProvider chunkProvider = world.func_72863_F();
        gen.generate(fmlRandom, chunkX, chunkZ, world, chunkProvider, chunkProvider);
    }

    public void tickRetrogenQueue() {
        if (retrogenQueue.isEmpty()) {
            return;
        }
        WorldgenManager.log("Starting %s chunks", retrogenQueue.size());
        for (int i = 0; i < retrogenQueue.size(); ++i) {
            Chunk chunk = retrogenQueue.get(i);
            this.doRetrogen(FzConfig.retrogen_silver, chunk, "Silver", this.silverGen);
            this.doRetrogen(FzConfig.retrogen_dark_iron, chunk, "Dark Iron", this.darkIronGen);
        }
        retrogenQueue.clear();
        WorldgenManager.log("Done", new Object[0]);
    }

    public static void log(String format, Object ... formatParameters) {
        Core.logWarning("Retrogen> " + format, formatParameters);
    }
}

