/*
 * Decompiled with CFR 0.152.
 */
package factorization.coremod;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;

public class AtVerifier {
    private static String currentLine;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void verify() {
        CharSource at = Resources.asCharSource((URL)Resources.getResource((String)"factorization_at.cfg"), (Charset)Charsets.UTF_8);
        if (at == null) {
            throw new IllegalArgumentException("AT is missing!");
        }
        try {
            Splitter bannana = Splitter.on((String)" ").trimResults();
            for (String line : at.readLines()) {
                String member;
                String className;
                String access;
                List parts;
                int rem = line.indexOf("#");
                if (rem != -1) {
                    line = line.substring(0, rem);
                }
                currentLine = line = line.trim();
                if (line.equals("") || (parts = bannana.splitToList((CharSequence)line)) == null || parts.size() == 0) continue;
                if (parts.size() == 3) {
                    access = (String)parts.get(0);
                    className = (String)parts.get(1);
                    member = (String)parts.get(2);
                } else {
                    if (parts.size() != 2) throw new IllegalArgumentException("Malformed AT? " + line);
                    access = (String)parts.get(0);
                    className = (String)parts.get(1);
                    member = null;
                }
                try {
                    AtVerifier.validate(access, className, member);
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException(t);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Handling: " + currentLine, e);
        }
    }

    protected static void validate(String access, String className, String member) throws Throwable {
        Class<?> theClass;
        try {
            theClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
                return;
            }
            throw e;
        }
        if (member == null) {
            AtVerifier.validateClass(access, theClass);
            return;
        }
        if (member.startsWith("*")) {
            return;
        }
        if (member.contains("(")) {
            AtVerifier.validateMethod(access, theClass, member);
        } else {
            AtVerifier.validateField(access, theClass, member);
        }
    }

    private static void validateClass(String access, Class<?> theClass) {
        int mod = theClass.getModifiers();
        AtVerifier.checkModifiers(access, mod);
    }

    private static void validateField(String access, Class<?> theClass, String member) throws Throwable {
        Field field = theClass.getDeclaredField(member);
        int mod = field.getModifiers();
        AtVerifier.checkModifiers(access, mod);
    }

    private static void validateMethod(String access, Class<?> theClass, String member) throws Throwable {
        int paren = member.indexOf("(");
        String methodName = member.substring(0, paren);
        String descr = member.substring(paren, member.length());
        Type methType = Type.getType((String)descr);
        Type[] argTypes = methType.getArgumentTypes();
        ArrayList params = new ArrayList();
        block12: for (Type t : argTypes) {
            switch (t.getSort()) {
                case 10: {
                    params.add(Class.forName(t.getClassName()));
                    continue block12;
                }
                case 5: {
                    params.add(Integer.TYPE);
                    continue block12;
                }
                case 4: {
                    params.add(Short.TYPE);
                    continue block12;
                }
                case 1: {
                    params.add(Boolean.TYPE);
                    continue block12;
                }
                case 7: {
                    params.add(Long.TYPE);
                    continue block12;
                }
                case 3: {
                    params.add(Byte.TYPE);
                    continue block12;
                }
                case 2: {
                    params.add(Character.TYPE);
                    continue block12;
                }
                case 6: {
                    params.add(Float.TYPE);
                    continue block12;
                }
                case 8: {
                    params.add(Double.TYPE);
                    continue block12;
                }
                case 9: {
                    params.add(Object[].class);
                }
            }
        }
        Method m = theClass.getDeclaredMethod(methodName, params.toArray(new Class[0]));
        AtVerifier.checkModifiers(access, m.getModifiers());
    }

    private static void checkModifiers(String access, int mod) {
        if (access.endsWith("-f") && Modifier.isFinal(mod)) {
            AtVerifier.crash();
        }
        if (access.endsWith("+f") && !Modifier.isFinal(mod)) {
            AtVerifier.crash();
        }
        if (access.startsWith("public") && !Modifier.isPublic(mod)) {
            AtVerifier.crash();
        }
        if (access.startsWith("protected") && !Modifier.isPublic(mod) && !Modifier.isProtected(mod)) {
            AtVerifier.crash();
        }
    }

    private static void crash() {
        throw new IllegalArgumentException("AT failed: " + currentLine);
    }
}

