/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.common.FzConfig;
import factorization.shared.Core;
import factorization.util.PlayerUtil;
import java.util.HashSet;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;

public class DistributeDocs {
    static HashSet<String> needyPlayers = new HashSet();
    static final String guideKey = "fzColossusGuide";
    static StatBase guideGet = new StatBase("factorization.dropcolossusguide", (IChatComponent)new ChatComponentTranslation("factorization.dropcolossusguide", new Object[0])).func_75971_g();

    static Item getGivenItem() {
        if (FzConfig.gen_colossi) {
            return Core.registry.colossusGuide;
        }
        return Core.registry.logicMatrixProgrammer;
    }

    static boolean givenBook(EntityPlayer player) {
        if (!FzConfig.players_discover_colossus_guides) {
            return true;
        }
        StatisticsFile statsFile = PlayerUtil.getStatsFile(player);
        return statsFile != null && statsFile.func_77444_a(guideGet) > 0 || player.getEntityData().func_74764_b(guideKey);
    }

    static void setGivenBook(EntityPlayer player) {
        if (!FzConfig.players_discover_colossus_guides) {
            return;
        }
        needyPlayers.remove(player.func_70005_c_());
        StatisticsFile statsFile = PlayerUtil.getStatsFile(player);
        if (statsFile != null) {
            statsFile.func_150873_a(player, guideGet, 1);
        }
        player.getEntityData().func_74757_a(guideKey, true);
    }

    @SubscribeEvent
    public void onPlayerLogon(PlayerEvent.PlayerLoggedInEvent event) {
        if (DistributeDocs.givenBook(event.player)) {
            DistributeDocs.setGivenBook(event.player);
            return;
        }
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        needyPlayers.add(player.func_70005_c_());
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (event.world.field_73012_v.nextInt(32) != 0 && !Core.dev_environ) {
            return;
        }
        EntityPlayer ply = event.getPlayer();
        if (!(ply instanceof EntityPlayerMP) || ply instanceof FakePlayer) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)ply;
        if (player.field_71134_c.func_73081_b() == WorldSettings.GameType.CREATIVE) {
            return;
        }
        String name2 = player.func_70005_c_();
        if (!needyPlayers.contains(name2)) {
            return;
        }
        StatisticsFile sfw = PlayerUtil.getStatsFile((EntityPlayer)player);
        if (sfw == null) {
            return;
        }
        if (!sfw.func_77443_a(AchievementList.field_76019_w)) {
            return;
        }
        Item toGive = DistributeDocs.getGivenItem();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = player.field_71071_by.func_70301_a(i);
            if (is == null || is.func_77973_b() != toGive) continue;
            Core.logInfo("%s already had an Colossus Guide, so won't give another one", player);
            DistributeDocs.setGivenBook((EntityPlayer)player);
            return;
        }
        Coord broke = new Coord(event.world, event.x, event.y, event.z);
        if (!this.safeArea(broke)) {
            return;
        }
        broke.spawnItem(new ItemStack(toGive));
        DistributeDocs.setGivenBook((EntityPlayer)player);
        Core.logInfo("Giving %s a colossus guide", name2);
    }

    boolean safeArea(Coord at) {
        int r = 2;
        Coord min = at.add(-r, -r, -r);
        Coord max = at.add(r, r, r);
        Checker c = new Checker();
        Coord.iterateCube(min, max, c);
        return c.cool;
    }

    static class Checker
    implements ICoordFunction {
        boolean cool = true;

        Checker() {
        }

        @Override
        public void handle(Coord here) {
            Material mat = here.getBlock().func_149688_o();
            if (mat == Material.field_151587_i || mat == Material.field_151570_A || mat == Material.field_151581_o) {
                this.cool = false;
            }
        }
    }
}

