/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import factorization.docs.AbstractPage;
import factorization.docs.ClientTypesetter;
import factorization.docs.Document;
import factorization.docs.DocumentationModule;
import factorization.docs.GuiButtonNextPage;
import factorization.docs.Word;
import factorization.docs.WordPage;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class DocViewer
extends GuiScreen {
    final String name;
    int startPageIndex;
    Document doc;
    AbstractPage page;
    GuiButton nextPage;
    GuiButton prevPage;
    GuiButton backButton;
    GuiButton homeButton;
    public static boolean dark_color_scheme = false;
    private static Deque<HistoryPage> the_pageHistory = new ArrayDeque<HistoryPage>();
    public static String current_page = "index";
    public static int current_index = 0;
    int orig_scale = -1;
    boolean hot = true;
    int startMouseX;
    int startMouseY;
    long last_delay = Long.MAX_VALUE;

    int getPageWidth(int pageNum) {
        return this.field_146294_l * 40 / 100;
    }

    int getPageLeft(int pageNum) {
        int avail = this.field_146294_l - this.getPageWidth(pageNum) * 2;
        if (pageNum == 0) {
            return avail / 3;
        }
        return this.getPageWidth(pageNum) + avail * 2 / 3;
    }

    int getPageTop(int pageNum) {
        return this.field_146295_m * 5 / 100;
    }

    int getPageHeight(int pageNum) {
        return this.field_146295_m * 90 / 100;
    }

    public static HistoryPage popLastPage() {
        if (the_pageHistory.isEmpty()) {
            return new HistoryPage("index", 0);
        }
        return the_pageHistory.pollLast();
    }

    public static void addNewHistoryEntry(String name2, int page) {
        the_pageHistory.add(new HistoryPage(name2, page));
    }

    public DocViewer(HistoryPage hist) {
        this.name = hist.docName;
        this.startPageIndex = hist.offset;
    }

    public DocViewer(String name2) {
        this.name = name2;
        this.startPageIndex = -1;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.orig_scale == -1) {
            this.field_146297_k = Minecraft.func_71410_x();
            this.orig_scale = this.field_146297_k.field_71474_y.field_74335_Z;
            if (this.orig_scale != 1 && this.orig_scale != 2) {
                this.field_146297_k.field_71474_y.field_74335_Z = 2;
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
            return;
        }
        this.doc = this.getDocument(this.name);
        if (this.doc == null || this.doc.pages.isEmpty()) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        this.page = this.doc.pages.get(0);
        if (this.startPageIndex != -1) {
            if (this.startPageIndex < this.doc.pages.size()) {
                this.page = this.doc.pages.get(this.startPageIndex);
            }
            this.startPageIndex = 0;
        }
        int row = this.getPageHeight(0);
        int arrow_half = 8;
        this.prevPage = new GuiButtonNextPage(2, this.getPageLeft(0) - 12, row - arrow_half, false);
        this.field_146292_n.add(this.prevPage);
        this.nextPage = new GuiButtonNextPage(1, this.getPageLeft(1) + this.getPageWidth(1) - 23 + 12, row - arrow_half, true);
        this.field_146292_n.add(this.nextPage);
        this.backButton = new GuiButton(3, 79, row, 50, 20, "Back");
        this.field_146292_n.add(this.backButton);
        this.homeButton = new GuiButton(4, 158, row, 50, 20, "Home");
        this.field_146292_n.add(this.homeButton);
        current_page = this.doc.name;
    }

    Document getDocument(String name2) {
        ClientTypesetter ts = new ClientTypesetter(this.field_146297_k.field_71466_p, this.getPageWidth(0), this.getPageHeight(0));
        ts.processText(DocumentationModule.readDocument(name2));
        return new Document(name2, ts.getPages());
    }

    AbstractPage getPage(int d) {
        if (this.doc == null) {
            return null;
        }
        if (d == 0) {
            return this.page;
        }
        int i = this.doc.pages.indexOf(this.page) + d;
        if (i < 0) {
            return null;
        }
        if (i >= this.doc.pages.size()) {
            return null;
        }
        return this.doc.pages.get(i);
    }

    int getCurrentPageIndex() {
        int i = 0;
        for (AbstractPage pg : this.doc.pages) {
            if (pg == this.page) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        float cs;
        int pass;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
        this.hot = false;
        this.func_146276_q_();
        this.backButton.field_146125_m = !the_pageHistory.isEmpty();
        this.homeButton.field_146125_m = !this.name.equals("index");
        this.prevPage.field_146125_m = this.doc.pages.indexOf(this.page) > 0;
        this.nextPage.field_146125_m = this.doc.pages.indexOf(this.page) + 2 < this.doc.pages.size();
        for (pass = 1; pass >= 0; --pass) {
            int paddingVert = 8 + pass;
            int paddingHoriz = 12 + pass;
            int x0 = this.getPageLeft(0) - paddingHoriz;
            int x1 = this.getPageLeft(1) + this.getPageWidth(1) + paddingHoriz;
            int y0 = this.getPageTop(0) - paddingVert;
            int y1 = this.getPageHeight(0) + paddingVert;
            if (pass == 1) {
                GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            } else if (dark_color_scheme) {
                GL11.glColor3f((float)0.075f, (float)0.075f, (float)0.1125f);
            } else {
                GL11.glColor3f((float)0.925f, (float)0.925f, (float)0.8875f);
            }
            GL11.glDisable((int)3553);
            GL11.glBegin((int)7);
            GL11.glVertex3f((float)x0, (float)y0, (float)0.0f);
            GL11.glVertex3f((float)x0, (float)y1, (float)0.0f);
            GL11.glVertex3f((float)x1, (float)y1, (float)0.0f);
            GL11.glVertex3f((float)x1, (float)y0, (float)0.0f);
            GL11.glEnd();
        }
        int paddingVert = 8;
        int paddingHoriz = 12;
        int x0 = this.getPageLeft(0) + this.getPageWidth(0) + paddingHoriz;
        int x1 = this.getPageLeft(1) - paddingHoriz;
        int y0 = this.getPageTop(0) - paddingVert;
        int y1 = this.getPageHeight(0) + paddingVert;
        if (dark_color_scheme) {
            cs = 0.75f;
            GL11.glColor3f((float)(0.075f * cs), (float)(0.075f * cs), (float)(0.1125f * cs));
        } else {
            cs = 1.75f;
            GL11.glColor3f((float)(1.0f - 0.075f * cs), (float)(1.0f - 0.075f * cs), (float)(1.0f - 0.1125f * cs));
        }
        GL11.glBegin((int)7);
        GL11.glVertex3f((float)x0, (float)y0, (float)0.0f);
        GL11.glVertex3f((float)x0, (float)y1, (float)0.0f);
        GL11.glVertex3f((float)x1, (float)y1, (float)0.0f);
        GL11.glVertex3f((float)x1, (float)y0, (float)0.0f);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        for (pass = 0; pass <= 1; ++pass) {
            this.drawPage(0, mouseX, mouseY, pass);
            this.drawPage(1, mouseX, mouseY, pass);
        }
        GL11.glPopMatrix();
    }

    void drawPage(int id, int mouseX, int mouseY, int pass) {
        WordPage p;
        AbstractPage page = this.getPage(id);
        if (page == null) {
            return;
        }
        Word hovered = null;
        String hoveredLink = null;
        if (page instanceof WordPage && (hovered = (p = (WordPage)page).click(mouseX - this.getPageLeft(id), mouseY - this.getPageTop(id))) != null) {
            hoveredLink = hovered.getLink();
        }
        if (pass == 0) {
            page.draw(this, this.getPageLeft(id), this.getPageTop(id), hoveredLink);
        } else if (pass == 1 && hovered != null) {
            hovered.drawHover(this, mouseX, mouseY);
        }
    }

    void drawItem(ItemStack is, int x, int y) {
        GL11.glEnable((int)2929);
        GuiContainer.field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), is, x, y);
        GuiContainer.field_146296_j.func_77021_b(this.field_146289_q, this.field_146297_k.func_110434_K(), is, x, y);
    }

    void drawItemTip(ItemStack is, int x, int y) {
        this.func_146285_a(is, x, y);
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        if (this.hot) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 1) {
            this.func_146284_a(this.backButton);
            return;
        }
        for (int i = 0; i <= 1; ++i) {
            WordPage p;
            Word link;
            AbstractPage thisPage = this.getPage(i);
            if (!(thisPage instanceof WordPage) || (link = (p = (WordPage)thisPage).click(mouseX - this.getPageLeft(i), mouseY - this.getPageTop(i))) == null || link.getLink() == null) continue;
            if (link.getLink().equals(this.name)) {
                return;
            }
            DocViewer newDoc = new DocViewer(link.getLink());
            DocViewer.addNewHistoryEntry(this.name, this.getCurrentPageIndex());
            this.field_146297_k.func_147108_a((GuiScreen)newDoc);
            return;
        }
    }

    public void func_146274_d() {
        int scroll = Mouse.getEventDWheel();
        if (scroll == 0) {
            super.func_146274_d();
        } else if (scroll > 0) {
            this.func_146284_a(this.prevPage);
        } else if (scroll < 0) {
            this.func_146284_a(this.nextPage);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (!button.field_146124_l) {
            return;
        }
        if (button == this.nextPage) {
            AbstractPage n = this.getPage(2);
            if (n != null) {
                this.page = n;
            }
        } else if (button == this.prevPage) {
            AbstractPage n = this.getPage(-2);
            if (n != null) {
                this.page = n;
            }
        } else if (button == this.backButton) {
            DocViewer newDoc = new DocViewer(DocViewer.popLastPage());
            this.field_146297_k.func_147108_a((GuiScreen)newDoc);
        } else if (button == this.homeButton && !this.name.equals("index")) {
            DocViewer.addNewHistoryEntry(this.name, this.getCurrentPageIndex());
            this.field_146297_k.func_147108_a((GuiScreen)new DocViewer("index"));
        }
    }

    protected void func_73869_a(char chr, int keySym) {
        if (keySym == 14 || chr == 'z') {
            this.func_146284_a(this.backButton);
        } else if (keySym == 209 || chr == ' ') {
            this.func_146284_a(this.nextPage);
        } else if (keySym == 201) {
            this.func_146284_a(this.prevPage);
        } else if (keySym == 199) {
            this.func_146284_a(this.homeButton);
        } else if (chr == 'r') {
            this.func_73866_w_();
        } else if (chr == 's') {
            dark_color_scheme ^= true;
        } else if (keySym == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)this.field_146297_k.field_71439_g));
        } else {
            super.func_73869_a(chr, keySym);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long heldTime) {
        if (heldTime < this.last_delay) {
            this.startMouseX = mouseX;
            this.startMouseY = mouseY;
        }
        for (int i = 0; i <= 1; ++i) {
            AbstractPage p = this.getPage(i);
            if (p == null || this.getPageLeft(i) > this.startMouseX || this.getPageLeft(i) + this.getPageWidth(i) < this.startMouseX || this.getPageTop(i) >= this.startMouseY || this.getPageTop(i) + this.getPageHeight(i) <= this.startMouseY) continue;
            if (heldTime < this.last_delay) {
                p.mouseDragStart();
            }
            p.mouseDrag(this.startMouseX - mouseX, this.startMouseY - mouseY);
        }
        this.last_delay = heldTime;
    }

    public void func_146281_b() {
        if (this.orig_scale != -1) {
            this.field_146297_k.field_71474_y.field_74335_Z = this.orig_scale;
            this.orig_scale = -1;
        }
        for (AbstractPage page : this.doc.pages) {
            page.closed();
        }
        current_index = this.doc.pages.indexOf(this.getPage(0));
    }

    public boolean func_73868_f() {
        return false;
    }

    FontRenderer getFont() {
        return this.field_146289_q;
    }

    public static class HistoryPage {
        String docName;
        int offset;

        public HistoryPage(String docName, int offset) {
            this.docName = docName;
            this.offset = offset;
        }
    }
}

