/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import cpw.mods.fml.common.Loader;
import factorization.docs.AbstractTypesetter;
import factorization.docs.DocumentationModule;
import factorization.docs.ExportHtml;
import factorization.docs.IDocGenerator;
import factorization.docs.ItemWord;
import factorization.docs.TextWord;
import factorization.docs.Tokenizer;
import factorization.docs.Word;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class HtmlConversionTypesetter
extends AbstractTypesetter {
    PrintStream out;
    final String root;
    static String found_icon = null;

    public HtmlConversionTypesetter(OutputStream out, String root) {
        super(null, 0, 0);
        this.out = new PrintStream(out);
        this.root = root;
    }

    @Override
    protected void handleCommand(Tokenizer tokenizer, String cmd, String link, String style) {
        if (cmd.equals("\\p")) {
            this.s("<br>\n", link);
        } else if (cmd.equals("\\nl")) {
            this.s("<br>\n", link);
        } else if (cmd.equals("\\") || cmd.equals("\\ ")) {
            this.s(" ", link);
        } else if (cmd.equalsIgnoreCase("\\\\")) {
            this.s("\\", link);
        } else if (!cmd.equals("\\newpage") && !cmd.equals("\\leftpage")) {
            if (cmd.equals("\\b") || cmd.equals("\\i") || cmd.equals("\\u") || cmd.equals("\\obf")) {
                String close;
                String open;
                char mode = cmd.charAt(1);
                String content = this.getParameter(cmd, tokenizer);
                if (content == null) {
                    return;
                }
                if (mode == 'b') {
                    open = "<b>";
                    close = "</b>";
                } else if (mode == 'i') {
                    open = "<i>";
                    close = "</i>";
                } else if (mode == 'u') {
                    open = "<u>";
                    close = "</u>";
                } else if (mode == 'o') {
                    open = "<span class=\"mcobfuscated\">";
                    close = "</span>";
                } else {
                    this.error("Unknown style: " + cmd);
                    return;
                }
                this.s(open, null);
                this.process(content, link, style);
                this.s(close, null);
            } else if (cmd.equals("\\title")) {
                this.s("\n\n<h1>", null);
                String val = this.getParameter(cmd, tokenizer);
                if (val == null) {
                    this.error("No content");
                    return;
                }
                this.process(val, link, style);
                this.s("</h1>\n", null);
            } else if (cmd.equals("\\h1")) {
                String val = this.getParameter(cmd, tokenizer);
                if (val == null) {
                    this.error("No content");
                    return;
                }
                this.s("<h2>", null);
                this.process(val, link, style);
                this.s("</h2>\n", null);
            } else if (cmd.equals("\\link") || cmd.equals("\\index")) {
                String newLink = this.getParameter(cmd, tokenizer);
                if (newLink == null) {
                    this.error("missing destination parameter");
                    return;
                }
                String content = this.getParameter(cmd, tokenizer);
                if (content == null) {
                    this.error("missing content parameter");
                    return;
                }
                this.s("<a href=\"" + this.root + newLink + ".html\">", null);
                this.process(content, newLink, style);
                this.s("</a>", null);
                if (cmd.equals("\\index")) {
                    this.s("<br>\n", null);
                }
                ExportHtml.visitLink(newLink);
            } else if (cmd.equals("\\#")) {
                String itemName = this.getParameter(cmd, tokenizer);
                if (itemName == null) {
                    this.error("No item specified");
                    return;
                }
                ArrayList<ItemStack> items = DocumentationModule.lookup(itemName);
                if (items == null) {
                    this.error(itemName + " no such item");
                    return;
                }
                ItemStack theItem = items.get(0);
                this.putItem(theItem, link);
            } else if (cmd.equals("\\img")) {
                String imgName = this.getParameter(cmd, tokenizer);
                if (imgName == null) {
                    this.error("No img specified");
                    return;
                }
                this.s("<img src=\"" + this.img(imgName) + "\" />", link);
            } else if (cmd.equals("\\imgx")) {
                int width = Integer.parseInt(this.getParameter(cmd, tokenizer));
                int height = Integer.parseInt(this.getParameter(cmd, tokenizer));
                String imgName = this.getParameter(cmd, tokenizer);
                if (imgName == null) {
                    this.error("No img specified");
                    return;
                }
                this.s(String.format("<img width=%s height=%s src=\"%s\" />", width, height, this.img(imgName)), link);
            } else if (cmd.equals("\\figure")) {
                String arg = this.getParameter(cmd, tokenizer);
            } else if (cmd.equals("\\generate")) {
                String arg = this.getParameter(cmd, tokenizer);
                String[] args = arg.split("/", 2);
                IDocGenerator gen = DocumentationModule.generators.get(args[0]);
                if (gen == null) {
                    this.error("\\generate{" + arg + "}: Not found: " + args[0]);
                    return;
                }
                String rest = args.length > 1 ? args[1] : "";
                gen.process(this, rest);
            } else if (!cmd.equals("\\seg") && !cmd.equals("\\endseg")) {
                if (cmd.equals("\\topic")) {
                    String topic = this.getParameter(cmd, tokenizer);
                    if (topic == null) {
                        this.error("\\topic missing parameter");
                        return;
                    }
                    String sub = String.format("\\newpage \\generate{recipes/for/%s}", topic);
                    this.append(sub);
                } else if (cmd.equals("\\checkmods")) {
                    String[] mods;
                    String mode = this.getParameter(cmd, tokenizer);
                    if (mode == null) {
                        this.error("\\checkmods missing parameter");
                        return;
                    }
                    String modList = this.getParameter(cmd, tokenizer);
                    if (modList == null) {
                        this.error("\\checkmods missing parameter");
                        return;
                    }
                    String content = this.getParameter(cmd, tokenizer);
                    if (content == null) {
                        this.error("\\checkmods missing parameter");
                        return;
                    }
                    int count = 0;
                    for (String modId : mods = modList.split(" ")) {
                        if (!Loader.isModLoaded((String)modId)) continue;
                        ++count;
                    }
                    boolean good = false;
                    if (mode.equalsIgnoreCase("all")) {
                        good = count == mods.length;
                    } else if (mode.equalsIgnoreCase("none")) {
                        good = count == 0;
                    } else if (mode.equalsIgnoreCase("some")) {
                        good = count > 1;
                    } else {
                        this.error("\\checkmods first parameter must be 'all', 'none', or 'some', not " + mode);
                        return;
                    }
                    String other = this.getParameter(cmd, tokenizer);
                    if (good) {
                        this.process(content, link, style);
                    } else if (other != null) {
                        this.process(other, link, style);
                    }
                } else if (cmd.equals("\\ifhtml")) {
                    String trueBranch = this.getParameter(cmd, tokenizer);
                    String falseBranch = this.getParameter(cmd, tokenizer);
                    this.process(trueBranch, link, style);
                } else if (cmd.equals("\\vpad")) {
                    this.getParameter(cmd, tokenizer);
                } else if (cmd.equals("\\-")) {
                    this.s("<br> \u2022", null);
                } else {
                    this.error("Unknown command: ");
                    this.emit(cmd, null);
                }
            }
        }
    }

    void s(String s, String link) {
        this.out.print(s);
    }

    static String esc(String s) {
        return s.replace("&", "&amp;").replace(">", "&gt;");
    }

    String img(String img) {
        if (!img.contains(":")) {
            img = "minecraft:" + img;
        }
        String[] parts = img.split(":", 2);
        String domain = parts[0];
        String path = parts[1];
        return this.root + "resources/" + domain + "/textures/" + path + ".png";
    }

    @Override
    void error(String msg) {
        this.s("<span class=\"manualerror\">" + msg + "</s>", null);
    }

    @Override
    TextWord emit(String text, String link) {
        this.s(HtmlConversionTypesetter.esc(text), link);
        return null;
    }

    @Override
    void emitWord(Word w) {
        if (w instanceof TextWord) {
            TextWord tw = (TextWord)w;
            this.emit(tw.text, tw.getLink());
        } else if (w instanceof ItemWord) {
            ItemWord iw = (ItemWord)w;
            ItemStack is = iw.getItem();
            this.putItem(is, iw.getLink());
        }
    }

    void putItem(ItemStack theItem, String link) {
        String imgType = null;
        IIcon iconIndex = null;
        if (theItem != null) {
            imgType = theItem.func_94608_d() == 1 ? "items" : "blocks";
            iconIndex = theItem.func_77954_c();
        }
        if (iconIndex == null) {
            imgType = "items";
            found_icon = "factorization:transparent_item";
        } else {
            found_icon = iconIndex.func_94215_i();
            if (!found_icon.contains(":")) {
                found_icon = "minecraft:" + found_icon;
            }
        }
        String[] parts = found_icon.split(":", 2);
        String namespace = parts[0];
        String path = parts[1];
        found_icon = namespace + ":" + imgType + "/" + path;
        if (found_icon != null) {
            this.s("<img class=\"" + imgType + "\" src=\"" + this.img(found_icon) + "\" />", link);
        }
        found_icon = null;
    }
}

