/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import com.google.common.collect.ArrayListMultimap;
import factorization.docs.DocumentationModule;
import factorization.docs.IndexerTypesetter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.AnimationMetadataSectionSerializer;
import net.minecraft.client.resources.data.FontMetadataSection;
import net.minecraft.client.resources.data.FontMetadataSectionSerializer;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.client.resources.data.LanguageMetadataSection;
import net.minecraft.client.resources.data.LanguageMetadataSectionSerializer;
import net.minecraft.client.resources.data.PackMetadataSection;
import net.minecraft.client.resources.data.PackMetadataSectionSerializer;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.client.resources.data.TextureMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;

public class IndexDocumentation {
    static ArrayListMultimap<String, String> index = ArrayListMultimap.create();
    static HashSet<String> foundLinks = new HashSet();
    static ArrayList<String> pendingLinks = new ArrayList();

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: IndexDocumentation outputFile (domain=path)+");
            System.exit(1);
            return;
        }
        final HashMap<String, File> domains = new HashMap<String, File>();
        boolean first = true;
        PrintStream out = null;
        for (String arg : args) {
            if (first) {
                out = new PrintStream(arg);
                first = false;
                continue;
            }
            String[] d = arg.split("\\=");
            domains.put(d[0], new File(d[1]));
        }
        DocumentationModule.overrideResourceManager = new IResourceManager(){

            public Set func_135055_a() {
                HashSet<String> ret = new HashSet<String>();
                ret.add("factorization");
                return ret;
            }

            public IResource func_110536_a(final ResourceLocation location) {
                return new IResource(){

                    public boolean func_110528_c() {
                        return false;
                    }

                    public IMetadataSection func_110526_a(String var1) {
                        return null;
                    }

                    public InputStream func_110527_b() {
                        File domainFile = (File)domains.get(location.func_110624_b());
                        if (domainFile == null) {
                            return null;
                        }
                        String fname = domainFile.getAbsolutePath() + File.separator + location.func_110623_a();
                        try {
                            return new FileInputStream(new File(fname));
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                };
            }

            public List func_135056_b(ResourceLocation location) {
                return Arrays.asList(this.func_110536_a(location));
            }
        };
        IndexDocumentation.crawlDocuments("index", out);
    }

    static void resetInfo() {
        foundLinks.clear();
        pendingLinks.clear();
    }

    static void crawlDocuments(String rootName, PrintStream log) {
        IndexDocumentation.resetInfo();
        IndexDocumentation.foundLink(rootName);
        while (!pendingLinks.isEmpty()) {
            String link = pendingLinks.remove(0);
            String text = DocumentationModule.readDocument(link);
            IndexerTypesetter ts = new IndexerTypesetter(link);
            ts.processText(text);
        }
        for (Map.Entry entry : index.entries()) {
            log.println(((String)entry.getKey()).trim() + "\t" + ((String)entry.getValue()).trim());
        }
    }

    static IResourceManager getMinecraftResources() {
        IMetadataSerializer metadataSerializer_ = new IMetadataSerializer();
        metadataSerializer_.func_110504_a((IMetadataSectionSerializer)new TextureMetadataSectionSerializer(), TextureMetadataSection.class);
        metadataSerializer_.func_110504_a((IMetadataSectionSerializer)new FontMetadataSectionSerializer(), FontMetadataSection.class);
        metadataSerializer_.func_110504_a((IMetadataSectionSerializer)new AnimationMetadataSectionSerializer(), AnimationMetadataSection.class);
        metadataSerializer_.func_110504_a((IMetadataSectionSerializer)new PackMetadataSectionSerializer(), PackMetadataSection.class);
        metadataSerializer_.func_110504_a((IMetadataSectionSerializer)new LanguageMetadataSectionSerializer(), LanguageMetadataSection.class);
        SimpleReloadableResourceManager mcResourceManager = new SimpleReloadableResourceManager(metadataSerializer_);
        return mcResourceManager;
    }

    static void foundLink(String linktarget) {
        if (foundLinks.add(linktarget)) {
            pendingLinks.add(linktarget);
        }
    }

    static void foundTopic(String topicname, String page) {
        index.put((Object)topicname, (Object)page);
    }
}

