/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import com.google.common.collect.HashMultimap;
import factorization.docs.AbstractTypesetter;
import factorization.docs.DocumentationModule;
import factorization.docs.IDocGenerator;
import factorization.docs.ItemWord;
import factorization.shared.Core;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;

public class ItemListViewer
implements IDocGenerator {
    @Override
    public void process(AbstractTypesetter sb, String arg) {
        if (arg.equalsIgnoreCase("all")) {
            this.listAll(sb, null);
            return;
        }
        CreativeTabs found = null;
        for (CreativeTabs ct : CreativeTabs.field_78032_a) {
            if (!ct.func_78013_b().equalsIgnoreCase(arg)) continue;
            found = ct;
            break;
        }
        if (found != null) {
            this.listAll(sb, found);
        } else {
            this.listTabs(sb);
        }
    }

    void listTabs(AbstractTypesetter sb) {
        String ret = "";
        ret = ret + "\\title{Item Categories}\n\n";
        ret = ret + "\n\n\\link{cgi/items/all}{All Items}";
        for (CreativeTabs ct : CreativeTabs.field_78032_a) {
            if (ct == CreativeTabs.field_78027_g || ct == CreativeTabs.field_78036_m) continue;
            String text = ct.func_78013_b();
            ret = ret + "\\nl\\link{cgi/items/" + text + "}{" + Core.translateThis("itemGroup." + text) + "}";
        }
        sb.process(ret, null, "");
    }

    void listAll(AbstractTypesetter sb, CreativeTabs ct) {
        if (ct == null) {
            sb.append("\\title{All Items}");
        } else {
            String title = ct.func_78013_b();
            title = Core.translateThis("itemGroup." + title);
            sb.append("\\title{" + title + "}");
        }
        sb.append("\n\n");
        int size = DocumentationModule.getNameItemCache().size();
        HashMultimap found = HashMultimap.create((int)size, (int)1);
        ArrayList<String> toSort = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<ItemStack>> pair : DocumentationModule.getNameItemCache().entrySet()) {
            ArrayList<ItemStack> items = pair.getValue();
            for (ItemStack is : items) {
                if (ct != null && is.func_77973_b().func_77640_w() != ct) continue;
                String name2 = is.func_82833_r();
                if (!found.containsKey((Object)name2)) {
                    toSort.add(name2);
                }
                found.put((Object)name2, (Object)is);
            }
        }
        Collections.sort(toSort);
        for (String name3 : toSort) {
            for (ItemStack is : found.get((Object)name3)) {
                if (is == null) continue;
                sb.emitWord(new ItemWord(is));
                sb.append(" ");
                sb.emit(name3, null);
                sb.append("\n\n");
            }
        }
    }
}

