/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import cpw.mods.fml.relauncher.ReflectionHelper;
import factorization.docs.AbstractTypesetter;
import factorization.docs.IDocGenerator;
import factorization.docs.ItemWord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class TreasureViewer
implements IDocGenerator {
    @Override
    public void process(AbstractTypesetter out, String arg) {
        Map chestHooks = (Map)ReflectionHelper.getPrivateValue(ChestGenHooks.class, null, (String[])new String[]{"chestInfo"});
        ArrayList names = new ArrayList(chestHooks.keySet());
        Collections.sort(names);
        for (String chestName : names) {
            ChestGenHooks hook = (ChestGenHooks)chestHooks.get(chestName);
            ArrayList content = (ArrayList)ReflectionHelper.getPrivateValue(ChestGenHooks.class, (Object)hook, (String[])new String[]{"contents"});
            if (content == null || content.isEmpty()) continue;
            content = new ArrayList(content);
            Collections.sort(content, new Comparator<WeightedRandomChestContent>(){

                @Override
                public int compare(WeightedRandomChestContent a, WeightedRandomChestContent b) {
                    return b.field_76292_a - a.field_76292_a;
                }
            });
            out.append("\\newpage \\title{Treasure: " + chestName + "}");
            boolean can_blob = false;
            for (WeightedRandomChestContent item : content) {
                if (!can_blob) {
                    out.append("\\p");
                }
                String descr = null;
                if (item.field_76295_d == item.field_76296_e) {
                    if (item.field_76295_d != 1) {
                        descr = " (" + item.field_76295_d + ")";
                    }
                } else {
                    descr = " (" + item.field_76295_d + " to " + item.field_76296_e + ")";
                }
                if (descr == null) {
                    can_blob = true;
                    out.emitWord(new ItemWord(item.field_76297_b));
                    continue;
                }
                if (can_blob) {
                    can_blob = false;
                    out.append("\\p");
                }
                out.emitWord(new ItemWord(item.field_76297_b));
                out.append(descr);
            }
        }
    }
}

