/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import factorization.api.Coord;
import factorization.fzds.interfaces.IDeltaChunk;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class DeltaChunkMap {
    private Map<Long, IDeltaChunk[]> values = new HashMap<Long, IDeltaChunk[]>();
    private static final IDeltaChunk[] EMPTY_ARRAY = new IDeltaChunk[0];

    private long hash(int chunkX, int chunkZ) {
        long ret = (long)chunkX | (long)chunkZ << 32;
        return ret;
    }

    private IDeltaChunk[] normalize(IDeltaChunk[] val) {
        return val == null ? EMPTY_ARRAY : val;
    }

    public IDeltaChunk[] get(int chunkX, int chunkZ) {
        return this.normalize(this.values.get(this.hash(chunkX, chunkZ)));
    }

    public IDeltaChunk[] get(Coord at) {
        return this.normalize(this.values.get(this.hash(at.x / 16, at.z / 16)));
    }

    public boolean remove(IDeltaChunk dse) {
        Coord lower = dse.getCorner();
        Coord upper = dse.getFarCorner();
        boolean any = false;
        for (int x = lower.x - 16; x <= upper.x + 16; x += 16) {
            for (int z = lower.z - 16; z <= upper.z + 16; z += 16) {
                any |= this.remove0(dse, x / 16, z / 16);
            }
        }
        return any;
    }

    private boolean remove0(IDeltaChunk dse, int chunkX, int chunkZ) {
        IDeltaChunk[] origArray = this.get(chunkX, chunkZ);
        if (origArray.length == 1 && origArray[0] == dse) {
            this.values.remove(this.hash(chunkX, chunkZ));
            return true;
        }
        IDeltaChunk[] newArray = (IDeltaChunk[])ArrayUtils.removeElement((Object[])origArray, (Object)((Object)dse));
        this.values.put(this.hash(chunkX, chunkZ), newArray);
        return true;
    }

    public boolean add(IDeltaChunk dse) {
        Coord lower = dse.getCorner();
        Coord upper = dse.getFarCorner();
        boolean any = false;
        for (int x = lower.x - 16; x <= upper.x + 16; x += 16) {
            for (int z = lower.z - 16; z <= upper.z + 16; z += 16) {
                any |= this.add0(dse, x / 16, z / 16);
            }
        }
        return any;
    }

    private boolean add0(IDeltaChunk dse, int chunkX, int chunkZ) {
        IDeltaChunk[] origArray;
        for (IDeltaChunk idc : origArray = this.get(chunkX, chunkZ)) {
            if (idc != dse) continue;
            return false;
        }
        this.values.put(this.hash(chunkX, chunkZ), (IDeltaChunk[])ArrayUtils.add((Object[])origArray, (Object)((Object)dse)));
        return true;
    }

    public void clear() {
        this.values.clear();
    }
}

