/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.fzds.ClickHandler;
import factorization.fzds.DeltaChunkMap;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.FZDSCommand;
import factorization.fzds.HammerInfo;
import factorization.fzds.HammerNet;
import factorization.fzds.HammerProxy;
import factorization.fzds.HammerWorldProvider;
import factorization.fzds.PPPChunkLoader;
import factorization.fzds.ServerShadowWorldAccess;
import factorization.fzds.network.FzdsPacketRegistry;
import factorization.fzds.network.WrappedPacket;
import factorization.shared.Core;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.Vec3;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="factorization.dimensionalSlice", name="Factorization Dimensional Slices", version="0.8.88.8.8888h")
public class Hammer {
    final String[] Lore = new String[]{"At twilight's end, the shadow's crossed,", "A new world birthed, the elder lost.", "Yet on the morn we wake to find", "That mem'ry left so far behind.", "To deafened ears we ask, unseen,", "\u201cWhich is life and which the dream?\u201d"};
    public static final String modId = "factorization.dimensionalSlice";
    public static final String name = "Factorization Dimensional Slices";
    public static Hammer instance;
    public static HammerNet net;
    @SidedProxy(clientSide="factorization.fzds.HammerClientProxy", serverSide="factorization.fzds.HammerProxy")
    public static HammerProxy proxy;
    public static World worldClient;
    public static double DSE_ChunkUpdateRangeSquared;
    public static int fzds_command_channel;
    public static int max_fzds_grab_area;
    public static int max_dse_collidable_chunk_area;
    static DeltaChunkMap serverSlices;
    static DeltaChunkMap clientSlices;
    public static final HammerInfo hammerInfo;
    static final int channelWidth = 800;
    private static Logger hammerLogger;

    public Hammer() {
        instance = this;
        net = new HammerNet();
        Core.loadBus(this);
    }

    @Mod.EventHandler
    public void setup(FMLPreInitializationEvent event) {
        event.getModMetadata().parent = "factorization";
        File configFile = event.getSuggestedConfigurationFile();
        File base = configFile.getParentFile();
        hammerInfo.setConfigFile(new File(base, "hammerChannels.cfg"));
        int client_despawn_distance = 160;
        EntityRegistry.registerModEntity(DimensionSliceEntity.class, (String)"fzds", (int)1, (Object)this, (int)client_despawn_distance, (int)1, (boolean)true);
        DimensionManager.registerProviderType((int)Hammer.getDimensionId(), HammerWorldProvider.class, (boolean)true);
        DimensionManager.registerDimension((int)Hammer.getDimensionId(), (int)Hammer.getDimensionId());
        fzds_command_channel = hammerInfo.makeChannelFor("factorization", "fzdscmd", fzds_command_channel, -1, "This channel is used for Slices created using the /fzds command");
        FzdsPacketRegistry.init();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            proxy.clientInit();
        }
        Core.loadBus(hammerInfo);
        Core.loadBus(proxy);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            Core.loadBus(new ClickHandler());
        }
        WrappedPacket.registerPacket();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new PPPChunkLoader());
    }

    @Mod.EventHandler
    public void finishLoad(FMLPostInitializationEvent event) {
        hammerInfo.saveChannelConfig();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new FZDSCommand());
        DimensionManager.initDimension((int)Hammer.getDimensionId());
        if (!DimensionManager.shouldLoadSpawn((int)Hammer.getDimensionId())) {
            throw new RuntimeException("hammerWorld is not loaded");
        }
        WorldServer hammerWorld = DimensionManager.getWorld((int)Hammer.getDimensionId());
        hammerWorld.func_72954_a((IWorldAccess)new ServerShadowWorldAccess());
        int view_distance = MinecraftServer.func_71276_C().func_71203_ab().func_72395_o();
        DSE_ChunkUpdateRangeSquared = Math.pow(PlayerManager.func_72686_a((int)view_distance) + 32, 2.0);
    }

    @Mod.EventHandler
    public void saveInfo(FMLServerStoppingEvent event) {
        hammerInfo.saveCellAllocations();
        serverSlices.clear();
        clientSlices.clear();
    }

    @SubscribeEvent
    public void clearSlicesBeforeConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        proxy.cleanupClientWorld();
    }

    public static Vec3 ent2vec(Entity ent) {
        return Vec3.func_72443_a((double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v);
    }

    private void initializeLogging(Logger logger) {
        hammerLogger = logger;
    }

    public static void logSevere(String format, Object ... formatParameters) {
        hammerLogger.error(String.format(format, formatParameters));
    }

    public static void logWarning(String format, Object ... formatParameters) {
        hammerLogger.warn(String.format(format, formatParameters));
    }

    public static void logInfo(String format, Object ... formatParameters) {
        hammerLogger.info(String.format(format, formatParameters));
    }

    public static void logFine(String format, Object ... formatParameters) {
        if (Core.dev_environ) {
            hammerLogger.info(String.format(format, formatParameters));
        }
    }

    public static int getDimensionId() {
        return HammerInfo.dimension_slice_dimid;
    }

    static {
        worldClient = null;
        DSE_ChunkUpdateRangeSquared = Math.pow(128.0, 2.0);
        fzds_command_channel = 0;
        max_fzds_grab_area = 81920;
        max_dse_collidable_chunk_area = 729;
        serverSlices = new DeltaChunkMap();
        clientSlices = new DeltaChunkMap();
        hammerInfo = new HammerInfo();
        hammerLogger = LogManager.getLogger((String)"FZ-Hammer-init");
    }
}

