/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.gameevent.TickEvent;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.fzds.DeltaChunk;
import factorization.shared.Core;
import java.io.File;
import java.util.HashMap;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class HammerInfo {
    static File worldConfigFile = null;
    static Configuration channelConfig;
    static Configuration worldState;
    static int dimension_slice_dimid;
    private int unsaved_allocations = 0;
    private boolean channel_config_dirty = false;
    boolean world_loaded = false;
    HashMap<Integer, ConfigCategory> channel2category = new HashMap();
    private static final int defaultPadding = 64;
    private int ticks = 0;

    void setConfigFile(File f) {
        channelConfig = new Configuration(f);
        String rem = "The dimension used for FZDS/Hammer/Colossi/rotated/moving blocks, etc.\nIf things go really south with those features, as a last resort you can try deleting this dimension.\nBut first see if you can use the /fzds to fix it.";
        dimension_slice_dimid = channelConfig.getInt("FzdsDimension", "Hammer", dimension_slice_dimid, Integer.MIN_VALUE, Integer.MAX_VALUE, "The dimension used for FZDS/Hammer/Colossi/rotated/moving blocks, etc.\nIf things go really south with those features, as a last resort you can try deleting this dimension.\nBut first see if you can use the /fzds to fix it.");
        this.saveChannelConfig();
    }

    void loadGlobalConfig() {
        if (worldState != null) {
            return;
        }
        WorldServer world = (WorldServer)DeltaChunk.getServerShadowWorld();
        this.world_loaded = true;
        File saveDir = world.getChunkSaveLocation();
        saveDir = saveDir.getAbsoluteFile();
        worldConfigFile = new File(saveDir, "hammer.state");
        worldState = new Configuration(worldConfigFile);
        this.saveChannelConfig();
    }

    public int makeChannelFor(String modName, String channelName, int default_channel_id, int padding, String comment) {
        if (padding < 0) {
            padding = 64;
        }
        if (channelConfig == null) {
            throw new IllegalArgumentException("Tried to register channel too early");
        }
        Core.logFine("Allocating Hammer channel for %s: %s", modName, comment);
        String modCategory = ("hammerChannels." + modName + "." + channelName).toLowerCase();
        int max = default_channel_id;
        boolean collision = false;
        for (String categoryName : channelConfig.getCategoryNames()) {
            ConfigCategory cat = channelConfig.getCategory(categoryName);
            if (cat.equals((Object)modCategory) || !cat.containsKey("channel")) continue;
            int here_chan = channelConfig.get(categoryName, "channel", -1).getInt();
            max = Math.max(max, here_chan);
            if (here_chan != default_channel_id) continue;
            collision = true;
        }
        if (collision) {
            int newDefault = max + 1;
            Core.logFine("Default channel ID for %s (%s) was already taken, using %s", modCategory, default_channel_id, newDefault);
            default_channel_id = newDefault;
        }
        channelConfig.addCustomCategoryComment(modCategory, comment);
        int channelRet = channelConfig.get(modCategory, "channel", default_channel_id).getInt();
        padding = channelConfig.get(modCategory, "padding", padding).getInt();
        if (this.world_loaded) {
            this.saveChannelConfig();
        } else {
            this.channel_config_dirty = true;
        }
        this.channel2category.put(channelRet, channelConfig.getCategory(modCategory));
        return channelRet;
    }

    public int getPaddingForChannel(int channel) {
        ConfigCategory cat = this.channel2category.get(channel);
        if (cat == null) {
            return 64;
        }
        Property prop = cat.get("padding");
        int ret = prop.getInt(64);
        return ret;
    }

    int roundToChunk(int n) {
        if (++n % 16 == 0) {
            return n;
        }
        return (n / 16 + 1) * 16;
    }

    Coord takeCell(int channel, DeltaCoord size) {
        this.loadGlobalConfig();
        Property chanAllocs = worldState.get("allocations", "channel" + channel, 0);
        int start = this.roundToChunk(chanAllocs.getInt(0));
        int add = size.x + this.getPaddingForChannel(channel);
        chanAllocs.set(Integer.toString(start + add));
        Coord ret = new Coord(DeltaChunk.getServerShadowWorld(), start, 16, this.roundToChunk(channel * 800));
        this.dirtyCellAllocations();
        return ret;
    }

    public void setAllocationCount(int channel, int count) {
        this.loadGlobalConfig();
        ConfigCategory cat = this.channel2category.get(channel);
        cat.get("allocated").set(count);
        this.saveCellAllocations();
    }

    File getWorldSaveFile() {
        World hammerWorld = DeltaChunk.getServerShadowWorld();
        File base = new File(hammerWorld.func_72860_G().func_75760_g());
        return new File(base, "deltaChunk.cfg");
    }

    public void dirtyCellAllocations() {
        if (this.unsaved_allocations == 0) {
            this.saveCellAllocations();
        }
        ++this.unsaved_allocations;
    }

    @Mod.EventHandler
    public void tickCellSaving(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.ticks++ < 100) {
            return;
        }
        this.ticks = 0;
        this.saveCellAllocations();
    }

    public void saveCellAllocations() {
        if (this.channel_config_dirty) {
            channelConfig.save();
            this.channel_config_dirty = false;
        }
        if (worldState == null) {
            return;
        }
        worldState.save();
        this.unsaved_allocations = 0;
    }

    public void saveChannelConfig() {
        if (channelConfig.hasChanged()) {
            channelConfig.save();
        }
    }

    static {
        dimension_slice_dimid = -7;
    }
}

