/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.IFzdsShenanigans;
import factorization.fzds.interfaces.Interpolation;
import factorization.shared.Core;
import factorization.util.PlayerUtil;
import factorization.util.SpaceUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ItemInWorldManager;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.world.BlockEvent;

public class HammerNet {
    public static HammerNet instance;
    public static final String channelName = "FZDS|Interact";
    public static FMLEventChannel channel;
    private boolean dont_check_range = true;
    private IDeltaChunk active_idc = null;

    public HammerNet() {
        instance = this;
        channel.register((Object)this);
        Core.loadBus(this);
    }

    @SubscribeEvent
    public void messageFromServer(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityPlayer player = Core.proxy.getClientPlayer();
        try {
            this.handleMessageFromServer(player, event.packet.payload());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleMessageFromServer(EntityPlayer player, ByteBuf dis) throws IOException {
        if (player == null || player.field_70170_p == null) {
            return;
        }
        World world = player.field_70170_p;
        byte type = dis.readByte();
        int dse_id = dis.readInt();
        Entity ent = world.func_73045_a(dse_id);
        DimensionSliceEntity dse = null;
        if (!(ent instanceof DimensionSliceEntity)) {
            Core.logWarning("Packet %s to non-DSE (ID=%s) %s", type, dse_id, ent);
            return;
        }
        dse = (DimensionSliceEntity)ent;
        switch (type) {
            case 0: {
                this.setRotation(dis, dse);
                break;
            }
            case 1: {
                this.setRotationalVelocity(dis, dse);
                break;
            }
            case 2: {
                this.setRotation(dis, dse);
                this.setRotationalVelocity(dis, dse);
                break;
            }
            case 10: {
                this.setCenterOffset(dis, dse);
                break;
            }
            case 11: {
                dse.func_70107_b(dis.readDouble(), dis.readDouble(), dis.readDouble());
                dse.field_70159_w = dis.readDouble();
                dse.field_70181_x = dis.readDouble();
                dse.field_70179_y = dis.readDouble();
                break;
            }
            case 12: {
                Quaternion rotationStart = Quaternion.read(dis);
                Quaternion rotationEnd = Quaternion.read(dis);
                int orderTime = dis.readInt();
                byte interpIndex = dis.readByte();
                Interpolation interp = Interpolation.values()[interpIndex];
                if (orderTime < 0) {
                    dse.cancelOrderedRotation();
                    break;
                }
                dse.setRotation(rotationStart);
                dse.orderTargetRotation(rotationEnd, orderTime, interp);
            }
        }
    }

    void setRotation(ByteBuf dis, DimensionSliceEntity dse) throws IOException {
        Quaternion q = Quaternion.read(dis);
        if (dse != null) {
            dse.setRotation(q);
        }
    }

    void setRotationalVelocity(ByteBuf dis, DimensionSliceEntity dse) throws IOException {
        Quaternion q = Quaternion.read(dis);
        if (dse != null) {
            dse.setRotationalVelocity(q);
        }
    }

    void setCenterOffset(ByteBuf dis, DimensionSliceEntity dse) throws IOException {
        double x = dis.readDouble();
        double y = dis.readDouble();
        double z = dis.readDouble();
        Vec3 vec = Vec3.func_72443_a((double)x, (double)y, (double)z);
        dse.setRotationalCenterOffset(vec);
    }

    @SubscribeEvent
    public void messageFromClient(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        try {
            this.handleMessageFromClient(player, event.packet.payload());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMessageFromClient(EntityPlayerMP player, ByteBuf dis) throws IOException {
        byte type = dis.readByte();
        int dse_id = dis.readInt();
        Entity ent = player.field_70170_p.func_73045_a(dse_id);
        if (!(ent instanceof IDeltaChunk)) {
            throw new IOException("Did not select a DimensionSliceEntity (id = " + dse_id + ", messageType = " + type + ")");
        }
        DimensionSliceEntity idc = (DimensionSliceEntity)ent;
        if (!(idc.can(DeltaCapability.INTERACT) || type != 9 && type != 8 && type != 7 && type != 5 && type != 6)) {
            Core.logWarning("%s tried to interact with IDC that doesn't permit that %s", player, idc);
            return;
        }
        if (type == 9 || type == 8 || type == 7) {
            if (!idc.can(DeltaCapability.BLOCK_MINE)) {
                Core.logWarning("%s tried to mine IDC that doesn't permit that %s", player, idc);
                return;
            }
            int x = dis.readInt();
            int y = dis.readInt();
            int z = dis.readInt();
            byte sideHit = dis.readByte();
            if (type == 9) {
                this.breakBlock(idc, player, dis, x, y, z, sideHit);
            } else if (type == 7) {
                this.punchBlock(idc, player, dis, x, y, z, sideHit);
            }
            idc.blocksChanged(x, y, z);
        } else if (type == 5) {
            if (!idc.can(DeltaCapability.BLOCK_PLACE)) {
                Core.logWarning("%s tried to use an item on IDC that doesn't permit that %s", player, idc);
                return;
            }
            int x = dis.readInt();
            int y = dis.readInt();
            int z = dis.readInt();
            byte sideHit = dis.readByte();
            float vecX = dis.readFloat();
            float vecY = dis.readFloat();
            float vecZ = dis.readFloat();
            try {
                this.dont_check_range = false;
                this.active_idc = idc;
                this.clickBlock(idc, player, x, y, z, sideHit, vecX, vecY, vecZ);
            }
            finally {
                this.dont_check_range = true;
                this.active_idc = null;
            }
            idc.blocksChanged(x, y, z);
        } else if (type == 6) {
            int x = dis.readInt();
            int y = dis.readInt();
            int z = dis.readInt();
            byte sideHit = dis.readByte();
            float vecX = dis.readFloat();
            float vecY = dis.readFloat();
            float vecZ = dis.readFloat();
            this.leftClickBlock(idc, player, dis, x, y, z, sideHit, vecX, vecY, vecZ);
        } else {
            Core.logWarning("%s tried to send an unknown packet %s to IDC %s", player, type, idc);
        }
    }

    @SubscribeEvent
    public void cancelOutOfRangePlacements(BlockEvent.PlaceEvent event) {
        if (this.dont_check_range) {
            return;
        }
        if (this.active_idc == null) {
            return;
        }
        Coord min = this.active_idc.getCorner();
        if (event.world != min.w) {
            return;
        }
        Coord max = this.active_idc.getFarCorner();
        if (this.in(min.x, event.x, max.x) && this.in(min.y, event.y, max.y) && this.in(min.z, event.z, max.z)) {
            return;
        }
        event.setCanceled(true);
    }

    boolean in(int low, int i, int high) {
        return low <= i && i <= high;
    }

    boolean blockInReach(IDeltaChunk idc, EntityPlayerMP player, Coord at) {
        double reach_distance = player.field_71134_c.getBlockReachDistance();
        Vec3 playerAt = SpaceUtil.fromEntPos((Entity)player);
        playerAt = idc.real2shadow(playerAt);
        double distance = at.createVector().func_72438_d(playerAt);
        return distance <= reach_distance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void breakBlock(IDeltaChunk idc, EntityPlayerMP player, ByteBuf dis, int x, int y, int z, byte sideHit) {
        Coord at = new Coord(DeltaChunk.getServerShadowWorld(), x, y, z);
        if (at.isAir()) {
            return;
        }
        if (!this.blockInReach(idc, player, at)) {
            return;
        }
        if (idc.getController().breakBlock(idc, (EntityPlayer)player, at, sideHit)) {
            return;
        }
        World origWorld = player.field_71134_c.field_73092_a;
        player.field_71134_c.field_73092_a = DeltaChunk.getServerShadowWorld();
        try {
            player.field_71134_c.func_73084_b(at.x, at.y, at.z);
        }
        finally {
            player.field_71134_c.field_73092_a = origWorld;
        }
    }

    void punchBlock(IDeltaChunk idc, EntityPlayerMP player, ByteBuf dis, int x, int y, int z, byte sideHit) {
        Coord at = new Coord(DeltaChunk.getServerShadowWorld(), x, y, z);
        if (at.isAir()) {
            return;
        }
        if (!this.blockInReach(idc, player, at)) {
            return;
        }
        if (idc.getController().hitBlock(idc, (EntityPlayer)player, at, sideHit)) {
            return;
        }
        Block block = at.getBlock();
        WorldServer shadow_world = (WorldServer)DeltaChunk.getServerShadowWorld();
        InteractionLiason liason = this.getLiason(shadow_world, (EntityPlayer)player);
        block.func_149699_a((World)shadow_world, x, y, z, (EntityPlayer)liason);
        liason.finishUsingLiason();
    }

    void leftClickBlock(IDeltaChunk idc, EntityPlayerMP player, ByteBuf dis, int x, int y, int z, byte sideHit, float vecX, float vecY, float vecZ) {
        Coord at = new Coord(DeltaChunk.getServerShadowWorld(), x, y, z);
        if (at.isAir()) {
            return;
        }
        if (!this.blockInReach(idc, player, at)) {
            return;
        }
        if (idc.getController().hitBlock(idc, (EntityPlayer)player, at, sideHit)) {
            return;
        }
        Block block = at.getBlock();
        block.func_149699_a(at.w, x, y, z, (EntityPlayer)player);
    }

    InteractionLiason getLiason(WorldServer shadowWorld, EntityPlayer real_player) {
        InteractionLiason liason = new InteractionLiason(shadowWorld, new ItemInWorldManager((World)shadowWorld));
        liason.field_71071_by = real_player.field_71071_by;
        liason.func_70031_b(real_player.func_70051_ag());
        liason.func_70095_a(real_player.func_70093_af());
        liason.field_71075_bZ = real_player.field_71075_bZ;
        return liason;
    }

    private boolean do_click(WorldServer world, EntityPlayerMP player, int x, int y, int z, byte sideHit, float vecX, float vecY, float vecZ) {
        ItemBlock itemblock;
        ItemStack is = player.func_70694_bm();
        if (is != null && is.func_77973_b().onItemUseFirst(is, (EntityPlayer)player, (World)world, x, y, z, (int)sideHit, vecX, vecY, vecZ)) {
            return true;
        }
        boolean ret = false;
        if (!player.func_70093_af() || player.func_70694_bm() == null || player.func_70694_bm().func_77973_b().doesSneakBypassUse((World)world, x, y, z, (EntityPlayer)player)) {
            ret = world.func_147439_a(x, y, z).func_149727_a((World)world, x, y, z, (EntityPlayer)player, (int)sideHit, vecX, vecY, vecZ);
        }
        if (!ret && is != null && is.func_77973_b() instanceof ItemBlock && !(itemblock = (ItemBlock)is.func_77973_b()).func_150936_a((World)world, x, y, z, (int)sideHit, (EntityPlayer)player, is)) {
            return false;
        }
        if (ret) {
            return true;
        }
        if (is == null) {
            return false;
        }
        if (PlayerUtil.isPlayerCreative((EntityPlayer)player)) {
            int j1 = is.func_77960_j();
            int i1 = is.field_77994_a;
            boolean flag1 = is.func_77943_a((EntityPlayer)player, (World)world, x, y, z, (int)sideHit, vecX, vecY, vecZ);
            is.func_77964_b(j1);
            is.field_77994_a = i1;
            return flag1;
        }
        if (!is.func_77943_a((EntityPlayer)player, (World)world, x, y, z, (int)sideHit, vecX, vecY, vecZ)) {
            return false;
        }
        if (is.field_77994_a <= 0) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent((EntityPlayer)player, is));
        }
        return true;
    }

    void clickBlock(IDeltaChunk idc, EntityPlayerMP real_player, int x, int y, int z, byte sideHit, float vecX, float vecY, float vecZ) throws IOException {
        WorldServer shadowWorld = (WorldServer)DeltaChunk.getServerShadowWorld();
        Coord at = new Coord((World)shadowWorld, x, y, z);
        if (at.isAir()) {
            return;
        }
        if (!this.blockInReach(idc, real_player, at)) {
            return;
        }
        if (idc.getController().useBlock(idc, (EntityPlayer)real_player, at, sideHit)) {
            return;
        }
        InteractionLiason liason = this.getLiason(shadowWorld, (EntityPlayer)real_player);
        try {
            this.do_click(shadowWorld, liason, x, y, z, sideHit, vecX, vecY, vecZ);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        liason.finishUsingLiason();
    }

    static FMLProxyPacket makePacket(byte type, Object ... items) {
        ByteArrayDataOutput dos = ByteStreams.newDataOutput();
        dos.writeByte((int)type);
        for (int i = 0; i < items.length; ++i) {
            Object obj = items[i];
            if (obj instanceof Quaternion) {
                ((Quaternion)obj).write(dos);
                continue;
            }
            if (obj instanceof Integer) {
                dos.writeInt(((Integer)obj).intValue());
                continue;
            }
            if (obj instanceof Byte) {
                dos.writeByte((int)((Byte)obj).byteValue());
                continue;
            }
            if (obj instanceof Float) {
                dos.writeFloat(((Float)obj).floatValue());
                continue;
            }
            if (obj instanceof Double) {
                dos.writeDouble(((Double)obj).doubleValue());
                continue;
            }
            if (obj instanceof MovingObjectPosition) {
                MovingObjectPosition mop = (MovingObjectPosition)obj;
                dos.writeInt(mop.field_72311_b);
                dos.writeInt(mop.field_72312_c);
                dos.writeInt(mop.field_72309_d);
                dos.writeByte((int)((byte)mop.field_72310_e));
                continue;
            }
            if (obj instanceof Vec3) {
                Vec3 vec = (Vec3)obj;
                dos.writeDouble(vec.field_72450_a);
                dos.writeDouble(vec.field_72448_b);
                dos.writeDouble(vec.field_72449_c);
                continue;
            }
            throw new IllegalArgumentException("Can only do Quaternions/Integers/Bytes/Floats/Doubles/MovingObjectPosition/Vec3! Not " + obj);
        }
        return new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])dos.toByteArray()), channelName);
    }

    static {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelName);
    }

    static class InteractionLiason
    extends EntityPlayerMP
    implements IFzdsShenanigans {
        private static final GameProfile liasonGameProfile = new GameProfile(null, "[FzdsInteractionLiason]");
        InventoryPlayer original_inventory;

        public InteractionLiason(WorldServer world, ItemInWorldManager itemManager) {
            super(MinecraftServer.func_71276_C(), world, liasonGameProfile, itemManager);
            this.original_inventory = this.field_71071_by;
        }

        void finishUsingLiason() {
            this.field_71071_by = this.original_inventory;
        }
    }

    public static class HammerNetType {
        public static final byte rotation = 0;
        public static final byte rotationVelocity = 1;
        public static final byte rotationBoth = 2;
        public static final byte rotationCenterOffset = 10;
        public static final byte exactPositionAndMotion = 11;
        public static final byte orderedRotation = 12;
        public static final byte rightClickEntity = 3;
        public static final byte leftClickEntity = 4;
        public static final byte rightClickBlock = 5;
        public static final byte leftClickBlock = 6;
        public static final byte digStart = 7;
        public static final byte digProgress = 8;
        public static final byte digFinish = 9;
    }
}

