/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import factorization.fzds.DeltaChunk;
import factorization.fzds.Hammer;
import java.util.List;
import java.util.Set;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;

public class PPPChunkLoader
implements ForgeChunkManager.LoadingCallback {
    static PPPChunkLoader instance;

    PPPChunkLoader() {
        instance = this;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    public ForgeChunkManager.Ticket register(Set<Chunk> chunkSet) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)Hammer.instance, (World)DeltaChunk.getServerShadowWorld(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            Hammer.logSevere("Failed to acquire chunk ticket. You may need to adjust config/forgeChunkLoading.cfg", new Object[0]);
            return null;
        }
        int maxSize = ticket.getMaxChunkListDepth();
        int size = chunkSet.size();
        if (size > maxSize) {
            Hammer.logSevere("Registering %s chunks for loading, but ticket only has room for %s. You may need to adjust config/forgeChunkLoading.cfg", size, maxSize);
        }
        for (Chunk chunk : chunkSet) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk.func_76632_l());
        }
        return ticket;
    }

    public void release(ForgeChunkManager.Ticket ticket) {
        if (ticket == null) {
            return;
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
    }
}

