/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.Hammer;
import factorization.fzds.PPPChunkLoader;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.IFzdsEntryControl;
import factorization.fzds.interfaces.IFzdsShenanigans;
import factorization.fzds.network.WrappedPacket;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S26PacketMapChunkBulk;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ItemInWorldManager;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;

public class PacketProxyingPlayer
extends EntityPlayerMP
implements IFzdsEntryControl,
IFzdsShenanigans {
    WeakReference<DimensionSliceEntity> dimensionSlice = new WeakReference<Object>(null);
    static boolean useShortViewRadius = true;
    private HashSet<EntityPlayerMP> trackedPlayers = new HashSet();
    EmbeddedChannel proxiedChannel = new EmbeddedChannel(new ChannelHandler[]{new WrappedMulticastHandler()});
    NetworkManager networkManager = new ProxyingNetworkManager();
    static final Throwable generic_future_failure = new UnsupportedOperationException("Sorry!");
    ForgeChunkManager.Ticket ticket = null;
    private static final UUID proxyUuid = UUID.fromString("69f64f92-665f-457e-ad33-f6082d0b8a75");
    private int ticks_since_last_update = 0;
    static final ArrayList empty = new ArrayList();
    boolean canDie = false;
    FMLEmbeddedChannel wrapper_channel = new FMLEmbeddedChannel("?", Side.SERVER, new ChannelHandler[]{new ChannelHandler(){

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        }

        @Deprecated
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        }
    }});

    void initWrapping() {
        this.field_71135_a = new NetHandlerPlayServer(this.field_71133_b, this.networkManager, (EntityPlayerMP)this);
        this.field_71135_a.field_147371_a.channel().attr(NetworkDispatcher.FML_DISPATCHER).set((Object)new NetworkDispatcher(this.networkManager));
        this.field_71135_a.field_147371_a.func_150723_a(EnumConnectionState.PLAY);
        this.registerChunkLoading();
    }

    void registerChunkLoading() {
        this.ticket = PPPChunkLoader.instance.register(this.getChunks());
    }

    void releaseChunkLoading() {
        if (this.ticket != null) {
            PPPChunkLoader.instance.release(this.ticket);
            this.ticket = null;
        }
    }

    private Set<Chunk> getChunks() {
        final HashSet<Chunk> ret = new HashSet<Chunk>();
        DimensionSliceEntity dse = (DimensionSliceEntity)this.dimensionSlice.get();
        if (dse == null) {
            return ret;
        }
        Coord min = dse.getCorner();
        Coord max = dse.getFarCorner();
        Coord.iterateChunks(min, max, new ICoordFunction(){

            @Override
            public void handle(Coord here) {
                ret.add(here.getChunk());
            }
        });
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketProxyingPlayer(DimensionSliceEntity dimensionSlice, World shadowWorld) {
        super(MinecraftServer.func_71276_C(), (WorldServer)shadowWorld, new GameProfile(proxyUuid, "[FzdsPacket]"), new ItemInWorldManager(shadowWorld));
        this.field_83001_bt = true;
        this.field_70178_ae = true;
        this.initWrapping();
        this.dimensionSlice = new WeakReference<DimensionSliceEntity>(dimensionSlice);
        Coord c = dimensionSlice.getCenter();
        c.y = -8;
        c.setAsEntityLocation((Entity)this);
        ServerConfigurationManager scm = MinecraftServer.func_71276_C().func_71203_ab();
        if (useShortViewRadius) {
            int orig = this.savePlayerViewRadius();
            this.restorePlayerViewRadius(3);
            try {
                scm.func_72375_a((EntityPlayerMP)this, null);
            }
            finally {
                this.restorePlayerViewRadius(orig);
            }
        } else {
            scm.func_72375_a((EntityPlayerMP)this, null);
        }
        this.ticks_since_last_update = (int)(Math.random() * 20.0);
    }

    int savePlayerViewRadius() {
        return this.func_71121_q().func_73040_p().field_72698_e;
    }

    void restorePlayerViewRadius(int orig) {
        if (orig == -1) {
            return;
        }
        this.func_71121_q().func_73040_p().field_72698_e = orig;
    }

    public void func_70071_h_() {
        DimensionSliceEntity dse = (DimensionSliceEntity)this.dimensionSlice.get();
        if (dse == null || dse.field_70128_L) {
            this.endProxy();
        } else if (this.ticks_since_last_update > 0) {
            --this.ticks_since_last_update;
        } else if (!this.field_70170_p.field_72995_K) {
            this.ticks_since_last_update = 20;
            List playerList = this.getTargetablePlayers();
            for (int i = 0; i < playerList.size(); ++i) {
                Object o = playerList.get(i);
                if (!(o instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)o;
                if (this.isPlayerInUpdateRange(player)) {
                    boolean new_player = this.trackedPlayers.add(player);
                    if (!new_player || !this.shouldShareChunks()) continue;
                    this.sendChunkMapDataToPlayer(player);
                    continue;
                }
                this.trackedPlayers.remove(player);
            }
        }
        super.func_70071_h_();
    }

    List getTargetablePlayers() {
        DimensionSliceEntity dse = (DimensionSliceEntity)this.dimensionSlice.get();
        if (dse == null) {
            return empty;
        }
        return dse.field_70170_p.field_73010_i;
    }

    boolean isPlayerInUpdateRange(EntityPlayerMP player) {
        DimensionSliceEntity dse = (DimensionSliceEntity)this.dimensionSlice.get();
        if (dse == null) {
            return false;
        }
        return !player.field_70128_L && dse.func_70068_e((Entity)player) <= Hammer.DSE_ChunkUpdateRangeSquared;
    }

    boolean shouldShareChunks() {
        return true;
    }

    void sendChunkMapDataToPlayer(EntityPlayerMP target) {
        DimensionSliceEntity dse = (DimensionSliceEntity)this.dimensionSlice.get();
        if (dse == null) {
            return;
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        ArrayList tileEntities = new ArrayList();
        World world = DeltaChunk.getServerShadowWorld();
        Coord low = dse.getCorner();
        Coord far = dse.getFarCorner();
        for (int x = low.x - 16; x <= far.x + 16; x += 16) {
            for (int z = low.z - 16; z <= far.z + 16; z += 16) {
                if (!world.func_72899_e(x + 1, 0, z + 1)) continue;
                Chunk chunk = world.func_72938_d(x, z);
                chunks.add(chunk);
                tileEntities.addAll(chunk.field_150816_i.values());
            }
        }
        if (!chunks.isEmpty()) {
            S26PacketMapChunkBulk toSend = new S26PacketMapChunkBulk(chunks);
            this.addNettyMessageForPlayer(target, new WrappedPacket((Packet)toSend));
        }
        if (!tileEntities.isEmpty()) {
            for (TileEntity te : tileEntities) {
                Packet description = te.func_145844_m();
                if (description == null) continue;
                this.addNettyMessageForPlayer(target, new WrappedPacket(description));
            }
        }
    }

    public void endProxy() {
        this.releaseChunkLoading();
        WorldServer var2 = this.func_71121_q();
        var2.func_72900_e((Entity)this);
        var2.func_73040_p().func_72695_c((EntityPlayerMP)this);
        MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.remove(this.field_71135_a);
        this.canDie = true;
        this.func_70106_y();
        this.dimensionSlice.clear();
    }

    boolean shouldForceChunkLoad() {
        return !this.trackedPlayers.isEmpty();
    }

    public Packet wrapMessage(Object msg) {
        if (msg instanceof Packet) {
            return new WrappedPacket((Packet)msg);
        }
        Packet pkt = this.wrapper_channel.generatePacketFrom(msg);
        return new WrappedPacket(pkt);
    }

    public void addNettyMessage(Channel sourceChannel, Object msg) {
        if (this.trackedPlayers.isEmpty()) {
            return;
        }
        DimensionSliceEntity dse = (DimensionSliceEntity)this.dimensionSlice.get();
        if (dse == null || dse.field_70128_L) {
            this.func_70106_y();
            return;
        }
        Packet wrappedMsg = this.wrapMessage(msg);
        Iterator<EntityPlayerMP> it = this.trackedPlayers.iterator();
        while (it.hasNext()) {
            EntityPlayerMP player = it.next();
            if (player.field_70128_L || player.field_70170_p != dse.field_70170_p) {
                it.remove();
                continue;
            }
            this.addNettyMessageForPlayer(player, wrappedMsg);
        }
    }

    void addNettyMessageForPlayer(EntityPlayerMP player, Object packet) {
        if (player instanceof PacketProxyingPlayer) {
            throw new IllegalStateException("Sending a packet to myself!");
        }
        player.field_71135_a.func_147359_a((Packet)packet);
    }

    public void func_70106_y() {
        if (this.canDie) {
            super.func_70106_y();
        }
    }

    @Override
    public boolean canEnter(IDeltaChunk dse) {
        return false;
    }

    @Override
    public boolean canExit(IDeltaChunk dse) {
        return false;
    }

    @Override
    public void onEnter(IDeltaChunk dse) {
    }

    @Override
    public void onExit(IDeltaChunk dse) {
    }

    class WrappedMulticastHandler
    extends ChannelOutboundHandlerAdapter
    implements IFzdsShenanigans {
        WrappedMulticastHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            PacketProxyingPlayer.this.addNettyMessage((Channel)PacketProxyingPlayer.this.proxiedChannel, msg);
        }
    }

    class ProxyingNetworkManager
    extends NetworkManager
    implements IFzdsShenanigans {
        public ProxyingNetworkManager() {
            super(false);
            this.field_150746_k = PacketProxyingPlayer.this.proxiedChannel;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            throw new IllegalArgumentException("No, go away");
        }

        public void func_150723_a(EnumConnectionState state) {
            if (state != EnumConnectionState.PLAY) {
                throw new IllegalArgumentException("No solicitors!");
            }
            super.func_150723_a(state);
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            throw new IllegalArgumentException("Blllauergh!");
        }
    }
}

