/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import factorization.api.Coord;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.Hammer;
import factorization.fzds.RenderDimensionSliceEntity;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.util.NumUtil;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;

class ShadowRenderGlobal
implements IWorldAccess {
    private World realWorld;
    HashMap<Integer, DestroyBlockProgress> damagedBlocks = new HashMap();
    int tickTime = 0;

    public ShadowRenderGlobal(World realWorld) {
        this.realWorld = realWorld;
    }

    public void func_147586_a(int var1, int var2, int var3) {
        this.markBlocksForUpdate(var1 - 1, var2 - 1, var3 - 1, var1 + 1, var2 + 1, var3 + 1);
    }

    public void func_147588_b(int var1, int var2, int var3) {
        this.markBlocksForUpdate(var1 - 1, var2 - 1, var3 - 1, var1 + 1, var2 + 1, var3 + 1);
    }

    public void func_147585_a(int var1, int var2, int var3, int var4, int var5, int var6) {
        this.markBlocksForUpdate(var1 - 1, var2 - 1, var3 - 1, var4 + 1, var5 + 1, var6 + 1);
    }

    void markBlocksForUpdate(int lx, int ly, int lz, int hx, int hy, int hz) {
        World realClientWorld = DeltaChunk.getClientRealWorld();
        for (IDeltaChunk idc : DeltaChunk.getSlicesInRange(realClientWorld, lx, ly, lz, hx, hy, hz)) {
            DimensionSliceEntity dse = (DimensionSliceEntity)idc;
            Coord near = dse.getCorner();
            Coord far = dse.getFarCorner();
            if (!NumUtil.intersect(near.x, far.x, lx, hx) || !NumUtil.intersect(near.y, far.y, ly, hy) || !NumUtil.intersect(near.z, far.z, lz, hz)) continue;
            RenderDimensionSliceEntity.markBlocksForUpdate(dse, lx, ly, lz, hx, hy, hz);
            dse.blocksChanged(lx, ly, lz);
            dse.blocksChanged(hx, hy, hz);
        }
    }

    public void func_72704_a(String sound2, double x, double y, double z, float volume, float pitch) {
        Vec3 realCoords = DeltaChunk.shadow2nearestReal((Entity)Minecraft.func_71410_x().field_71439_g, x, y, z);
        if (realCoords == null) {
            return;
        }
        this.realWorld.func_72980_b(realCoords.field_72450_a, realCoords.field_72448_b, realCoords.field_72449_c, sound2, volume, pitch, false);
    }

    public void func_85102_a(EntityPlayer entityplayer, String sound2, double x, double y, double z, float volume, float pitch) {
        if (entityplayer != Minecraft.func_71410_x().field_71439_g) {
            this.func_72704_a(sound2, x, y, z, volume, pitch);
        }
    }

    public void func_72702_a(String recordName, int x, int y, int z) {
        Vec3 realCoords = DeltaChunk.shadow2nearestReal((Entity)Minecraft.func_71410_x().field_71439_g, x, y, z);
        if (realCoords == null) {
            return;
        }
        Minecraft.func_71410_x().field_71438_f.func_72702_a(recordName, (int)realCoords.field_72450_a, (int)realCoords.field_72448_b, (int)realCoords.field_72449_c);
    }

    public void func_82746_a(int soundType, int x, int y, int z, int type) {
        Coord here = new Coord(DeltaChunk.getClientShadowWorld(), x, y, z);
        for (IDeltaChunk idc : DeltaChunk.getSlicesContainingPoint(here)) {
            Coord at = here.copy();
            idc.shadow2real(at);
            at.w.func_82739_e(soundType, x, y, z, type);
        }
    }

    public void func_72706_a(EntityPlayer player, int soundType, int x, int y, int z, int soundData) {
        Coord here = new Coord(DeltaChunk.getClientShadowWorld(), x, y, z);
        for (IDeltaChunk idc : DeltaChunk.getSlicesContainingPoint(here)) {
            Coord at = here.copy();
            idc.shadow2real(at);
            at.w.func_72889_a(player, soundType, at.x, at.y, at.z, soundData);
        }
    }

    public void func_72708_a(String particle, double x, double y, double z, double vx, double vy, double vz) {
        Vec3 realCoords = DeltaChunk.shadow2nearestReal((Entity)Minecraft.func_71410_x().field_71439_g, x, y, z);
        if (realCoords == null) {
            return;
        }
        if (!Hammer.proxy.isInShadowWorld()) {
            this.realWorld.func_72869_a(particle, realCoords.field_72450_a, realCoords.field_72448_b, realCoords.field_72449_c, vx, vy, vz);
        } else {
            Hammer.proxy.restoreRealWorld();
            this.realWorld.func_72869_a(particle, realCoords.field_72450_a, realCoords.field_72448_b, realCoords.field_72449_c, vx, vy, vz);
            Hammer.proxy.setShadowWorld();
        }
    }

    public void func_72703_a(Entity entity) {
        Minecraft.func_71410_x().field_71438_f.func_72703_a(entity);
    }

    public void func_72709_b(Entity entity) {
        Minecraft.func_71410_x().field_71438_f.func_72709_b(entity);
    }

    public void func_147587_b(int breakerId, int blockX, int blockY, int blockZ, int damageProgress) {
        if (damageProgress < 0 || damageProgress >= 10) {
            this.damagedBlocks.remove(breakerId);
            return;
        }
        DestroyBlockProgress destroyblockprogress = this.damagedBlocks.get(breakerId);
        if (destroyblockprogress == null || destroyblockprogress.func_73110_b() != blockX || destroyblockprogress.func_73109_c() != blockY || destroyblockprogress.func_73108_d() != blockZ) {
            destroyblockprogress = new DestroyBlockProgress(breakerId, blockX, blockY, blockZ);
            this.damagedBlocks.put(breakerId, destroyblockprogress);
        }
        destroyblockprogress.func_73107_a(damageProgress);
        destroyblockprogress.func_82744_b(this.tickTime);
    }

    public void removeStaleDamage() {
        if (this.tickTime++ % 20 != 0) {
            return;
        }
        Iterator<DestroyBlockProgress> iterator = this.damagedBlocks.values().iterator();
        while (iterator.hasNext()) {
            DestroyBlockProgress destroyblockprogress = iterator.next();
            int createTime = destroyblockprogress.func_82743_f();
            if (this.tickTime - createTime <= 400) continue;
            iterator.remove();
        }
    }

    public void func_147584_b() {
    }
}

