/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import factorization.api.Coord;
import factorization.shared.Core;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class Embarkener {
    int wood_rendertype = Blocks.field_150364_r.func_149645_b();
    ArrayList<EmbarkenEvent> embarkenQueue = new ArrayList();

    public Embarkener() {
        this.addLogBarkRecipes();
    }

    boolean isWoodish(Block block) {
        if (block == null) {
            return false;
        }
        return block.func_149688_o() == Material.field_151575_d && block instanceof BlockLog && block.func_149645_b() == this.wood_rendertype;
    }

    void addLogBarkRecipes() {
        int count = 0;
        for (Block block : Block.field_149771_c) {
            if (!this.isWoodish(block)) continue;
            for (int md = 0; md < 4; ++md) {
                ++count;
                ItemStack log = new ItemStack(block, 1, md);
                ItemStack barked = new ItemStack(block, 4, md | 0xC);
                barked.func_151001_c("Bark");
                Core.registry.vanillaShapelessRecipe(barked, log, log, log, log);
                ItemStack barked1 = barked.func_77946_l();
                barked1.field_77994_a = 1;
                Core.registry.vanillaShapelessRecipe(log, barked1);
            }
        }
        Core.logInfo("Added %s 'barking' recipes for blocks that look sort of like wood logs; this can be disabled in the config file.", count);
    }

    @SubscribeEvent
    public void enbarkenWood(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.entityPlayer == null) {
            return;
        }
        ItemStack is = event.entityPlayer.func_70694_bm();
        if (is == null) {
            return;
        }
        if ((is.func_77960_j() & 0xC) != 12) {
            return;
        }
        if (!(is.func_77973_b() instanceof ItemBlock)) {
            return;
        }
        Block theBlock = Block.func_149634_a((Item)is.func_77973_b());
        if (!this.isWoodish(theBlock)) {
            return;
        }
        Coord target = new Coord(event.entityPlayer.field_70170_p, event.x, event.y, event.z);
        target.adjust(ForgeDirection.getOrientation((int)event.face));
        if (!target.isReplacable()) {
            return;
        }
        this.embarkenQueue.add(new EmbarkenEvent(target, is.field_77994_a, is, event.entityPlayer, (BlockLog)theBlock));
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (EmbarkenEvent e : this.embarkenQueue) {
            e.handle();
        }
        this.embarkenQueue.clear();
    }

    static class EmbarkenEvent {
        Coord target;
        int orig_stacksize;
        ItemStack stack;
        EntityPlayer player;
        BlockLog expectedBlock;

        public EmbarkenEvent(Coord target, int orig_stacksize, ItemStack stack, EntityPlayer player, BlockLog expectedBlock) {
            this.target = target;
            this.orig_stacksize = orig_stacksize;
            this.stack = stack;
            this.player = player;
            this.expectedBlock = expectedBlock;
        }

        void handle() {
            if (this.stack.field_77994_a >= this.orig_stacksize) {
                return;
            }
            if (this.player.field_70128_L) {
                return;
            }
            if (!this.target.blockExists()) {
                return;
            }
            if (this.target.getBlock() != this.expectedBlock) {
                return;
            }
            this.target.setMd(this.target.getMd() | 0xC);
        }
    }
}

