/*
 * Decompiled with CFR 0.152.
 */
package factorization.notify;

import factorization.notify.ISaneCoord;
import factorization.notify.NoticeUpdater;
import factorization.notify.NotifyImplementation;
import factorization.notify.SimpleCoord;
import factorization.notify.Style;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Notice {
    final Object where;
    private String message;
    private String[] messageParameters;
    private ItemStack item;
    private EnumSet<Style> style = EnumSet.noneOf(Style.class);
    private NoticeUpdater updater;
    private boolean isUpdating = false;
    private int age = 0;
    private boolean changed = false;
    private boolean changedItem = false;
    private boolean addedToRecurList = false;
    EntityPlayer targetPlayer = null;
    World world;
    private static final String[] emptyStringArray = new String[0];

    public Notice(Object where, String message, String ... messageParameters) {
        this.where = where;
        this.message = message;
        this.messageParameters = messageParameters;
        if (where instanceof ISaneCoord) {
            this.world = ((ISaneCoord)where).w();
        } else if (where instanceof Entity) {
            this.world = ((Entity)where).field_70170_p;
        } else if (where instanceof TileEntity) {
            this.world = ((TileEntity)where).func_145831_w();
        }
    }

    public Notice(Object where, NoticeUpdater updater) {
        this.where = where;
        this.withUpdater(updater);
        updater.update(this);
    }

    public Notice withItem(ItemStack item) {
        if (this.isUpdating && !this.changed) {
            this.cmpIs(this.item, item);
            this.changedItem |= this.changed;
        }
        this.item = item == null ? null : item.func_77946_l();
        return this;
    }

    public Notice withStyle(Style ... styles) {
        boolean addedStyle = false;
        for (Style s : styles) {
            addedStyle |= this.style.add(s);
        }
        if (addedStyle && this.isUpdating) {
            this.changed = true;
        }
        return this;
    }

    public Notice withWorld(World world) {
        this.world = world;
        return this;
    }

    public Notice withUpdater(NoticeUpdater updater) {
        this.updater = updater;
        return this;
    }

    public void setMessage(String newMessage, String ... newMessageParameters) {
        this.cmp(this.message, newMessage);
        if (!this.changed && this.messageParameters != null && newMessageParameters != null) {
            if (this.messageParameters.length != newMessageParameters.length) {
                this.changed = true;
            } else {
                for (int i = 0; i < newMessageParameters.length; ++i) {
                    this.cmp(newMessageParameters[i], this.messageParameters[i]);
                    if (!this.changed) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            this.cmp(this.messageParameters, newMessageParameters);
        }
        this.message = newMessage;
        this.messageParameters = newMessageParameters;
    }

    private void cmp(Object a, Object b) {
        if (a == b) {
            return;
        }
        this.changed = a != null && b != null ? (this.changed |= !a.equals(b)) : (this.changed |= a == b);
    }

    private void cmpIs(ItemStack a, ItemStack b) {
        if (a == b) {
            return;
        }
        this.changed = a != null && b != null ? (this.changed |= !a.func_77969_a(b)) : (this.changed |= a == b);
    }

    boolean isInvalid() {
        int maxAge = 20 * (this.style.contains((Object)Style.LONG) ? 11 : 6);
        if (this.age++ > maxAge) {
            return true;
        }
        if (this.where instanceof Entity) {
            Entity ent = (Entity)this.where;
            if (ent.field_70128_L) {
                return false;
            }
        } else if (this.where instanceof TileEntity) {
            TileEntity te = (TileEntity)this.where;
            if (te.func_145837_r()) {
                return false;
            }
        } else if (this.where instanceof ISaneCoord) {
            ISaneCoord coord = (ISaneCoord)this.where;
            if (!coord.w().func_72899_e(coord.x(), coord.y(), coord.z())) {
                return false;
            }
        } else if (this.where instanceof Vec3 && this.world != null) {
            Vec3 vec = (Vec3)this.where;
            if (!this.world.func_72899_e((int)vec.field_72450_a, (int)vec.field_72448_b, (int)vec.field_72449_c)) {
                return false;
            }
        }
        if (this.targetPlayer != null) {
            return this.targetPlayer.field_70128_L;
        }
        return false;
    }

    public void send(EntityPlayer player) {
        if (this.isUpdating) {
            return;
        }
        if (this.world == null && player != null) {
            this.world = player.field_70170_p;
        }
        NotifyImplementation.instance.doSend(player, this.where, this.world, this.style, this.item, this.message, this.messageParameters);
        this.changed = false;
        this.changedItem = false;
        if (this.updater != null && !this.addedToRecurList) {
            NotifyImplementation.instance.addRecuringNotification(this);
            this.targetPlayer = player;
            this.addedToRecurList = true;
        }
    }

    public void sendTo(EntityPlayer player) {
        this.send(player);
    }

    public void sendToAll() {
        this.send(null);
    }

    public static void clear(EntityPlayer player) {
        SimpleCoord at = new SimpleCoord(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        NotifyImplementation.instance.doSend(player, at, player.field_70170_p, EnumSet.of(Style.CLEAR), null, "", emptyStringArray);
    }

    public static void onscreen(EntityPlayer player, String message, String ... formatArguments) {
        NotifyImplementation.instance.doSendOnscreenMessage(player, message, formatArguments);
    }

    public static void chat(EntityPlayer player, int msgKey, IChatComponent msg) {
        NotifyImplementation.instance.sendReplacableChatMessage(player, msg, msgKey);
    }

    boolean updateNotice() {
        if (this.updater == null) {
            return false;
        }
        if (this.targetPlayer != null && this.targetPlayer.field_70128_L) {
            return false;
        }
        if (this.isUpdating) {
            return false;
        }
        this.isUpdating = true;
        this.updater.update(this);
        this.isUpdating = false;
        if (this.changed) {
            if (this.changedItem) {
                this.style.add(Style.UPDATE);
                this.send(this.targetPlayer);
                this.style.remove((Object)Style.UPDATE);
            } else {
                this.style.add(Style.UPDATE_SAME_ITEM);
                this.send(this.targetPlayer);
                this.style.remove((Object)Style.UPDATE_SAME_ITEM);
            }
            this.changedItem = false;
            this.changed = false;
        }
        return true;
    }
}

