/*
 * Decompiled with CFR 0.152.
 */
package factorization.notify;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import factorization.notify.ISaneCoord;
import factorization.notify.MutterCommand;
import factorization.notify.Notice;
import factorization.notify.NotifyNetwork;
import factorization.notify.PointNetworkHandler;
import factorization.notify.RenderMessagesProxy;
import factorization.notify.Style;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;

@Mod(modid="factorization.notify", name="Factorization Notification System", version="1.0")
public class NotifyImplementation {
    public static final String modId = "factorization.notify";
    public static final String name = "Factorization Notification System";
    public static final String version = "1.0";
    @SidedProxy(clientSide="factorization.notify.RenderMessages", serverSide="factorization.notify.RenderMessagesProxy")
    public static RenderMessagesProxy proxy;
    public static NotifyNetwork net;
    public static NotifyImplementation instance;
    private static ArrayList<Notice> recuring_notifications;

    public NotifyImplementation() {
        instance = this;
        NotifyImplementation.loadBus(this);
        PointNetworkHandler.INSTANCE.initialize();
    }

    static void loadBus(Object obj) {
        FMLCommonHandler.instance().bus().register(obj);
        MinecraftForge.EVENT_BUS.register(obj);
    }

    @Mod.EventHandler
    public void setParent(FMLPreInitializationEvent event) {
        String FZ = "factorization";
        if (Loader.isModLoaded((String)"factorization")) {
            event.getModMetadata().parent = "factorization";
        }
    }

    @Mod.EventHandler
    public void registerServerCommands(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new MutterCommand());
    }

    void doSend(EntityPlayer player, Object where, World world, EnumSet<Style> style, ItemStack item, String format, String[] args) {
        if (where == null) {
            return;
        }
        if (player instanceof FakePlayer) {
            return;
        }
        format = this.styleMessage(style, format);
        if (player != null && player.field_70170_p.field_72995_K || FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            proxy.addMessage(where, item, format, args);
        } else {
            NetworkRegistry.TargetPoint target = null;
            if (player == null) {
                int range = style.contains((Object)Style.DRAWFAR) ? 128 : 32;
                int x = 0;
                int y = 0;
                int z = 0;
                boolean failed = false;
                if (where instanceof ISaneCoord) {
                    ISaneCoord c = (ISaneCoord)where;
                    world = c.w();
                    x = c.x();
                    y = c.y();
                    z = c.z();
                } else if (where instanceof TileEntity) {
                    TileEntity te = (TileEntity)where;
                    world = te.func_145831_w();
                    x = te.field_145851_c;
                    y = te.field_145848_d;
                    z = te.field_145849_e;
                } else if (where instanceof Entity) {
                    Entity ent = (Entity)where;
                    world = ent.field_70170_p;
                    x = (int)ent.field_70165_t;
                    y = (int)ent.field_70163_u;
                    z = (int)ent.field_70161_v;
                } else if (where instanceof Vec3) {
                    Vec3 vec = (Vec3)where;
                    x = (int)vec.field_72450_a;
                    y = (int)vec.field_72448_b;
                    z = (int)vec.field_72449_c;
                } else {
                    failed = true;
                }
                if (world != null && !failed) {
                    int dimension = world.func_72912_H().func_76076_i();
                    target = new NetworkRegistry.TargetPoint(dimension, (double)x, (double)y, (double)z, (double)range);
                }
            }
            if (args == null) {
                args = new String[]{};
            }
            FMLProxyPacket packet = NotifyNetwork.notifyPacket(where, item, format, args);
            NotifyNetwork.broadcast(packet, player, target);
        }
    }

    public static void recieve(EntityPlayer player, Object where, ItemStack item, String styledFormat, String[] args) {
        if (where == null) {
            return;
        }
        proxy.addMessage(where, item, styledFormat, args);
    }

    String styleMessage(EnumSet<Style> style, String format) {
        if (style == null) {
            return "\n" + format;
        }
        String prefix = "";
        String sep = "";
        for (Style s : style) {
            prefix = prefix + sep + s.toString();
            sep = " ";
        }
        return prefix + "\n" + format;
    }

    static EnumSet<Style> loadStyle(String firstLine) {
        EnumSet<Style> ret = EnumSet.noneOf(Style.class);
        for (String s : firstLine.split(" ")) {
            try {
                ret.add(Style.valueOf(s));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void updateRecuringNotifications(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ArrayList<Notice> arrayList = recuring_notifications;
        synchronized (arrayList) {
            Iterator<Notice> iterator = recuring_notifications.iterator();
            while (iterator.hasNext()) {
                Notice rn = iterator.next();
                if (!rn.isInvalid() && rn.updateNotice()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRecuringNotification(Notice newRN) {
        ArrayList<Notice> arrayList = recuring_notifications;
        synchronized (arrayList) {
            Iterator<Notice> iterator = recuring_notifications.iterator();
            while (iterator.hasNext()) {
                Notice rn = iterator.next();
                if (!rn.where.equals(newRN.where) || newRN.targetPlayer != null && newRN.targetPlayer != rn.targetPlayer) continue;
                iterator.remove();
            }
            recuring_notifications.add(newRN);
        }
    }

    void doSendOnscreenMessage(EntityPlayer player, String message, String[] formatArgs) {
        if (player.field_70170_p.field_72995_K) {
            proxy.onscreen(message, formatArgs);
        } else {
            FMLProxyPacket packet = NotifyNetwork.onscreenPacket(message, formatArgs);
            NotifyNetwork.broadcast(packet, player, null);
        }
    }

    void sendReplacableChatMessage(EntityPlayer player, IChatComponent msg, int msgKey) {
        if (player.field_70170_p.field_72995_K) {
            proxy.replaceable(msg, msgKey);
        } else {
            FMLProxyPacket packet = NotifyNetwork.replaceableChatPacket(msg, msgKey);
            NotifyNetwork.broadcast(packet, player, null);
        }
    }

    static {
        net = new NotifyNetwork();
        recuring_notifications = new ArrayList();
    }
}

